/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.textHighlighting;

import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.visallo.core.model.termMention.TermMentionFor;
import org.visallo.web.clientapi.model.SandboxStatus;

public abstract class OffsetItem
implements Comparable {
    public static final int VIDEO_TRANSCRIPT_INDEX_BITS = 12;
    public static final int VIDEO_TRANSCRIPT_OFFSET_BITS = 20;

    public abstract long getStart();

    public int getVideoTranscriptEntryIndex() {
        return (int)(this.getStart() >> 20);
    }

    public int getVideoTranscriptEntryOffset(int compacted) {
        int offsetMask = 4095;
        return compacted & offsetMask;
    }

    public abstract long getEnd();

    public abstract String getId();

    public abstract String getProcess();

    public abstract void setShouldBitShiftOffsetsForVideoTranscript(boolean var1);

    public String getOutVertexId() {
        return null;
    }

    public String getResolvedToVertexId() {
        return null;
    }

    public String getResolvedFromTermMentionId() {
        return null;
    }

    public String getResolvedToTermMentionId() {
        return null;
    }

    public String getResolvedToEdgeId() {
        return null;
    }

    public abstract TermMentionFor getTermMentionFor();

    public abstract String getTermMentionForElementId();

    public abstract SandboxStatus getSandboxStatus();

    public abstract String getClassIdentifier();

    public JSONObject getInfoJson() {
        try {
            JSONObject infoJson = new JSONObject();
            infoJson.put("id", (Object)this.getId());
            infoJson.put("start", this.getStart());
            infoJson.put("end", this.getEnd());
            infoJson.put("outVertexId", (Object)this.getOutVertexId());
            infoJson.put("sandboxStatus", (Object)this.getSandboxStatus().toString());
            if (this.getResolvedToVertexId() != null) {
                infoJson.put("resolvedToVertexId", (Object)this.getResolvedToVertexId());
            }
            if (this.getResolvedFromTermMentionId() != null) {
                infoJson.put("resolvedFromTermMentionId", (Object)this.getResolvedFromTermMentionId());
            }
            if (this.getTermMentionForElementId() != null) {
                infoJson.put("termMentionForElementId", (Object)this.getTermMentionForElementId());
            }
            if (this.getResolvedToEdgeId() != null) {
                infoJson.put("resolvedToEdgeId", (Object)this.getResolvedToEdgeId());
            }
            if (this.getTermMentionFor() != null) {
                infoJson.put("termMentionFor", (Object)this.getTermMentionFor().toString());
            }
            infoJson.put("process", (Object)this.getProcess());
            return infoJson;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getCssClasses() {
        boolean resolvable;
        boolean resolved;
        ArrayList<String> classes = new ArrayList<String>();
        boolean bl = resolved = this.getResolvedToVertexId() != null && this.getResolvedToEdgeId() != null;
        if (resolved) {
            classes.add("resolved");
        }
        TermMentionFor termMentionFor = this.getTermMentionFor();
        boolean bl2 = resolvable = !resolved && termMentionFor == null;
        if (resolvable) {
            classes.add("resolvable");
        } else if (!resolved) {
            classes.add("jref");
        }
        if (resolvable || resolved) {
            classes.add("res");
        }
        if (this.getClassIdentifier() != null) {
            classes.add(this.getClassIdentifier());
        }
        return classes;
    }

    public JSONObject toJson() {
        try {
            JSONObject json = new JSONObject();
            json.put("info", (Object)this.getInfoJson());
            JSONArray cssClasses = new JSONArray();
            for (String cssClass : this.getCssClasses()) {
                cssClasses.put((Object)cssClass);
            }
            json.put("cssClasses", (Object)cssClasses);
            return json;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean shouldHighlight() {
        return this.getResolvedToTermMentionId() == null;
    }

    public String getTitle() {
        return null;
    }

    public String toString() {
        return "id: " + this.getId() + ", start: " + this.getStart() + ", end: " + this.getEnd() + ", title: " + this.getTitle();
    }

    public int compareTo(Object o) {
        if (!(o instanceof OffsetItem)) {
            return -1;
        }
        OffsetItem other = (OffsetItem)o;
        if (OffsetItem.getOffset(this.getStart()) != OffsetItem.getOffset(other.getStart())) {
            return OffsetItem.getOffset(this.getStart()) < OffsetItem.getOffset(other.getStart()) ? -1 : 1;
        }
        if (OffsetItem.getOffset(this.getEnd()) != OffsetItem.getOffset(other.getEnd())) {
            return OffsetItem.getOffset(this.getEnd()) < OffsetItem.getOffset(other.getEnd()) ? -1 : 1;
        }
        int termMentionForCompare = TermMentionFor.compare(this.getTermMentionFor(), other.getTermMentionFor());
        if (termMentionForCompare != 0) {
            return termMentionForCompare;
        }
        if (this.getResolvedToVertexId() == null && other.getResolvedToVertexId() == null) {
            return 0;
        }
        if (this.getResolvedToVertexId() == null) {
            return 1;
        }
        if (other.getResolvedToVertexId() == null) {
            return -1;
        }
        return this.getResolvedToVertexId().compareTo(other.getResolvedToVertexId());
    }

    public static long getOffset(long offset) {
        return offset & 0xFFFFFL;
    }
}

