/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.textHighlighting;

import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import org.json.JSONException;
import org.json.JSONObject;
import org.vertexium.Authorizations;
import org.vertexium.Direction;
import org.vertexium.Element;
import org.vertexium.Vertex;
import org.vertexium.util.IterableUtils;
import org.visallo.core.model.Name;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.model.termMention.TermMentionFor;
import org.visallo.core.model.textHighlighting.OffsetItem;
import org.visallo.core.util.SourceInfoSnippetSanitizer;
import org.visallo.web.clientapi.model.SandboxStatus;

public class VertexOffsetItem
extends OffsetItem {
    private final Vertex termMention;
    private final SandboxStatus sandboxStatus;
    private final Authorizations authorizations;
    private final String classIdentifier;
    private boolean shouldBitShiftOffsetsForVideoTranscript = false;

    public VertexOffsetItem(Vertex termMention, SandboxStatus sandboxStatus, Authorizations authorizations) {
        this.termMention = termMention;
        this.sandboxStatus = sandboxStatus;
        this.authorizations = authorizations;
        this.classIdentifier = "tm-" + Hashing.sha1().hashString((CharSequence)termMention.getId()).toString();
        String[] authArray = this.authorizations.getAuthorizations();
        boolean hasTermMentionAuth = false;
        for (String auth : authArray) {
            if (!"termMention".equals(auth)) continue;
            hasTermMentionAuth = true;
        }
        Preconditions.checkArgument((boolean)hasTermMentionAuth, (Object)"termMention is a required auth");
    }

    @Override
    public void setShouldBitShiftOffsetsForVideoTranscript(boolean shouldBitShiftOffsetsForVideoTranscript) {
        this.shouldBitShiftOffsetsForVideoTranscript = shouldBitShiftOffsetsForVideoTranscript;
    }

    @Override
    public long getStart() {
        long start = VisalloProperties.TERM_MENTION_START_OFFSET.getPropertyValue((Element)this.termMention, 0L);
        if (this.shouldBitShiftOffsetsForVideoTranscript) {
            return this.getVideoTranscriptEntryOffset((int)start);
        }
        return start;
    }

    @Override
    public long getEnd() {
        long end = VisalloProperties.TERM_MENTION_END_OFFSET.getPropertyValue((Element)this.termMention, 0L);
        if (this.shouldBitShiftOffsetsForVideoTranscript) {
            return this.getVideoTranscriptEntryOffset((int)end);
        }
        return end;
    }

    public String getConceptIri() {
        return (String)VisalloProperties.TERM_MENTION_CONCEPT_TYPE.getPropertyValue((Element)this.termMention);
    }

    public String getSnippet() {
        return SourceInfoSnippetSanitizer.sanitizeSnippet(VisalloProperties.TERM_MENTION_SNIPPET.getPropertyValue((Element)this.termMention, null));
    }

    @Override
    public String getId() {
        return this.termMention.getId();
    }

    @Override
    public String getProcess() {
        String process = (String)VisalloProperties.TERM_MENTION_PROCESS.getPropertyValue((Element)this.termMention);
        if (process == null) {
            return null;
        }
        try {
            Class<?> cls = Class.forName(process);
            Name nameAnnotation = cls.getAnnotation(Name.class);
            if (nameAnnotation != null) {
                return nameAnnotation.value();
            }
            return cls.getSimpleName();
        }
        catch (ClassNotFoundException cnf) {
            return process;
        }
    }

    @Override
    public String getOutVertexId() {
        return (String)IterableUtils.singleOrDefault((Iterable)this.termMention.getVertexIds(Direction.IN, "http://visallo.org/termMention#hasTermMention", this.authorizations), null);
    }

    @Override
    public String getResolvedToVertexId() {
        return (String)IterableUtils.singleOrDefault((Iterable)this.termMention.getVertexIds(Direction.OUT, "http://visallo.org/termMention#resolvedTo", this.authorizations), null);
    }

    @Override
    public String getResolvedFromTermMentionId() {
        return (String)IterableUtils.singleOrDefault((Iterable)this.termMention.getVertexIds(Direction.OUT, "http://visallo.org/termMention#resolvedFrom", this.authorizations), null);
    }

    @Override
    public String getResolvedToTermMentionId() {
        return (String)IterableUtils.singleOrDefault((Iterable)this.termMention.getVertexIds(Direction.IN, "http://visallo.org/termMention#resolvedFrom", this.authorizations), null);
    }

    @Override
    public String getResolvedToEdgeId() {
        return (String)VisalloProperties.TERM_MENTION_RESOLVED_EDGE_ID.getPropertyValue((Element)this.termMention);
    }

    @Override
    public TermMentionFor getTermMentionFor() {
        return (TermMentionFor)((Object)VisalloProperties.TERM_MENTION_FOR_TYPE.getPropertyValue((Element)this.termMention));
    }

    @Override
    public String getTermMentionForElementId() {
        return (String)VisalloProperties.TERM_MENTION_FOR_ELEMENT_ID.getPropertyValue((Element)this.termMention);
    }

    @Override
    public SandboxStatus getSandboxStatus() {
        return this.sandboxStatus;
    }

    @Override
    public String getClassIdentifier() {
        return this.classIdentifier;
    }

    @Override
    public String getTitle() {
        return (String)VisalloProperties.TERM_MENTION_TITLE.getPropertyValue((Element)this.termMention);
    }

    @Override
    public boolean shouldHighlight() {
        return super.shouldHighlight();
    }

    @Override
    public JSONObject getInfoJson() {
        try {
            JSONObject infoJson = super.getInfoJson();
            infoJson.put("title", (Object)this.getTitle());
            infoJson.putOpt("conceptType", (Object)this.getConceptIri());
            infoJson.putOpt("snippet", (Object)this.getSnippet());
            return infoJson;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }
}

