/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.user;

import java.util.ArrayList;
import java.util.List;
import org.visallo.core.model.user.GraphAuthorizationRepository;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public class InMemoryGraphAuthorizationRepository
implements GraphAuthorizationRepository {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(InMemoryGraphAuthorizationRepository.class);
    private List<String> authorizations = new ArrayList<String>();

    @Override
    public void addAuthorizationToGraph(String ... auths) {
        for (String auth : auths) {
            auth = auth.trim();
            LOGGER.info("Adding authorization to graph user %s", auth);
            this.authorizations.add(auth);
        }
    }

    @Override
    public void removeAuthorizationFromGraph(String auth) {
        LOGGER.info("Removing authorization to graph user %s", auth);
        this.authorizations.remove(auth);
    }

    @Override
    public List<String> getGraphAuthorizations() {
        LOGGER.info("getting authorizations", new Object[0]);
        return new ArrayList<String>(this.authorizations);
    }
}

