/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.workQueue;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.vertexium.Authorizations;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.Graph;
import org.vertexium.Property;
import org.vertexium.Vertex;
import org.visallo.core.bootstrap.InjectHelper;
import org.visallo.core.config.Configuration;
import org.visallo.core.exception.VisalloAccessDeniedException;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.externalResource.ExternalResourceWorker;
import org.visallo.core.externalResource.QueueExternalResourceWorker;
import org.visallo.core.ingest.WorkerSpout;
import org.visallo.core.ingest.graphProperty.ElementOrPropertyStatus;
import org.visallo.core.ingest.graphProperty.GraphPropertyMessage;
import org.visallo.core.ingest.graphProperty.GraphPropertyRunner;
import org.visallo.core.model.FlushFlag;
import org.visallo.core.model.WorkQueueNames;
import org.visallo.core.model.notification.SystemNotification;
import org.visallo.core.model.notification.UserNotification;
import org.visallo.core.model.properties.MediaVisalloProperties;
import org.visallo.core.model.properties.types.VisalloPropertyUpdate;
import org.visallo.core.model.properties.types.VisalloPropertyUpdateRemove;
import org.visallo.core.model.user.AuthorizationRepository;
import org.visallo.core.model.user.UserRepository;
import org.visallo.core.model.workQueue.Priority;
import org.visallo.core.model.workspace.Workspace;
import org.visallo.core.model.workspace.WorkspaceRepository;
import org.visallo.core.model.workspace.WorkspaceUser;
import org.visallo.core.user.SystemUser;
import org.visallo.core.user.User;
import org.visallo.core.util.ClientApiConverter;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.clientapi.model.ClientApiWorkspace;
import org.visallo.web.clientapi.model.UserStatus;

public abstract class WorkQueueRepository {
    protected static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(WorkQueueRepository.class);
    private final Configuration configuration;
    private final WorkQueueNames workQueueNames;
    private final Graph graph;
    private GraphPropertyRunner graphPropertyRunner;
    private AuthorizationRepository authorizationRepository;
    private WorkspaceRepository workspaceRepository;
    private UserRepository userRepository;

    protected WorkQueueRepository(Graph graph, WorkQueueNames workQueueNames, Configuration configuration) {
        this.graph = graph;
        this.workQueueNames = workQueueNames;
        this.configuration = configuration;
    }

    public void pushGraphPropertyQueue(Element element, Property property, Priority priority) {
        Preconditions.checkNotNull((Object)property, (Object)"property cannot be null");
        this.pushGraphPropertyQueue(element, property.getKey(), property.getName(), priority);
    }

    public void pushGraphPropertyQueueHiddenOrDeleted(Element element, Property property, ElementOrPropertyStatus status, Long beforeActionTimestamp, String workspaceId, Priority priority) {
        Preconditions.checkNotNull((Object)property, (Object)"property cannot be null");
        this.pushGraphPropertyQueue(element, property, workspaceId, null, priority, status, beforeActionTimestamp);
    }

    public void pushGraphVisalloPropertyQueue(Element element, Iterable<VisalloPropertyUpdate> properties, Priority priority) {
        this.pushGraphVisalloPropertyQueue(element, properties, null, null, priority);
    }

    public void pushGraphVisalloPropertyQueue(Element element, Iterable<VisalloPropertyUpdate> properties, String workspaceId, String visibilitySource, Priority priority) {
        GraphPropertyMessage data = new GraphPropertyMessage();
        data.setPriority(priority);
        ArrayList<GraphPropertyMessage.Property> messageProperties = new ArrayList<GraphPropertyMessage.Property>();
        for (VisalloPropertyUpdate propertyUpdate : properties) {
            ElementOrPropertyStatus status;
            String propertyName;
            String propertyKey = propertyUpdate.getPropertyKey();
            if (this.shouldBroadcastGraphPropertyChange(element, propertyKey, propertyName = propertyUpdate.getPropertyName(), workspaceId, priority)) {
                this.broadcastPropertyChange(element, propertyKey, propertyName, workspaceId);
            }
            if (!this.canHandle(element, propertyKey, propertyName, status = ElementOrPropertyStatus.getStatus(propertyUpdate))) continue;
            Long beforeDeleteTimestamp = propertyUpdate instanceof VisalloPropertyUpdateRemove ? Long.valueOf(((VisalloPropertyUpdateRemove)propertyUpdate).getBeforeDeleteTimestamp()) : null;
            GraphPropertyMessage.Property property = new GraphPropertyMessage.Property();
            property.setPropertyKey(propertyKey);
            property.setPropertyName(propertyName);
            property.setStatus(status);
            property.setBeforeActionTimestamp(beforeDeleteTimestamp);
            messageProperties.add(property);
        }
        if (messageProperties.size() == 0) {
            return;
        }
        data.setProperties(messageProperties.toArray(new GraphPropertyMessage.Property[messageProperties.size()]));
        this.addElementTypeToJson(data, element);
        if (workspaceId != null && !workspaceId.equals("")) {
            data.setWorkspaceId(workspaceId);
            data.setVisibilitySource(visibilitySource);
        }
        this.pushOnQueue(this.workQueueNames.getGraphPropertyQueueName(), data.toBytes(), priority);
    }

    private void addElementTypeToJson(GraphPropertyMessage data, Element element) {
        if (element instanceof Vertex) {
            data.setGraphVertexId(new String[]{element.getId()});
        } else if (element instanceof Edge) {
            data.setGraphEdgeId(new String[]{element.getId()});
        } else {
            throw new VisalloException("Unexpected element type: " + element.getClass().getName());
        }
    }

    public void pushGraphPropertyQueue(Element element, Property property, String workspaceId, String visibilitySource, Priority priority) {
        this.pushGraphPropertyQueue(element, property.getKey(), property.getName(), workspaceId, visibilitySource, ElementOrPropertyStatus.UPDATE, null, priority);
    }

    public void pushGraphPropertyQueue(Element element, Property property, String workspaceId, String visibilitySource, Priority priority, FlushFlag flushFlag) {
        this.pushGraphPropertyQueue(element, property.getKey(), property.getName(), workspaceId, visibilitySource, priority, ElementOrPropertyStatus.UPDATE, null, flushFlag);
    }

    public void pushGraphPropertyQueue(Element element, Property property, String workspaceId, String visibilitySource, Priority priority, ElementOrPropertyStatus status, Long beforeActionTimestamp, FlushFlag flushFlag) {
        this.pushGraphPropertyQueue(element, property.getKey(), property.getName(), workspaceId, visibilitySource, priority, status, beforeActionTimestamp, flushFlag);
    }

    public void pushElementImageQueue(Element element, Property property, Priority priority) {
        this.pushElementImageQueue(element, property.getKey(), property.getName(), priority);
    }

    public void pushElementImageQueue(Element element, String propertyKey, String propertyName, Priority priority) {
        this.getGraph().flush();
        Preconditions.checkNotNull((Object)element);
        JSONObject data = new JSONObject();
        if (element instanceof Vertex) {
            data.put("graphVertexId", (Object)element.getId());
        } else if (element instanceof Edge) {
            data.put("graphEdgeId", (Object)element.getId());
        } else {
            throw new VisalloException("Unexpected element type: " + element.getClass().getName());
        }
        data.put("propertyKey", (Object)propertyKey);
        data.put("propertyName", (Object)propertyName);
        this.pushOnQueue(this.workQueueNames.getGraphPropertyQueueName(), FlushFlag.DEFAULT, data, priority);
        this.broadcastEntityImage(element, propertyKey, propertyName);
    }

    public void pushGraphPropertyQueue(Element element, String propertyKey, String propertyName, Priority priority) {
        this.pushGraphPropertyQueue(element, propertyKey, propertyName, ElementOrPropertyStatus.UPDATE, null, priority);
    }

    public void pushGraphPropertyQueue(Element element, String propertyKey, String propertyName, Long beforeActionTimestamp, Priority priority) {
        this.pushGraphPropertyQueue(element, propertyKey, propertyName, ElementOrPropertyStatus.UPDATE, beforeActionTimestamp, priority);
    }

    public void pushGraphPropertyQueue(Element element, String propertyKey, String propertyName, ElementOrPropertyStatus status, Long beforeActionTimestamp, Priority priority) {
        this.pushGraphPropertyQueue(element, propertyKey, propertyName, null, null, status, beforeActionTimestamp, priority);
    }

    public void pushGraphPropertyQueue(Element element, String propertyKey, String propertyName, String workspaceId, String visibilitySource, Priority priority) {
        this.pushGraphPropertyQueue(element, propertyKey, propertyName, workspaceId, visibilitySource, priority, ElementOrPropertyStatus.UPDATE, null, FlushFlag.DEFAULT);
    }

    public void pushGraphPropertyQueue(Element element, String propertyKey, String propertyName, String workspaceId, String visibilitySource, ElementOrPropertyStatus status, Long beforeActionTimestamp, Priority priority) {
        this.pushGraphPropertyQueue(element, propertyKey, propertyName, workspaceId, visibilitySource, priority, status, beforeActionTimestamp, FlushFlag.DEFAULT);
    }

    public void pushMultipleGraphPropertyQueue(Iterable<? extends Element> elements, String propertyKey, String propertyName, String workspaceId, String visibilitySource, Priority priority, ElementOrPropertyStatus status, Long beforeActionTimestamp, FlushFlag flushFlag) {
        Preconditions.checkNotNull(elements);
        if (!elements.iterator().hasNext()) {
            return;
        }
        this.getGraph().flush();
        GraphPropertyMessage data = this.createPropertySpecificMessage(propertyKey, propertyName, workspaceId, visibilitySource, status, beforeActionTimestamp, priority);
        ArrayList<String> vertices = new ArrayList<String>();
        ArrayList<String> edges = new ArrayList<String>();
        for (Element element : elements) {
            if (!this.canHandle(element, propertyKey, propertyName, status)) continue;
            if (element instanceof Vertex) {
                vertices.add(element.getId());
                continue;
            }
            if (element instanceof Edge) {
                edges.add(element.getId());
                continue;
            }
            throw new VisalloException("Unexpected element type: " + element.getClass().getName());
        }
        data.setGraphVertexId(vertices.toArray(new String[vertices.size()]));
        data.setGraphEdgeId(edges.toArray(new String[edges.size()]));
        this.pushOnQueue(this.workQueueNames.getGraphPropertyQueueName(), data.toBytes(), priority);
        for (Element element : elements) {
            if (!this.shouldBroadcastGraphPropertyChange(element, propertyKey, propertyName, workspaceId, priority)) continue;
            this.broadcastPropertyChange(element, propertyKey, propertyName, workspaceId);
        }
    }

    public void pushGraphPropertyQueue(Element element, Property property, String workspaceId, String visibilitySource, Priority priority, ElementOrPropertyStatus status, Long beforeDeleteTimestamp) {
        this.getGraph().flush();
        Preconditions.checkNotNull((Object)element);
        String propertyKey = property.getKey();
        String propertyName = property.getName();
        GraphPropertyMessage data = this.createPropertySpecificMessage(propertyKey, propertyName, workspaceId, visibilitySource, status, beforeDeleteTimestamp, priority);
        this.addElementTypeToJson(data, element);
        if (this.canHandle(element, property, status)) {
            this.pushOnQueue(this.workQueueNames.getGraphPropertyQueueName(), data.toBytes(), priority);
        }
        if (this.shouldBroadcastGraphPropertyChange(element, propertyKey, propertyName, workspaceId, priority)) {
            this.broadcastPropertyChange(element, propertyKey, propertyName, workspaceId);
        }
    }

    public void pushGraphPropertyQueue(Element element, String propertyKey, String propertyName, String workspaceId, String visibilitySource, Priority priority, ElementOrPropertyStatus status, Long beforeDeleteTimestamp, @Deprecated FlushFlag flushFlag) {
        this.getGraph().flush();
        Preconditions.checkNotNull((Object)element);
        GraphPropertyMessage data = this.createPropertySpecificMessage(propertyKey, propertyName, workspaceId, visibilitySource, status, beforeDeleteTimestamp, priority);
        this.addElementTypeToJson(data, element);
        if (this.canHandle(element, propertyKey, propertyName, status)) {
            this.pushOnQueue(this.workQueueNames.getGraphPropertyQueueName(), data.toBytes(), priority);
        }
        if (this.shouldBroadcastGraphPropertyChange(element, propertyKey, propertyName, workspaceId, priority)) {
            this.broadcastPropertyChange(element, propertyKey, propertyName, workspaceId);
        }
    }

    private boolean canHandle(Element element, Property property, ElementOrPropertyStatus status) {
        String propertyKey = property == null ? null : property.getKey();
        String propertyName = property == null ? null : property.getName();
        return this.canHandle(element, propertyKey, propertyName, status);
    }

    private boolean canHandle(Element element, String propertyKey, String propertyName, ElementOrPropertyStatus status) {
        if (this.graphPropertyRunner == null) {
            return true;
        }
        if (propertyKey == null && propertyName == null) {
            return true;
        }
        return this.graphPropertyRunner.canHandle(element, propertyKey, propertyName, status);
    }

    private GraphPropertyMessage createPropertySpecificMessage(String propertyKey, String propertyName, String workspaceId, String visibilitySource, ElementOrPropertyStatus status, Long beforeActionTimestamp, Priority priority) {
        GraphPropertyMessage data = new GraphPropertyMessage();
        if (workspaceId != null && !workspaceId.equals("")) {
            data.setWorkspaceId(workspaceId);
            data.setVisibilitySource(visibilitySource);
        }
        data.setPropertyKey(propertyKey);
        data.setPropertyName(propertyName);
        data.setStatus(status);
        data.setPriority(priority);
        if (status == ElementOrPropertyStatus.DELETION || status == ElementOrPropertyStatus.HIDDEN) {
            Preconditions.checkNotNull((Object)beforeActionTimestamp, (Object)("Timestamp before " + (Object)((Object)status) + " cannot be null"));
        }
        data.setBeforeActionTimestamp(beforeActionTimestamp);
        return data;
    }

    public void pushGraphPropertyQueue(Element element, Priority priority) {
        this.pushGraphPropertyQueue(element, null, null, priority, FlushFlag.DEFAULT);
    }

    public void pushGraphPropertyQueue(Element element, String workspaceId, String visibilitySource, Priority priority, FlushFlag flushFlag) {
        this.getGraph().flush();
        Preconditions.checkNotNull((Object)element);
        GraphPropertyMessage data = new GraphPropertyMessage();
        data.setPriority(priority);
        this.addElementTypeToJson(data, element);
        if (workspaceId != null && !workspaceId.equals("")) {
            data.setWorkspaceId(workspaceId);
            data.setVisibilitySource(visibilitySource);
        }
        if (this.canHandle(element, null, null)) {
            this.pushOnQueue(this.workQueueNames.getGraphPropertyQueueName(), data.toBytes(), priority);
        }
    }

    public void pushVertexIds(Iterable<String> vertexIds, Priority priority, FlushFlag flushFlag) {
        for (String vertexId : vertexIds) {
            this.pushVertexId(vertexId, priority, flushFlag);
        }
    }

    private void pushVertexId(String vertexId, Priority priority, FlushFlag flushFlag) {
        GraphPropertyMessage data = new GraphPropertyMessage();
        data.setPriority(priority);
        data.setGraphVertexId(new String[]{vertexId});
        this.pushOnQueue(this.workQueueNames.getGraphPropertyQueueName(), data.toBytes(), priority);
    }

    protected boolean shouldBroadcastGraphPropertyChange(Element element, String propertyKey, String propertyName, String workspaceId, Priority priority) {
        return this.shouldBroadcast(priority) && !MediaVisalloProperties.VIDEO_FRAME.getPropertyName().equals(propertyName);
    }

    protected boolean shouldBroadcastTextUpdate(String vertexId, Priority priority) {
        return this.shouldBroadcast(priority);
    }

    protected boolean shouldBroadcast(Priority priority) {
        return priority != Priority.LOW;
    }

    public void pushLongRunningProcessQueue(JSONObject queueItem) {
        this.pushLongRunningProcessQueue(queueItem, Priority.NORMAL);
    }

    public void pushLongRunningProcessQueue(JSONObject queueItem, Priority priority) {
        this.broadcastLongRunningProcessChange(queueItem);
        this.pushOnQueue(this.workQueueNames.getLongRunningProcessQueueName(), FlushFlag.DEFAULT, queueItem, priority);
    }

    public void broadcast(String type, JSONObject data, JSONObject permissions) {
        Preconditions.checkNotNull((Object)type);
        JSONObject json = new JSONObject();
        json.putOpt("permissions", (Object)permissions);
        json.putOpt("data", (Object)data);
        json.put("type", (Object)type);
        this.broadcastJson(json);
    }

    public void broadcastLongRunningProcessDeleted(JSONObject longRunningProcessQueueItem) {
        String userId = longRunningProcessQueueItem.optString("userId");
        Preconditions.checkNotNull((Object)userId, (Object)"userId cannot be null");
        JSONObject json = new JSONObject();
        json.put("type", (Object)"longRunningProcessDeleted");
        JSONObject permissions = new JSONObject();
        JSONArray users = new JSONArray();
        users.put((Object)userId);
        permissions.put("users", (Object)users);
        json.put("permissions", (Object)permissions);
        JSONObject data = new JSONObject();
        data.put("processId", longRunningProcessQueueItem.get("id"));
        json.put("data", (Object)data);
        this.broadcastJson(json);
    }

    public void broadcastLongRunningProcessChange(JSONObject longRunningProcessQueueItem) {
        String userId = longRunningProcessQueueItem.optString("userId");
        Preconditions.checkNotNull((Object)userId, (Object)"userId cannot be null");
        JSONObject json = new JSONObject();
        json.put("type", (Object)"longRunningProcessChange");
        JSONObject permissions = new JSONObject();
        JSONArray users = new JSONArray();
        users.put((Object)userId);
        permissions.put("users", (Object)users);
        json.put("permissions", (Object)permissions);
        JSONObject dataJson = new JSONObject(longRunningProcessQueueItem.toString());
        if (dataJson.has("results")) {
            dataJson.remove("results");
        }
        json.put("data", (Object)dataJson);
        this.broadcastJson(json);
    }

    public void broadcastWorkProductAncillaryChange(String workProductId, String workspaceId, String ancillaryId, User user, String skipSourceGuid) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"workProductAncillaryChange");
        json.put("permissions", (Object)this.getPermissionsWithWorkspace(workspaceId));
        JSONObject dataJson = new JSONObject();
        dataJson.put("id", (Object)ancillaryId);
        dataJson.put("workspaceId", (Object)workspaceId);
        dataJson.put("productId", (Object)workProductId);
        dataJson.putOpt("sourceGuid", (Object)skipSourceGuid);
        json.put("data", (Object)dataJson);
        this.broadcastJson(json);
    }

    public void broadcastWorkProductChange(String workProductId, String workspaceId, User user, String skipSourceGuid) {
        this.broadcastWorkProductChange(workProductId, skipSourceGuid, workspaceId, this.getPermissionsWithWorkspace(workspaceId));
    }

    public void broadcastWorkProductChange(String workProductId, ClientApiWorkspace workspace, User user, String skipSourceGuid) {
        this.broadcastWorkProductChange(workProductId, skipSourceGuid, workspace.getWorkspaceId(), this.getPermissionsWithUsers(workspace, null));
    }

    public void broadcastWorkProductPreviewChange(String workProductId, String workspaceId, User user, String md5) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"workProductPreviewChange");
        JSONObject permissions = new JSONObject();
        JSONArray users = new JSONArray();
        users.put((Object)user.getUserId());
        permissions.put("users", (Object)users);
        json.put("permissions", (Object)permissions);
        JSONObject dataJson = new JSONObject();
        dataJson.put("id", (Object)workProductId);
        dataJson.put("workspaceId", (Object)workspaceId);
        dataJson.putOpt("md5", (Object)md5);
        json.put("data", (Object)dataJson);
        this.broadcastJson(json);
    }

    public void broadcastWorkProductDelete(String workProductId, ClientApiWorkspace workspace) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"workProductDelete");
        json.put("permissions", (Object)this.getPermissionsWithUsers(workspace, null));
        JSONObject dataJson = new JSONObject();
        dataJson.put("id", (Object)workProductId);
        json.put("data", (Object)dataJson);
        this.broadcastJson(json);
    }

    public void broadcastElement(Element element, String workspaceId) {
        this.broadcastPropertyChange(element, null, null, workspaceId);
    }

    public void pushElement(Element element, Priority priority) {
        this.pushGraphPropertyQueue(element, null, null, priority);
    }

    public void pushElement(Element element, long beforeDeletionTimestamp, Priority priority) {
        this.pushGraphPropertyQueue(element, (String)null, null, beforeDeletionTimestamp, priority);
    }

    @Deprecated
    public void pushElements(Iterable<? extends Element> elements) {
        this.pushElements(elements, Priority.NORMAL);
    }

    public void pushElements(Iterable<? extends Element> elements, Priority priority) {
        this.pushMultipleGraphPropertyQueue(elements, null, null, null, null, priority, ElementOrPropertyStatus.UPDATE, null, FlushFlag.DEFAULT);
    }

    public void pushElement(Element element) {
        this.pushElement(element, Priority.NORMAL);
    }

    public void pushEdgeDeletion(Edge edge, long beforeDeletionTimestamp, Priority priority) {
        this.broadcastEdgeDeletion(edge);
        this.pushGraphPropertyQueue((Element)edge, null, null, ElementOrPropertyStatus.DELETION, beforeDeletionTimestamp, priority);
    }

    public void pushPublishedEdgeDeletion(Edge edge, long beforeDeletionTimestamp, Priority priority) {
        this.broadcastPublishEdgeDelete(edge);
        this.pushGraphPropertyQueue((Element)edge, null, null, ElementOrPropertyStatus.DELETION, beforeDeletionTimestamp, priority);
    }

    public void pushPublishedVertexDeletion(Vertex vertex, long beforeDeletionTimestamp, Priority priority) {
        this.broadcastPublishVertexDelete(vertex);
        this.pushGraphPropertyQueue((Element)vertex, null, null, ElementOrPropertyStatus.DELETION, beforeDeletionTimestamp, priority);
    }

    public void pushPublishedPropertyDeletion(Element element, String key, String name, long beforeDeletionTimestamp, Priority priority) {
        this.broadcastPublishPropertyDelete(element, key, name);
        this.pushGraphPropertyQueue(element, key, name, ElementOrPropertyStatus.DELETION, beforeDeletionTimestamp, priority);
    }

    public void pushUndoPublicPropertyDeletion(Element element, String key, String name, Priority priority) {
        this.broadcastUndoPropertyDelete(element, key, name);
        this.pushGraphPropertyQueue(element, key, name, ElementOrPropertyStatus.UNHIDDEN, null, priority);
    }

    public void pushUndoSandboxProperty(Element element, String key, String name, long beforeDeletionTimestamp, Priority priority) {
        this.broadcastUndoPropertyDelete(element, key, name);
        this.pushGraphPropertyQueue(element, key, name, ElementOrPropertyStatus.DELETION, beforeDeletionTimestamp, priority);
    }

    public void pushEdgeHidden(Edge edge, long beforeHiddenTimestamp, Priority priority) {
        this.broadcastEdgeDeletion(edge);
        this.pushGraphPropertyQueue((Element)edge, null, null, ElementOrPropertyStatus.HIDDEN, beforeHiddenTimestamp, priority);
    }

    public void pushEdgeUnhidden(Edge edge, Priority priority) {
        this.broadcastUndoEdgeDelete(edge);
        this.pushGraphPropertyQueue((Element)edge, null, null, ElementOrPropertyStatus.UNHIDDEN, null, priority);
    }

    public void pushVertexUnhidden(Vertex vertex, Priority priority) {
        this.broadcastUndoVertexDelete(vertex);
        this.pushGraphPropertyQueue((Element)vertex, null, null, ElementOrPropertyStatus.UNHIDDEN, null, priority);
    }

    protected void broadcastEdgeDeletion(Edge edge) {
        JSONObject dataJson = new JSONObject();
        if (edge != null) {
            dataJson.put("edgeId", (Object)edge.getId());
            dataJson.put("outVertexId", (Object)edge.getVertexId(Direction.OUT));
            dataJson.put("inVertexId", (Object)edge.getVertexId(Direction.IN));
        }
        JSONObject json = new JSONObject();
        json.put("type", (Object)"edgeDeletion");
        json.put("data", (Object)dataJson);
        this.broadcastJson(json);
    }

    public void pushVertexDeletion(Vertex vertex, long beforeDeletionTimestamp, Priority priority) {
        this.pushVertexDeletion(vertex.getId());
        this.pushGraphPropertyQueue((Element)vertex, null, null, ElementOrPropertyStatus.DELETION, beforeDeletionTimestamp, priority);
    }

    public void pushVertexHidden(Vertex vertex, long beforeHiddenTimestamp, Priority priority) {
        this.pushVertexDeletion(vertex.getId());
        this.pushGraphPropertyQueue((Element)vertex, null, null, ElementOrPropertyStatus.HIDDEN, beforeHiddenTimestamp, priority);
    }

    public void pushVertexDeletion(String vertexId) {
        JSONArray verticesDeleted = new JSONArray();
        verticesDeleted.put((Object)vertexId);
        this.broadcastVerticesDeletion(verticesDeleted);
    }

    public void pushVerticesDeletion(JSONArray verticesDeleted) {
        this.broadcastVerticesDeletion(verticesDeleted);
    }

    protected void broadcastVerticesDeletion(JSONArray verticesDeleted) {
        JSONObject dataJson = new JSONObject();
        if (verticesDeleted != null) {
            dataJson.put("vertexIds", (Object)verticesDeleted);
        }
        JSONObject json = new JSONObject();
        json.put("type", (Object)"verticesDeleted");
        json.put("data", (Object)dataJson);
        this.broadcastJson(json);
    }

    public void pushOntologyChange(String workspaceId) {
        this.pushOntologyChange(workspaceId, null, null, null);
    }

    public void pushOntologyChange(String workspaceId, Iterable<String> conceptIds, Iterable<String> relationshipIds, Iterable<String> propertyIds) {
        this.pushOntologyChange(workspaceId, OntologyAction.Update, conceptIds, relationshipIds, propertyIds);
    }

    public void pushOntologyChange(String workspaceId, OntologyAction action, Iterable<String> conceptIds, Iterable<String> relationshipIds, Iterable<String> propertyIds) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"ontologyChange");
        JSONObject data = new JSONObject();
        data.put("action", (Object)action.toString());
        data.put("idType", (Object)(action.equals((Object)OntologyAction.Update) ? "id" : "iri"));
        if (workspaceId != null) {
            data.put("workspaceId", (Object)workspaceId);
            json.put("permissions", (Object)this.getPermissionsWithWorkspace(workspaceId));
        }
        if (conceptIds != null || relationshipIds != null || propertyIds != null) {
            data.put("conceptIds", (Object)(conceptIds == null ? new JSONArray() : new JSONArray((Collection)Sets.newHashSet(conceptIds))));
            data.put("propertyIds", (Object)(propertyIds == null ? new JSONArray() : new JSONArray((Collection)Sets.newHashSet(propertyIds))));
            data.put("relationshipIds", (Object)(relationshipIds == null ? new JSONArray() : new JSONArray((Collection)Sets.newHashSet(relationshipIds))));
        }
        json.put("data", (Object)data);
        this.broadcastJson(json);
    }

    public void pushOntologyConceptsChange(String workspaceId, List<String> ids) {
        this.pushOntologyChange(workspaceId, ids, null, null);
    }

    public void pushOntologyConceptsChange(String workspaceId, String ... ids) {
        this.pushOntologyChange(workspaceId, Arrays.asList(ids), null, null);
    }

    public void pushOntologyPropertiesChange(String workspaceId, String ... ids) {
        this.pushOntologyChange(workspaceId, null, null, Arrays.asList(ids));
    }

    public void pushOntologyPropertiesChange(String workspaceId, List<String> ids) {
        this.pushOntologyChange(workspaceId, null, null, ids);
    }

    public void pushOntologyRelationshipsChange(String workspaceId, List<String> ids) {
        this.pushOntologyChange(workspaceId, null, ids, null);
    }

    public void pushOntologyRelationshipsChange(String workspaceId, String ... ids) {
        this.pushOntologyChange(workspaceId, null, Arrays.asList(ids), null);
    }

    public void pushTextUpdated(String vertexId) {
        this.pushTextUpdated(vertexId, Priority.NORMAL);
    }

    public void pushTextUpdated(String vertexId, Priority priority) {
        if (this.shouldBroadcastTextUpdate(vertexId, priority)) {
            this.broadcastTextUpdated(vertexId);
        }
    }

    protected void broadcastTextUpdated(String vertexId) {
        JSONObject dataJson = new JSONObject();
        if (vertexId != null) {
            dataJson.put("graphVertexId", (Object)vertexId);
        }
        JSONObject json = new JSONObject();
        json.put("type", (Object)"textUpdated");
        json.put("data", (Object)dataJson);
        this.broadcastJson(json);
    }

    public void pushUserAccessChange(User user) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"userAccessChange");
        json.put("permissions", (Object)this.getPermissionsWithUserIds(user.getUserId()));
        json.put("data", (Object)this.getUserRepository().toJsonWithAuths(user));
        this.broadcastJson(json);
    }

    public void pushUserStatusChange(User user, UserStatus status) {
        this.broadcastUserStatusChange(user, status);
    }

    protected void broadcastUserStatusChange(User user, UserStatus status) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"userStatusChange");
        JSONObject data = UserRepository.toJson(user);
        data.put("status", (Object)status.toString());
        json.put("data", (Object)data);
        this.broadcastJson(json);
    }

    public void pushUserCurrentWorkspaceChange(User user, String workspaceId) {
        this.broadcastUserWorkspaceChange(user, workspaceId);
    }

    public void pushWorkspaceChange(ClientApiWorkspace workspace, List<ClientApiWorkspace.User> previousUsers, String changedByUserId, String changedBySourceGuid) {
        this.broadcastWorkspace(workspace, previousUsers, changedByUserId, changedBySourceGuid);
    }

    protected void broadcastWorkProductChange(String workProductId, String skipSourceGuid, String workspaceId, JSONObject permissions) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"workProductChange");
        json.put("permissions", (Object)permissions);
        JSONObject dataJson = new JSONObject();
        dataJson.put("id", (Object)workProductId);
        dataJson.put("workspaceId", (Object)workspaceId);
        dataJson.putOpt("sourceGuid", (Object)skipSourceGuid);
        json.put("data", (Object)dataJson);
        this.broadcastJson(json);
    }

    protected void broadcastUserWorkspaceChange(User user, String workspaceId) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"userWorkspaceChange");
        JSONObject data = UserRepository.toJson(user);
        data.put("workspaceId", (Object)workspaceId);
        json.put("data", (Object)data);
        this.broadcastJson(json);
    }

    protected void broadcastWorkspace(ClientApiWorkspace workspace, List<ClientApiWorkspace.User> previousUsers, String changedByUserId, String changedBySourceGuid) {
        User changedByUser = this.getUserRepository().findById(changedByUserId);
        Workspace ws = this.getWorkspaceRepository().findById(workspace.getWorkspaceId(), changedByUser);
        previousUsers.forEach(workspaceUser -> {
            boolean isChangingUser = workspaceUser.getUserId().equals(changedByUserId);
            User user = isChangingUser ? changedByUser : this.getUserRepository().findById(workspaceUser.getUserId());
            Authorizations authorizations = this.getAuthorizationRepository().getGraphAuthorizations(user, workspace.getWorkspaceId());
            try {
                ClientApiWorkspace userWorkspace = isChangingUser ? workspace : this.getWorkspaceRepository().toClientApi(ws, user, authorizations);
                JSONObject json = new JSONObject();
                json.put("type", (Object)"workspaceChange");
                json.put("modifiedBy", (Object)changedByUserId);
                json.put("permissions", (Object)this.getPermissionsWithUsers(null, Arrays.asList(workspaceUser)));
                json.put("data", (Object)new JSONObject(ClientApiConverter.clientApiToString((Object)userWorkspace)));
                json.putOpt("sourceGuid", (Object)changedBySourceGuid);
                this.broadcastJson(json);
            }
            catch (VisalloAccessDeniedException visalloAccessDeniedException) {
                // empty catch block
            }
        });
    }

    public void pushWorkspaceDelete(ClientApiWorkspace workspace) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"workspaceDelete");
        json.put("permissions", (Object)this.getPermissionsWithUsers(workspace, null));
        json.put("workspaceId", (Object)workspace.getWorkspaceId());
        this.broadcastJson(json);
    }

    public void pushWorkspaceDelete(String workspaceId, String userId) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"workspaceDelete");
        JSONObject permissions = new JSONObject();
        JSONArray users = new JSONArray();
        users.put((Object)userId);
        permissions.put("users", (Object)users);
        json.put("permissions", (Object)permissions);
        json.put("workspaceId", (Object)workspaceId);
        this.broadcastJson(json);
    }

    private JSONObject getPermissionsWithUserIds(String ... userIds) {
        JSONObject permissions = new JSONObject();
        JSONArray users = new JSONArray();
        for (String userId : userIds) {
            users.put((Object)userId);
        }
        permissions.put("users", (Object)users);
        return permissions;
    }

    private JSONObject getPermissionsWithWorkspace(String workspaceId) {
        List<WorkspaceUser> users = this.getWorkspaceRepository().findUsersWithAccess(workspaceId, new SystemUser());
        return this.getPermissionsWithUsers(users);
    }

    private JSONObject getPermissionsWithUsers(List<WorkspaceUser> workspaceUsers) {
        JSONObject permissions = new JSONObject();
        JSONArray users = new JSONArray();
        if (workspaceUsers != null) {
            for (WorkspaceUser workspaceUser : workspaceUsers) {
                users.put((Object)workspaceUser.getUserId());
            }
        }
        permissions.put("users", (Object)users);
        return permissions;
    }

    private JSONObject getPermissionsWithUsers(ClientApiWorkspace workspace, List<ClientApiWorkspace.User> previousUsers) {
        JSONObject permissions = new JSONObject();
        JSONArray users = new JSONArray();
        if (previousUsers != null) {
            for (ClientApiWorkspace.User user : previousUsers) {
                users.put((Object)user.getUserId());
            }
        }
        if (workspace != null) {
            for (ClientApiWorkspace.User user : workspace.getUsers()) {
                users.put((Object)user.getUserId());
            }
        }
        permissions.put("users", (Object)users);
        return permissions;
    }

    public void pushSessionExpiration(String userId, String sessionId) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"sessionExpiration");
        JSONObject permissions = new JSONObject();
        JSONArray users = new JSONArray();
        users.put((Object)userId);
        permissions.put("users", (Object)users);
        JSONArray sessionIds = new JSONArray();
        sessionIds.put((Object)sessionId);
        permissions.put("sessionIds", (Object)sessionIds);
        json.put("permissions", (Object)permissions);
        json.putOpt("sessionId", (Object)sessionId);
        this.broadcastJson(json);
    }

    public void pushUserNotification(UserNotification notification) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"notification");
        JSONObject permissions = new JSONObject();
        JSONArray users = new JSONArray();
        users.put((Object)notification.getUserId());
        permissions.put("users", (Object)users);
        json.put("permissions", (Object)permissions);
        JSONObject data = new JSONObject();
        json.put("data", (Object)data);
        data.put("notification", (Object)notification.toJSONObject());
        this.broadcastJson(json);
    }

    public void pushSystemNotification(SystemNotification notification) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"notification");
        JSONObject data = new JSONObject();
        json.put("data", (Object)data);
        data.put("notification", (Object)notification.toJSONObject());
        this.broadcastJson(json);
    }

    public void pushSystemNotificationUpdate(SystemNotification notification) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"systemNotificationUpdated");
        JSONObject data = new JSONObject();
        json.put("data", (Object)data);
        data.put("notification", (Object)notification.toJSONObject());
        this.broadcastJson(json);
    }

    public void pushSystemNotificationEnded(String notificationId) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"systemNotificationEnded");
        JSONObject data = new JSONObject();
        json.put("data", (Object)data);
        data.put("notificationId", (Object)notificationId);
        this.broadcastJson(json);
    }

    protected void broadcastPropertyChange(Element element, String propertyKey, String propertyName, String workspaceId) {
        try {
            JSONObject json;
            if (element instanceof Vertex) {
                json = this.getBroadcastPropertyChangeJson((Vertex)element, propertyKey, propertyName, workspaceId);
            } else if (element instanceof Edge) {
                json = this.getBroadcastPropertyChangeJson((Edge)element, propertyKey, propertyName, workspaceId);
            } else {
                throw new VisalloException("Unexpected element type: " + element.getClass().getName());
            }
            this.broadcastJson(json);
        }
        catch (Exception ex) {
            throw new VisalloException("Could not broadcast property change", ex);
        }
    }

    protected void broadcastEntityImage(Element element, String propertyKey, String propertyName) {
        try {
            JSONObject json = this.getBroadcastEntityImageJson((Vertex)element);
            this.broadcastJson(json);
        }
        catch (Exception ex) {
            throw new VisalloException("Could not broadcast property change", ex);
        }
    }

    protected abstract void broadcastJson(JSONObject var1);

    protected JSONObject getBroadcastEntityImageJson(Vertex graphVertex) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"entityImageUpdated");
        JSONObject dataJson = new JSONObject();
        dataJson.put("graphVertexId", (Object)graphVertex.getId());
        json.put("data", (Object)dataJson);
        return json;
    }

    protected JSONObject getBroadcastPropertyChangeJson(Vertex graphVertex, String propertyKey, String propertyName, String workspaceId) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"propertyChange");
        JSONObject dataJson = new JSONObject();
        dataJson.put("graphVertexId", (Object)graphVertex.getId());
        dataJson.putOpt("workspaceId", (Object)workspaceId);
        json.put("data", (Object)dataJson);
        return json;
    }

    protected JSONObject getBroadcastPropertyChangeJson(Edge edge, String propertyKey, String propertyName, String workspaceId) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"propertyChange");
        JSONObject dataJson = new JSONObject();
        dataJson.put("graphEdgeId", (Object)edge.getId());
        dataJson.put("outVertexId", (Object)edge.getVertexId(Direction.OUT));
        dataJson.put("inVertexId", (Object)edge.getVertexId(Direction.IN));
        dataJson.putOpt("workspaceId", (Object)workspaceId);
        json.put("data", (Object)dataJson);
        return json;
    }

    public final void pushOnQueue(String queueName, @Deprecated FlushFlag flushFlag, JSONObject json, Priority priority) {
        if (priority != null) {
            json.put("priority", (Object)priority.name());
        }
        this.pushOnQueue(queueName, json.toString().getBytes(), priority);
    }

    public abstract void pushOnQueue(String var1, byte[] var2, Priority var3);

    public void init(Map map) {
    }

    public abstract void flush();

    public void format() {
        for (String queueName : this.getQueueNames()) {
            LOGGER.info("deleting queue: %s", queueName);
            this.deleteQueue(queueName);
        }
    }

    protected abstract void deleteQueue(String var1);

    protected Iterable<String> getQueueNames() {
        ArrayList<String> queueNames = new ArrayList<String>();
        queueNames.add(this.getWorkQueueNames().getGraphPropertyQueueName());
        queueNames.add(this.getWorkQueueNames().getLongRunningProcessQueueName());
        Collection<ExternalResourceWorker> externalResourceWorkers = InjectHelper.getInjectedServices(ExternalResourceWorker.class, this.getConfiguration());
        for (ExternalResourceWorker externalResourceWorker : externalResourceWorkers) {
            if (!(externalResourceWorker instanceof QueueExternalResourceWorker)) continue;
            String queueName = ((QueueExternalResourceWorker)externalResourceWorker).getQueueName();
            queueNames.add(queueName);
        }
        return queueNames;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public abstract void subscribeToBroadcastMessages(BroadcastConsumer var1);

    public abstract void unsubscribeFromBroadcastMessages(BroadcastConsumer var1);

    public abstract WorkerSpout createWorkerSpout(String var1);

    public void broadcastPublishVertexDelete(Vertex vertex) {
        this.broadcastPublish((Element)vertex, PublishType.DELETE);
    }

    public void broadcastPublishVertex(Vertex vertex) {
        this.broadcastPublish((Element)vertex, PublishType.TO_PUBLIC);
    }

    public void broadcastUndoVertexDelete(Vertex vertex) {
        this.broadcastPublish((Element)vertex, PublishType.UNDO_DELETE);
    }

    public void broadcastUndoVertex(Vertex vertex) {
        this.broadcastPublish((Element)vertex, PublishType.UNDO);
    }

    public void broadcastPublishPropertyDelete(Element element, String key, String name) {
        this.broadcastPublish(element, key, name, PublishType.DELETE);
    }

    public void broadcastPublishProperty(Element element, String key, String name) {
        this.broadcastPublish(element, key, name, PublishType.TO_PUBLIC);
    }

    public void broadcastUndoPropertyDelete(Element element, String key, String name) {
        this.broadcastPublish(element, key, name, PublishType.UNDO_DELETE);
    }

    public void broadcastUndoProperty(Element element, String key, String name) {
        this.broadcastPublish(element, key, name, PublishType.UNDO);
    }

    public void broadcastPublishEdgeDelete(Edge edge) {
        this.broadcastPublish((Element)edge, PublishType.DELETE);
    }

    public void broadcastPublishEdge(Edge edge) {
        this.broadcastPublish((Element)edge, PublishType.TO_PUBLIC);
    }

    public void broadcastUndoEdgeDelete(Edge edge) {
        this.broadcastPublish((Element)edge, PublishType.UNDO_DELETE);
    }

    public void broadcastUndoEdge(Edge edge) {
        this.broadcastPublish((Element)edge, PublishType.UNDO);
    }

    private void broadcastPublish(Element element, PublishType publishType) {
        this.broadcastPublish(element, null, null, publishType);
    }

    private void broadcastPublish(Element element, String propertyKey, String propertyName, PublishType publishType) {
        try {
            JSONObject json;
            if (element instanceof Vertex) {
                json = this.getBroadcastPublishJson((Vertex)element, propertyKey, propertyName, publishType);
            } else if (element instanceof Edge) {
                json = this.getBroadcastPublishJson((Edge)element, propertyKey, propertyName, publishType);
            } else {
                throw new VisalloException("Unexpected element type: " + element.getClass().getName());
            }
            this.broadcastJson(json);
        }
        catch (Exception ex) {
            throw new VisalloException("Could not broadcast publish", ex);
        }
    }

    protected JSONObject getBroadcastPublishJson(Vertex graphVertex, String propertyKey, String propertyName, PublishType publishType) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"publish");
        JSONObject dataJson = new JSONObject();
        dataJson.put("graphVertexId", (Object)graphVertex.getId());
        dataJson.put("publishType", (Object)publishType.getJsonString());
        if (propertyName == null) {
            dataJson.put("objectType", (Object)"vertex");
        } else {
            dataJson.put("objectType", (Object)"property");
        }
        json.put("data", (Object)dataJson);
        return json;
    }

    protected JSONObject getBroadcastPublishJson(Edge edge, String propertyKey, String propertyName, PublishType publishType) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)"publish");
        JSONObject dataJson = new JSONObject();
        dataJson.put("graphEdgeId", (Object)edge.getId());
        dataJson.put("publishType", (Object)publishType.getJsonString());
        if (propertyName == null) {
            dataJson.put("objectType", (Object)"edge");
        } else {
            dataJson.put("objectType", (Object)"property");
        }
        json.put("data", (Object)dataJson);
        return json;
    }

    public void setGraphPropertyRunner(GraphPropertyRunner graphPropertyRunner) {
        this.graphPropertyRunner = graphPropertyRunner;
    }

    protected WorkQueueNames getWorkQueueNames() {
        return this.workQueueNames;
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    protected AuthorizationRepository getAuthorizationRepository() {
        if (this.authorizationRepository == null) {
            this.authorizationRepository = InjectHelper.getInstance(AuthorizationRepository.class);
        }
        return this.authorizationRepository;
    }

    public void setAuthorizationRepository(AuthorizationRepository authorizationRepository) {
        this.authorizationRepository = authorizationRepository;
    }

    protected WorkspaceRepository getWorkspaceRepository() {
        if (this.workspaceRepository == null) {
            this.workspaceRepository = InjectHelper.getInstance(WorkspaceRepository.class);
        }
        return this.workspaceRepository;
    }

    public void setWorkspaceRepository(WorkspaceRepository workspaceRepository) {
        this.workspaceRepository = workspaceRepository;
    }

    protected UserRepository getUserRepository() {
        if (this.userRepository == null) {
            this.userRepository = InjectHelper.getInstance(UserRepository.class);
        }
        return this.userRepository;
    }

    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    public static enum OntologyAction {
        Update,
        Delete;

    }

    public static abstract class BroadcastConsumer {
        private String consumerKey;

        public abstract void broadcastReceived(JSONObject var1);

        public String getConsumerKey() {
            return this.consumerKey;
        }

        public void setConsumerKey(String consumerKey) {
            this.consumerKey = consumerKey;
        }
    }

    private static enum PublishType {
        TO_PUBLIC("toPublic"),
        DELETE("delete"),
        UNDO_DELETE("undoDelete"),
        UNDO("undo");

        private final String jsonString;

        private PublishType(String jsonString) {
            this.jsonString = jsonString;
        }

        public String getJsonString() {
            return this.jsonString;
        }
    }
}

