/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.workspace;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.json.JSONArray;
import org.vertexium.Authorizations;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.FetchHint;
import org.vertexium.Graph;
import org.vertexium.Property;
import org.vertexium.Vertex;
import org.vertexium.Visibility;
import org.vertexium.util.IterableUtils;
import org.visallo.core.model.workQueue.Priority;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.model.workspace.WorkspaceDiffHelper;
import org.visallo.core.model.workspace.WorkspaceHelper;
import org.visallo.core.user.User;
import org.visallo.core.util.SandboxStatusUtil;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.clientapi.model.ClientApiPropertyUndoItem;
import org.visallo.web.clientapi.model.ClientApiRelationshipUndoItem;
import org.visallo.web.clientapi.model.ClientApiUndoItem;
import org.visallo.web.clientapi.model.ClientApiVertexUndoItem;
import org.visallo.web.clientapi.model.ClientApiWorkspaceUndoResponse;
import org.visallo.web.clientapi.model.SandboxStatus;

@Singleton
public class WorkspaceUndoHelper {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(WorkspaceUndoHelper.class);
    private final Graph graph;
    private final WorkQueueRepository workQueueRepository;
    private final WorkspaceHelper workspaceHelper;

    @Inject
    public WorkspaceUndoHelper(Graph graph, WorkspaceHelper workspaceHelper, WorkQueueRepository workQueueRepository) {
        this.graph = graph;
        this.workspaceHelper = workspaceHelper;
        this.workQueueRepository = workQueueRepository;
    }

    public void undo(Iterable<ClientApiUndoItem> undoItems, ClientApiWorkspaceUndoResponse workspaceUndoResponse, String workspaceId, User user, Authorizations authorizations) {
        this.undoVertices(undoItems, workspaceUndoResponse, workspaceId, user, authorizations);
        this.undoEdges(undoItems, workspaceUndoResponse, workspaceId, user, authorizations);
        this.undoProperties(undoItems, workspaceUndoResponse, workspaceId, authorizations);
    }

    private void undoVertices(Iterable<ClientApiUndoItem> undoItems, ClientApiWorkspaceUndoResponse workspaceUndoResponse, String workspaceId, User user, Authorizations authorizations) {
        LOGGER.debug("BEGIN undoVertices", new Object[0]);
        JSONArray verticesDeleted = new JSONArray();
        for (ClientApiUndoItem undoItem : undoItems) {
            try {
                if (!(undoItem instanceof ClientApiVertexUndoItem)) continue;
                ClientApiVertexUndoItem vertexUndoItem = (ClientApiVertexUndoItem)undoItem;
                String vertexId = vertexUndoItem.getVertexId();
                Preconditions.checkNotNull((Object)vertexId);
                Vertex vertex = this.graph.getVertex(vertexId, FetchHint.ALL_INCLUDING_HIDDEN, authorizations);
                Preconditions.checkNotNull((Object)vertex);
                if (WorkspaceDiffHelper.isPublicDelete(vertex, authorizations)) {
                    LOGGER.debug("un-hiding vertex: %s (workspaceId: %s)", vertex.getId(), workspaceId);
                    this.graph.markVertexVisible(vertex, new Visibility(workspaceId), authorizations);
                    for (Property property : vertex.getProperties()) {
                        this.undoProperties(property.getKey(), property.getName(), property.getVisibility().getVisibilityString(), (Element)vertex, workspaceId, authorizations);
                    }
                    this.graph.flush();
                    this.workQueueRepository.pushVertexUnhidden(vertex, Priority.HIGH);
                    continue;
                }
                if (SandboxStatusUtil.getSandboxStatus((Element)vertex, workspaceId) == SandboxStatus.PUBLIC) {
                    LOGGER.warn("Cannot undo a public vertex", new Object[0]);
                    continue;
                }
                this.workspaceHelper.deleteVertex(vertex, workspaceId, false, Priority.HIGH, authorizations, user);
                verticesDeleted.put((Object)vertexId);
                this.graph.flush();
                this.workQueueRepository.broadcastUndoVertex(vertex);
            }
            catch (Exception ex) {
                LOGGER.error("Error undoing %s", undoItem.toString(), ex);
                undoItem.setErrorMessage(ex.getMessage());
                workspaceUndoResponse.addFailure(undoItem);
            }
        }
        LOGGER.debug("END undoVertices", new Object[0]);
        if (verticesDeleted.length() > 0) {
            this.workQueueRepository.pushVerticesDeletion(verticesDeleted);
        }
        this.graph.flush();
    }

    private void undoEdges(Iterable<ClientApiUndoItem> undoItems, ClientApiWorkspaceUndoResponse workspaceUndoResponse, String workspaceId, User user, Authorizations authorizations) {
        LOGGER.debug("BEGIN undoEdges", new Object[0]);
        for (ClientApiUndoItem undoItem : undoItems) {
            try {
                ClientApiRelationshipUndoItem relationshipUndoItem;
                Edge edge;
                if (!(undoItem instanceof ClientApiRelationshipUndoItem) || (edge = this.graph.getEdge((relationshipUndoItem = (ClientApiRelationshipUndoItem)undoItem).getEdgeId(), FetchHint.ALL_INCLUDING_HIDDEN, authorizations)) == null) continue;
                Vertex outVertex = edge.getVertex(Direction.OUT, authorizations);
                Vertex inVertex = edge.getVertex(Direction.IN, authorizations);
                if (outVertex == null || inVertex == null) continue;
                Preconditions.checkNotNull((Object)edge);
                if (WorkspaceDiffHelper.isPublicDelete(edge, authorizations)) {
                    LOGGER.debug("un-hiding edge: %s (workspaceId: %s)", edge.getId(), workspaceId);
                    this.graph.markEdgeVisible(edge, new Visibility(workspaceId), authorizations);
                    this.graph.flush();
                    this.workQueueRepository.pushEdgeUnhidden(edge, Priority.HIGH);
                    continue;
                }
                if (SandboxStatusUtil.getSandboxStatus((Element)edge, workspaceId) == SandboxStatus.PUBLIC) {
                    LOGGER.warn("Cannot undo a public edge", new Object[0]);
                    continue;
                }
                this.workspaceHelper.deleteEdge(workspaceId, edge, outVertex, inVertex, false, Priority.HIGH, authorizations, user);
                this.graph.flush();
                this.workQueueRepository.broadcastUndoEdge(edge);
            }
            catch (Exception ex) {
                LOGGER.error("Error publishing %s", undoItem.toString(), ex);
                undoItem.setErrorMessage(ex.getMessage());
                workspaceUndoResponse.addFailure(undoItem);
            }
        }
        LOGGER.debug("END undoEdges", new Object[0]);
        this.graph.flush();
    }

    private void undoProperties(Iterable<ClientApiUndoItem> undoItems, ClientApiWorkspaceUndoResponse workspaceUndoResponse, String workspaceId, Authorizations authorizations) {
        LOGGER.debug("BEGIN undoProperties", new Object[0]);
        for (ClientApiUndoItem undoItem : undoItems) {
            try {
                ClientApiPropertyUndoItem propertyUndoItem;
                Object element;
                if (!(undoItem instanceof ClientApiPropertyUndoItem) || (element = (propertyUndoItem = (ClientApiPropertyUndoItem)undoItem).getEdgeId() != null ? this.graph.getEdge(propertyUndoItem.getEdgeId(), FetchHint.ALL_INCLUDING_HIDDEN, authorizations) : this.graph.getVertex(propertyUndoItem.getVertexId(), FetchHint.ALL_INCLUDING_HIDDEN, authorizations)) == null) continue;
                this.undoProperties(propertyUndoItem.getKey(), propertyUndoItem.getName(), propertyUndoItem.getVisibilityString(), (Element)element, workspaceId, authorizations);
            }
            catch (Exception ex) {
                LOGGER.error("Error publishing %s", undoItem.toString(), ex);
                undoItem.setErrorMessage(ex.getMessage());
                workspaceUndoResponse.addFailure(undoItem);
            }
        }
        LOGGER.debug("End undoProperties", new Object[0]);
        this.graph.flush();
    }

    private void undoProperties(String propertyKey, String propertyName, String propertyVisibilityString, Element element, String workspaceId, Authorizations authorizations) {
        List properties = IterableUtils.toList((Iterable)element.getProperties(propertyKey, propertyName));
        SandboxStatus[] sandboxStatuses = SandboxStatusUtil.getPropertySandboxStatuses(properties, workspaceId);
        Property publicProperty = null;
        for (Property property : properties) {
            if (!WorkspaceDiffHelper.isPublicDelete(property, authorizations) || !WorkspaceDiffHelper.isPublicPropertyEdited(properties, sandboxStatuses, property)) continue;
            publicProperty = property;
            break;
        }
        for (int propertyIndex = 0; propertyIndex < properties.size(); ++propertyIndex) {
            Property property;
            property = (Property)properties.get(propertyIndex);
            if (propertyVisibilityString != null && !property.getVisibility().getVisibilityString().equals(propertyVisibilityString)) continue;
            SandboxStatus propertySandboxStatus = sandboxStatuses[propertyIndex];
            if (WorkspaceDiffHelper.isPublicDelete(property, authorizations)) {
                if (publicProperty != null) continue;
                LOGGER.debug("un-hiding property: %s (workspaceId: %s)", property, workspaceId);
                element.markPropertyVisible(property, new Visibility(workspaceId), authorizations);
                this.graph.flush();
                this.workQueueRepository.pushUndoPublicPropertyDeletion(element, propertyKey, propertyName, Priority.HIGH);
                continue;
            }
            if (propertySandboxStatus == SandboxStatus.PUBLIC) {
                LOGGER.warn("Cannot undo a public property", new Object[0]);
                continue;
            }
            if (propertySandboxStatus == SandboxStatus.PUBLIC_CHANGED) {
                long beforeActionTimestamp = System.currentTimeMillis() - 1L;
                element.softDeleteProperty(propertyKey, propertyName, property.getVisibility(), authorizations);
                if (publicProperty != null) {
                    element.markPropertyVisible(publicProperty, new Visibility(workspaceId), authorizations);
                    this.graph.flush();
                    this.workQueueRepository.pushUndoPublicPropertyDeletion(element, propertyKey, propertyName, Priority.HIGH);
                    continue;
                }
                this.graph.flush();
                this.workQueueRepository.pushUndoSandboxProperty(element, propertyKey, propertyName, beforeActionTimestamp, Priority.HIGH);
                continue;
            }
            this.workspaceHelper.deleteProperty(element, property, false, workspaceId, Priority.HIGH, authorizations);
            this.graph.flush();
            this.workQueueRepository.broadcastUndoProperty(element, propertyKey, propertyName);
        }
    }
}

