/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.model.workspace.product;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.vertexium.Authorizations;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.FetchHint;
import org.vertexium.Graph;
import org.vertexium.RelatedEdge;
import org.vertexium.Vertex;
import org.vertexium.Visibility;
import org.visallo.core.model.graph.ElementUpdateContext;
import org.visallo.core.model.graph.GraphUpdateContext;
import org.visallo.core.model.user.AuthorizationRepository;
import org.visallo.core.model.workspace.WorkspaceProperties;
import org.visallo.core.model.workspace.product.GetExtendedDataParams;
import org.visallo.core.model.workspace.product.UpdateProductEdgeOptions;
import org.visallo.core.model.workspace.product.WorkProductEdge;
import org.visallo.core.model.workspace.product.WorkProductExtendedData;
import org.visallo.core.model.workspace.product.WorkProductService;
import org.visallo.core.model.workspace.product.WorkProductServiceHasElements;
import org.visallo.core.model.workspace.product.WorkProductVertex;
import org.visallo.core.user.User;
import org.visallo.core.util.StreamUtil;

public abstract class WorkProductServiceHasElementsBase<TVertex extends WorkProductVertex, TEdge extends WorkProductEdge>
implements WorkProductService,
WorkProductServiceHasElements {
    private final AuthorizationRepository authorizationRepository;

    protected WorkProductServiceHasElementsBase(AuthorizationRepository authorizationRepository) {
        this.authorizationRepository = authorizationRepository;
    }

    @Override
    public WorkProductExtendedData getExtendedData(Graph graph, Vertex workspaceVertex, Vertex productVertex, GetExtendedDataParams params, User user, Authorizations authorizations) {
        WorkProductExtendedData extendedData = new WorkProductExtendedData();
        String id = productVertex.getId();
        if (params.isIncludeVertices()) {
            HashMap<String, TVertex> vertices = new HashMap<String, TVertex>();
            ArrayList productVertexEdges = Lists.newArrayList((Iterable)productVertex.getEdges(Direction.OUT, "http://visallo.org/workspace/product#toEntity", authorizations));
            List ids = productVertexEdges.stream().map(edge -> edge.getOtherVertexId(id)).collect(Collectors.toList());
            Map othersById = StreamUtil.stream(graph.getVertices(ids, FetchHint.NONE, authorizations)).collect(Collectors.toMap(Element::getId, Function.identity()));
            for (Edge propertyVertexEdge : productVertexEdges) {
                String otherId = propertyVertexEdge.getOtherVertexId(id);
                TVertex vertex = this.createWorkProductVertex();
                ((WorkProductVertex)vertex).setId(otherId);
                if (!othersById.containsKey(otherId)) {
                    ((WorkProductVertex)vertex).setUnauthorized(true);
                }
                this.populateProductVertexWithWorkspaceEdge(propertyVertexEdge, (WorkProductVertex)vertex);
                vertices.put(otherId, vertex);
            }
            extendedData.setVertices(vertices);
        }
        if (params.isIncludeEdges()) {
            HashMap<String, TEdge> edges = new HashMap<String, TEdge>();
            Authorizations systemAuthorizations = this.authorizationRepository.getGraphAuthorizations(user, "visallo");
            ArrayList productVertices = Lists.newArrayList((Iterable)productVertex.getVertices(Direction.OUT, "http://visallo.org/workspace/product#toEntity", systemAuthorizations));
            Iterable productRelatedEdges = graph.findRelatedEdgeSummaryForVertices((Iterable)productVertices, authorizations);
            List ids = StreamUtil.stream(productRelatedEdges).map(RelatedEdge::getEdgeId).collect(Collectors.toList());
            Map relatedEdgesById = graph.doEdgesExist(ids, authorizations);
            for (RelatedEdge relatedEdge : productRelatedEdges) {
                String edgeId = relatedEdge.getEdgeId();
                TEdge edge2 = this.createWorkProductEdge();
                ((WorkProductEdge)edge2).setEdgeId(relatedEdge.getEdgeId());
                if (((Boolean)relatedEdgesById.get(edgeId)).booleanValue()) {
                    ((WorkProductEdge)edge2).setLabel(relatedEdge.getLabel());
                    ((WorkProductEdge)edge2).setOutVertexId(relatedEdge.getOutVertexId());
                    ((WorkProductEdge)edge2).setInVertexId(relatedEdge.getInVertexId());
                } else {
                    ((WorkProductEdge)edge2).setUnauthorized(true);
                }
                edges.put(edgeId, edge2);
            }
            extendedData.setEdges(edges);
        }
        return extendedData;
    }

    protected abstract TEdge createWorkProductEdge();

    protected abstract void populateCustomProductVertexWithWorkspaceEdge(Edge var1, TVertex var2);

    protected abstract TVertex createWorkProductVertex();

    @Override
    public void cleanUpElements(Graph graph, Vertex productVertex, Authorizations authorizations) {
        Iterable productElementEdges = productVertex.getEdges(Direction.OUT, "http://visallo.org/workspace/product#toEntity", authorizations);
        for (Edge productToElement : productElementEdges) {
            graph.softDeleteEdge(productToElement, authorizations);
        }
        graph.flush();
    }

    @Override
    public GraphUpdateContext.UpdateFuture<Edge> addOrUpdateProductEdgeToAncillaryEntity(GraphUpdateContext ctx, Vertex productVertex, String entityId, UpdateProductEdgeOptions options, Visibility visibility) {
        if (options == null) {
            options = new UpdateProductEdgeOptions();
        }
        options.setAncillary(true);
        return this.addOrUpdateProductEdgeToEntity(ctx, productVertex, entityId, options, visibility);
    }

    @Override
    public GraphUpdateContext.UpdateFuture<Edge> addOrUpdateProductEdgeToEntity(GraphUpdateContext ctx, Vertex productVertex, String entityId, UpdateProductEdgeOptions options, Visibility visibility) {
        return this.addOrUpdateProductEdgeToEntity(ctx, WorkProductServiceHasElementsBase.getEdgeId(productVertex.getId(), entityId), productVertex, entityId, options, visibility);
    }

    @Override
    public GraphUpdateContext.UpdateFuture<Edge> addOrUpdateProductEdgeToEntity(GraphUpdateContext ctx, String edgeId, Vertex productVertex, String entityId, UpdateProductEdgeOptions options, Visibility visibility) {
        return ctx.getOrCreateEdgeAndUpdate(edgeId, productVertex.getId(), entityId, "http://visallo.org/workspace/product#toEntity", visibility, elemCtx -> {
            WorkspaceProperties.PRODUCT_TO_ENTITY_IS_ANCILLARY.updateProperty(elemCtx, Boolean.valueOf(options.isAncillary()), visibility);
            this.updateProductEdge(elemCtx, options, visibility);
        });
    }

    public void populateProductVertexWithWorkspaceEdge(Edge propertyVertexEdge, WorkProductVertex vertex) {
        vertex.setId(propertyVertexEdge.getVertexId(Direction.IN));
        if (WorkspaceProperties.PRODUCT_TO_ENTITY_IS_ANCILLARY.getPropertyValue((Element)propertyVertexEdge, false)) {
            vertex.setAncillary(true);
        }
        this.populateCustomProductVertexWithWorkspaceEdge(propertyVertexEdge, vertex);
    }

    @Override
    public TVertex populateProductVertexWithWorkspaceEdge(Edge propertyVertexEdge) {
        TVertex vertex = this.createWorkProductVertex();
        this.populateProductVertexWithWorkspaceEdge(propertyVertexEdge, (WorkProductVertex)vertex);
        return vertex;
    }

    protected void updateProductEdge(ElementUpdateContext<Edge> elemCtx, UpdateProductEdgeOptions update, Visibility visibility) {
    }

    public static String getEdgeId(String productId, String vertexId) {
        return productId + "_hasVertex_" + vertexId;
    }
}

