/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.process;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.visallo.core.config.Configuration;
import org.visallo.core.externalResource.ExternalResourceRunner;
import org.visallo.core.process.VisalloProcess;
import org.visallo.core.process.VisalloProcessOptions;
import org.visallo.core.util.ShutdownListener;
import org.visallo.core.util.ShutdownService;

@Singleton
public class ExternalResourceRunnerProcess
implements VisalloProcess,
ShutdownListener {
    private final Configuration configuration;
    private ExternalResourceRunner resourceRunner;

    @Inject
    public ExternalResourceRunnerProcess(Configuration configuration, ShutdownService shutdownService) {
        this.configuration = configuration;
        shutdownService.register(this);
    }

    @Override
    public void startProcess(VisalloProcessOptions options) {
        this.resourceRunner = new ExternalResourceRunner(this.configuration, options.getUser());
        this.resourceRunner.startAll();
    }

    @Override
    public void shutdown() {
        if (this.resourceRunner != null) {
            this.resourceRunner.shutdown();
        }
    }
}

