/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.process;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.visallo.core.config.Configurable;
import org.visallo.core.config.Configuration;
import org.visallo.core.ingest.graphProperty.GraphPropertyRunner;
import org.visallo.core.process.VisalloProcess;
import org.visallo.core.process.VisalloProcessOptions;
import org.visallo.core.util.ShutdownListener;
import org.visallo.core.util.ShutdownService;
import org.visallo.core.util.StoppableRunnable;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

@Singleton
public class GraphPropertyRunnerProcess
implements VisalloProcess,
ShutdownListener {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(GraphPropertyRunnerProcess.class);
    private final Config config;
    private final List<StoppableRunnable> stoppables = new ArrayList<StoppableRunnable>();

    @Inject
    public GraphPropertyRunnerProcess(Configuration configuration, ShutdownService shutdownService) {
        this(configuration.setConfigurables(new Config(), GraphPropertyRunnerProcess.class.getName()));
        shutdownService.register(this);
    }

    public GraphPropertyRunnerProcess(Config config) {
        this.config = config;
    }

    @Override
    public void startProcess(VisalloProcessOptions options) {
        if (this.config.threadCount <= 0) {
            LOGGER.info("'threadCount' not configured or was 0", new Object[0]);
            return;
        }
        this.stoppables.addAll(GraphPropertyRunner.startThreaded(this.config.threadCount, options.getUser()));
    }

    @Override
    public void shutdown() {
        this.stoppables.forEach(StoppableRunnable::stop);
    }

    public static class Config {
        @Configurable
        public int threadCount;
    }
}

