/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.process;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.visallo.core.config.Configurable;
import org.visallo.core.config.Configuration;
import org.visallo.core.model.longRunningProcess.LongRunningProcessRunner;
import org.visallo.core.process.VisalloProcess;
import org.visallo.core.process.VisalloProcessOptions;
import org.visallo.core.util.ShutdownListener;
import org.visallo.core.util.ShutdownService;
import org.visallo.core.util.StoppableRunnable;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

@Singleton
public class LongRunningProcessRunnerProcess
implements VisalloProcess,
ShutdownListener {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(LongRunningProcessRunnerProcess.class);
    private final Configuration configuration;
    private final Config config;
    private final List<StoppableRunnable> stoppables = new ArrayList<StoppableRunnable>();

    @Inject
    public LongRunningProcessRunnerProcess(Configuration configuration, ShutdownService shutdownService) {
        this.configuration = configuration;
        this.config = configuration.setConfigurables(new Config(), LongRunningProcessRunnerProcess.class.getName());
        shutdownService.register(this);
    }

    @Override
    public void startProcess(VisalloProcessOptions options) {
        if (this.config.threadCount <= 0) {
            LOGGER.info("'threadCount' not configured or was 0", new Object[0]);
            return;
        }
        this.stoppables.addAll(LongRunningProcessRunner.startThreaded(this.config.threadCount, this.configuration));
    }

    @Override
    public void shutdown() {
        this.stoppables.forEach(StoppableRunnable::stop);
    }

    public static class Config {
        @Configurable
        public int threadCount;
    }
}

