/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.security;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.Graph;
import org.vertexium.Property;
import org.vertexium.Vertex;
import org.visallo.core.exception.VisalloAccessDeniedException;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.model.ontology.Concept;
import org.visallo.core.model.ontology.HasOntologyProperties;
import org.visallo.core.model.ontology.Ontology;
import org.visallo.core.model.ontology.OntologyElement;
import org.visallo.core.model.ontology.OntologyProperty;
import org.visallo.core.model.ontology.OntologyRepository;
import org.visallo.core.model.ontology.Relationship;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.model.user.PrivilegeRepository;
import org.visallo.core.model.user.UserRepository;
import org.visallo.core.user.User;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.clientapi.model.ClientApiEdge;
import org.visallo.web.clientapi.model.ClientApiEdgeMultipleResponse;
import org.visallo.web.clientapi.model.ClientApiEdgeSearchResponse;
import org.visallo.web.clientapi.model.ClientApiEdgeWithVertexData;
import org.visallo.web.clientapi.model.ClientApiElement;
import org.visallo.web.clientapi.model.ClientApiElementAcl;
import org.visallo.web.clientapi.model.ClientApiElementFindRelatedResponse;
import org.visallo.web.clientapi.model.ClientApiElementSearchResponse;
import org.visallo.web.clientapi.model.ClientApiObject;
import org.visallo.web.clientapi.model.ClientApiProperty;
import org.visallo.web.clientapi.model.ClientApiPropertyAcl;
import org.visallo.web.clientapi.model.ClientApiVertex;
import org.visallo.web.clientapi.model.ClientApiVertexEdges;
import org.visallo.web.clientapi.model.ClientApiVertexMultipleResponse;
import org.visallo.web.clientapi.model.ClientApiWorkspaceVertices;

public abstract class ACLProvider {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(ACLProvider.class);
    protected final Graph graph;
    protected final UserRepository userRepository;
    protected final OntologyRepository ontologyRepository;
    private final PrivilegeRepository privilegeRepository;

    @Inject
    protected ACLProvider(Graph graph, UserRepository userRepository, OntologyRepository ontologyRepository, PrivilegeRepository privilegeRepository) {
        this.graph = graph;
        this.userRepository = userRepository;
        this.ontologyRepository = ontologyRepository;
        this.privilegeRepository = privilegeRepository;
    }

    public boolean canDeleteElement(Element element, User user, String workspaceId) {
        OntologyElement ontologyElement = this.getOntologyElement(element, workspaceId);
        return this.canDeleteElement(element, ontologyElement, null, user, workspaceId);
    }

    protected abstract boolean canDeleteElement(Element var1, OntologyElement var2, Ontology var3, User var4, String var5);

    public boolean canDeleteElement(ClientApiElement clientApiElement, User user, String workspaceId) {
        OntologyElement ontologyElement = this.getOntologyElement(clientApiElement, workspaceId);
        return this.canDeleteElement(clientApiElement, ontologyElement, null, user, workspaceId);
    }

    protected abstract boolean canDeleteElement(ClientApiElement var1, OntologyElement var2, Ontology var3, User var4, String var5);

    public boolean canDeleteProperty(Element element, String propertyKey, String propertyName, User user, String workspaceId) {
        OntologyElement ontologyElement = this.getOntologyElement(element, workspaceId);
        return this.canDeleteProperty(element, ontologyElement, propertyKey, propertyName, null, user, workspaceId);
    }

    protected abstract boolean canDeleteProperty(Element var1, OntologyElement var2, String var3, String var4, Ontology var5, User var6, String var7);

    public boolean canDeleteProperty(ClientApiElement clientApiElement, String propertyKey, String propertyName, User user, String workspaceId) {
        OntologyElement ontologyElement = this.getOntologyElement(clientApiElement, workspaceId);
        return this.canDeleteProperty(clientApiElement, ontologyElement, propertyKey, propertyName, null, user, workspaceId);
    }

    protected abstract boolean canDeleteProperty(ClientApiElement var1, OntologyElement var2, String var3, String var4, Ontology var5, User var6, String var7);

    public boolean canUpdateElement(Element element, User user, String workspaceId) {
        OntologyElement ontologyElement = this.getOntologyElement(element, workspaceId);
        return this.canUpdateElement(element, ontologyElement, null, user, workspaceId);
    }

    protected abstract boolean canUpdateElement(Element var1, OntologyElement var2, Ontology var3, User var4, String var5);

    public boolean canUpdateElement(ClientApiElement clientApiElement, User user, String workspaceId) {
        OntologyElement ontologyElement = this.getOntologyElement(clientApiElement, workspaceId);
        return this.canUpdateElement(clientApiElement, ontologyElement, null, user, workspaceId);
    }

    protected abstract boolean canUpdateElement(ClientApiElement var1, OntologyElement var2, Ontology var3, User var4, String var5);

    public boolean canUpdateProperty(Element element, String propertyKey, String propertyName, User user, String workspaceId) {
        OntologyElement ontologyElement = this.getOntologyElement(element, workspaceId);
        return this.canUpdateProperty(element, ontologyElement, propertyKey, propertyName, null, user, workspaceId);
    }

    protected abstract boolean canUpdateProperty(Element var1, OntologyElement var2, String var3, String var4, Ontology var5, User var6, String var7);

    public boolean canUpdateProperty(ClientApiElement clientApiElement, String propertyKey, String propertyName, User user, String workspaceId) {
        OntologyElement ontologyElement = this.getOntologyElement(clientApiElement, workspaceId);
        return this.canUpdateProperty(clientApiElement, ontologyElement, propertyKey, propertyName, null, user, workspaceId);
    }

    protected abstract boolean canUpdateProperty(ClientApiElement var1, OntologyElement var2, String var3, String var4, Ontology var5, User var6, String var7);

    public boolean canAddProperty(Element element, String propertyKey, String propertyName, User user, String workspaceId) {
        OntologyElement ontologyElement = this.getOntologyElement(element, workspaceId);
        return this.canAddProperty(element, ontologyElement, propertyKey, propertyName, null, user, workspaceId);
    }

    protected abstract boolean canAddProperty(Element var1, OntologyElement var2, String var3, String var4, Ontology var5, User var6, String var7);

    public boolean canAddProperty(ClientApiElement clientApiElement, String propertyKey, String propertyName, User user, String workspaceId) {
        OntologyElement ontologyElement = this.getOntologyElement(clientApiElement, workspaceId);
        return this.canAddProperty(clientApiElement, ontologyElement, propertyKey, propertyName, null, user, workspaceId);
    }

    protected abstract boolean canAddProperty(ClientApiElement var1, OntologyElement var2, String var3, String var4, Ontology var5, User var6, String var7);

    public final void checkCanAddOrUpdateProperty(Element element, String propertyKey, String propertyName, User user, String workspaceId) {
        Set<String> privileges = this.privilegeRepository.getPrivileges(user);
        OntologyElement ontologyElement = this.getOntologyElement(element, workspaceId);
        this.checkCanAddOrUpdateProperty(element, ontologyElement, propertyKey, propertyName, null, privileges, user, workspaceId);
    }

    private void checkCanAddOrUpdateProperty(Element element, OntologyElement ontologyElement, String propertyKey, String propertyName, Ontology ontology, Set<String> privileges, User user, String workspaceId) throws VisalloAccessDeniedException {
        boolean canAddOrUpdate;
        boolean isUpdate = element.getProperty(propertyKey, propertyName) != null;
        boolean bl = canAddOrUpdate = isUpdate ? this.internalCanUpdateProperty(element, ontologyElement, propertyKey, propertyName, ontology, privileges, user, workspaceId) : this.internalCanAddProperty(element, ontologyElement, propertyKey, propertyName, ontology, privileges, user, workspaceId);
        if (!canAddOrUpdate) {
            throw new VisalloAccessDeniedException(propertyName + " cannot be added or updated due to ACL restriction", user, element.getId());
        }
    }

    public final void checkCanAddOrUpdateProperty(ClientApiElement clientApiElement, String propertyKey, String propertyName, User user, String workspaceId) {
        OntologyElement ontologyElement = this.getOntologyElement(clientApiElement, workspaceId);
        this.checkCanAddOrUpdateProperty(clientApiElement, ontologyElement, null, propertyKey, propertyName, user, workspaceId);
    }

    private void checkCanAddOrUpdateProperty(ClientApiElement clientApiElement, OntologyElement ontologyElement, Ontology ontology, String propertyKey, String propertyName, User user, String workspaceId) throws VisalloAccessDeniedException {
        boolean canAddOrUpdate;
        Set<String> privileges = this.privilegeRepository.getPrivileges(user);
        boolean isUpdate = clientApiElement.getProperty(propertyKey, propertyName) != null;
        boolean bl = canAddOrUpdate = isUpdate ? this.internalCanUpdateProperty(clientApiElement, ontologyElement, propertyKey, propertyName, ontology, privileges, user, workspaceId) : this.internalCanAddProperty(clientApiElement, ontologyElement, propertyKey, propertyName, ontology, privileges, user, workspaceId);
        if (!canAddOrUpdate) {
            throw new VisalloAccessDeniedException(propertyName + " cannot be added or updated due to ACL restriction", user, clientApiElement.getId());
        }
    }

    public final void checkCanDeleteProperty(Element element, String propertyKey, String propertyName, User user, String workspaceId) {
        Set<String> privileges = this.privilegeRepository.getPrivileges(user);
        OntologyElement ontologyElement = this.getOntologyElement(element, workspaceId);
        this.checkCanDeleteProperty(element, ontologyElement, propertyKey, propertyName, null, privileges, user, workspaceId);
    }

    private void checkCanDeleteProperty(Element element, OntologyElement ontologyElement, String propertyKey, String propertyName, Ontology ontology, Set<String> privileges, User user, String workspaceId) throws VisalloAccessDeniedException {
        boolean canDelete = this.internalCanDeleteProperty(element, ontologyElement, propertyKey, propertyName, ontology, privileges, user, workspaceId);
        if (!canDelete) {
            throw new VisalloAccessDeniedException(propertyName + " cannot be deleted due to ACL restriction", user, element.getId());
        }
    }

    public final void checkCanDeleteProperty(ClientApiElement clientApiElement, String propertyKey, String propertyName, User user, String workspaceId) {
        Set<String> privileges = this.privilegeRepository.getPrivileges(user);
        OntologyElement ontologyElement = this.getOntologyElement(clientApiElement, workspaceId);
        this.checkCanDeleteProperty(clientApiElement, ontologyElement, propertyKey, propertyName, null, privileges, user, workspaceId);
    }

    private void checkCanDeleteProperty(ClientApiElement clientApiElement, OntologyElement ontologyElement, String propertyKey, String propertyName, Ontology ontology, Set<String> privileges, User user, String workspaceId) throws VisalloAccessDeniedException {
        boolean canDelete = this.internalCanDeleteProperty(clientApiElement, ontologyElement, propertyKey, propertyName, ontology, privileges, user, workspaceId);
        if (!canDelete) {
            throw new VisalloAccessDeniedException(propertyName + " cannot be deleted due to ACL restriction", user, clientApiElement.getId());
        }
    }

    public final ClientApiElementAcl elementACL(ClientApiElement clientApiElement, User user, String workspaceId) {
        Set<String> privileges = this.privilegeRepository.getPrivileges(user);
        OntologyElement ontologyElement = this.getOntologyElement(clientApiElement, workspaceId);
        return this.elementACL(clientApiElement, ontologyElement, null, privileges, user, workspaceId);
    }

    private ClientApiElementAcl elementACL(ClientApiElement clientApiElement, OntologyElement ontologyElement, Ontology ontology, Set<String> privileges, User user, String workspaceId) {
        Preconditions.checkNotNull((Object)clientApiElement, (Object)"clientApiElement is required");
        ClientApiElementAcl elementAcl = new ClientApiElementAcl();
        elementAcl.setAddable(true);
        elementAcl.setUpdateable(this.internalCanUpdateElement(clientApiElement, ontologyElement, ontology, privileges, user, workspaceId));
        elementAcl.setDeleteable(this.internalCanDeleteElement(clientApiElement, ontologyElement, ontology, privileges, user, workspaceId));
        List propertyAcls = elementAcl.getPropertyAcls();
        if (clientApiElement instanceof ClientApiVertex) {
            String iri = (String)VisalloProperties.CONCEPT_TYPE.getPropertyValue(clientApiElement);
            while (iri != null) {
                Concept concept;
                Concept concept2 = concept = ontology == null ? this.ontologyRepository.getConceptByIRI(iri, workspaceId) : ontology.getConceptByIri(iri);
                if (concept == null) {
                    LOGGER.warn("Could not find concept: %s", iri);
                    break;
                }
                this.populatePropertyAcls(concept, clientApiElement, ontologyElement, ontology, privileges, user, workspaceId, propertyAcls);
                iri = concept.getParentConceptIRI();
            }
        } else if (clientApiElement instanceof ClientApiEdge) {
            String iri = ((ClientApiEdge)clientApiElement).getLabel();
            while (iri != null) {
                Relationship relationship;
                Relationship relationship2 = relationship = ontology == null ? this.ontologyRepository.getRelationshipByIRI(iri, workspaceId) : ontology.getRelationshipByIri(iri);
                if (relationship == null) {
                    LOGGER.warn("Could not find relationship: %s", iri);
                    break;
                }
                this.populatePropertyAcls(relationship, clientApiElement, ontologyElement, ontology, privileges, user, workspaceId, propertyAcls);
                iri = relationship.getParentIRI();
            }
        } else {
            throw new VisalloException("unsupported ClientApiElement class " + clientApiElement.getClass().getName());
        }
        return elementAcl;
    }

    public final ClientApiObject appendACL(ClientApiObject clientApiObject, User user, String workspaceId) {
        if (user == null) {
            return clientApiObject;
        }
        Set<String> privileges = this.privilegeRepository.getPrivileges(user);
        Ontology ontology = this.ontologyRepository.getOntology(workspaceId);
        return this.appendACL(clientApiObject, ontology, privileges, user, workspaceId);
    }

    private ClientApiObject appendACL(ClientApiObject clientApiObject, Ontology ontology, Set<String> privileges, User user, String workspaceId) {
        if (clientApiObject instanceof ClientApiElement) {
            this.appendACL((ClientApiElement)clientApiObject, ontology, privileges, user, workspaceId);
        } else if (clientApiObject instanceof ClientApiWorkspaceVertices) {
            this.appendACL(((ClientApiWorkspaceVertices)clientApiObject).getVertices(), ontology, user, workspaceId);
        } else if (clientApiObject instanceof ClientApiVertexMultipleResponse) {
            this.appendACL(((ClientApiVertexMultipleResponse)clientApiObject).getVertices(), ontology, user, workspaceId);
        } else if (clientApiObject instanceof ClientApiEdgeMultipleResponse) {
            this.appendACL(((ClientApiEdgeMultipleResponse)clientApiObject).getEdges(), ontology, user, workspaceId);
        } else if (clientApiObject instanceof ClientApiElementSearchResponse) {
            this.appendACL(((ClientApiElementSearchResponse)clientApiObject).getElements(), ontology, user, workspaceId);
        } else if (clientApiObject instanceof ClientApiEdgeSearchResponse) {
            this.appendACL(((ClientApiEdgeSearchResponse)clientApiObject).getResults(), ontology, user, workspaceId);
        } else if (clientApiObject instanceof ClientApiVertexEdges) {
            ClientApiVertexEdges vertexEdges = (ClientApiVertexEdges)clientApiObject;
            this.appendACL(vertexEdges, ontology, privileges, user, workspaceId);
        } else if (clientApiObject instanceof ClientApiElementFindRelatedResponse) {
            this.appendACL(((ClientApiElementFindRelatedResponse)clientApiObject).getElements(), ontology, user, workspaceId);
        }
        return clientApiObject;
    }

    protected final boolean isComment(String propertyName) {
        return VisalloProperties.COMMENT.isSameName(propertyName);
    }

    protected final boolean isArtifact(Element e, OntologyElement ontologyElement) {
        if (e != null && e instanceof Vertex) {
            return this.isDisplayTypeArtifact((Concept)ontologyElement);
        }
        return false;
    }

    protected final boolean isArtifact(ClientApiElement e, OntologyElement ontologyElement) {
        if (e != null && e instanceof ClientApiVertex) {
            return this.isDisplayTypeArtifact((Concept)ontologyElement);
        }
        return false;
    }

    protected final boolean isArtifactPropertyUpdateable(OntologyProperty ontologyProperty) {
        if (ontologyProperty != null) {
            String displayType = ontologyProperty.getDisplayType();
            return displayType == null || !displayType.equals("longText");
        }
        return false;
    }

    protected final boolean isAuthor(Element element, String propertyKey, String propertyName, User user, String workspaceId) {
        if (element == null) {
            return false;
        }
        Property property = element.getProperty(propertyKey, propertyName);
        if (property != null) {
            String authorUserId = (String)VisalloProperties.MODIFIED_BY_METADATA.getMetadataValue(property.getMetadata());
            return user.getUserId().equals(authorUserId);
        }
        return false;
    }

    protected final boolean isAuthor(ClientApiElement clientApiElement, String propertyKey, String propertyName, User user, String workspaceId) {
        if (clientApiElement == null) {
            return false;
        }
        ClientApiProperty property = clientApiElement.getProperty(propertyKey, propertyName);
        if (property != null) {
            String authorUserId = (String)VisalloProperties.MODIFIED_BY_METADATA.getMetadataValue(property.getMetadata());
            return user.getUserId().equals(authorUserId);
        }
        return false;
    }

    private boolean isDisplayTypeArtifact(Concept concept) {
        String displayType = concept.getDisplayType();
        if (displayType != null) {
            return displayType.equals("image") || displayType.equals("video") || displayType.equals("audio") || displayType.equals("document");
        }
        return false;
    }

    private void appendACL(Collection<? extends ClientApiObject> clientApiObject, Ontology ontology, User user, String workspaceId) {
        Set<String> privileges = this.privilegeRepository.getPrivileges(user);
        for (ClientApiObject clientApiObject2 : clientApiObject) {
            this.appendACL(clientApiObject2, ontology, privileges, user, workspaceId);
        }
    }

    private void appendACL(ClientApiElement clientApiElement, Ontology ontology, Set<String> privileges, User user, String workspaceId) {
        OntologyElement ontologyElement = this.getOntologyElement(clientApiElement, ontology, workspaceId);
        this.appendACL(clientApiElement, ontologyElement, ontology, privileges, user, workspaceId);
    }

    private void appendACL(ClientApiElement clientApiElement, OntologyElement ontologyElement, Ontology ontology, Set<String> privileges, User user, String workspaceId) {
        for (ClientApiProperty apiProperty : clientApiElement.getProperties()) {
            String key = apiProperty.getKey();
            String name = apiProperty.getName();
            apiProperty.setUpdateable(this.internalCanUpdateProperty(clientApiElement, ontologyElement, key, name, ontology, privileges, user, workspaceId));
            apiProperty.setDeleteable(this.internalCanDeleteProperty(clientApiElement, ontologyElement, key, name, ontology, privileges, user, workspaceId));
            apiProperty.setAddable(this.internalCanAddProperty(clientApiElement, ontologyElement, key, name, ontology, privileges, user, workspaceId));
        }
        clientApiElement.setUpdateable(Boolean.valueOf(this.internalCanUpdateElement(clientApiElement, ontologyElement, ontology, privileges, user, workspaceId)));
        clientApiElement.setDeleteable(Boolean.valueOf(this.internalCanDeleteElement(clientApiElement, ontologyElement, ontology, privileges, user, workspaceId)));
        clientApiElement.setAcl(this.elementACL(clientApiElement, ontologyElement, ontology, privileges, user, workspaceId));
        if (clientApiElement instanceof ClientApiEdgeWithVertexData) {
            this.appendACL((ClientApiElement)((ClientApiEdgeWithVertexData)clientApiElement).getSource(), ontology, privileges, user, workspaceId);
            this.appendACL((ClientApiElement)((ClientApiEdgeWithVertexData)clientApiElement).getTarget(), ontology, privileges, user, workspaceId);
        }
    }

    private void appendACL(ClientApiVertexEdges edges, Ontology ontology, Set<String> privileges, User user, String workspaceId) {
        for (ClientApiVertexEdges.Edge vertexEdge : edges.getRelationships()) {
            this.appendACL((ClientApiElement)vertexEdge.getRelationship(), ontology, privileges, user, workspaceId);
            this.appendACL((ClientApiElement)vertexEdge.getVertex(), ontology, privileges, user, workspaceId);
        }
    }

    private void populatePropertyAcls(HasOntologyProperties hasOntologyProperties, ClientApiElement clientApiElement, OntologyElement ontologyElement, Ontology ontology, Set<String> privileges, User user, String workspaceId, List<ClientApiPropertyAcl> propertyAcls) {
        Collection<OntologyProperty> ontologyProperties = hasOntologyProperties.getProperties();
        HashSet<String> addedPropertyNames = new HashSet<String>();
        for (OntologyProperty ontologyProperty2 : ontologyProperties) {
            String propertyName = ontologyProperty2.getTitle();
            for (ClientApiProperty property : clientApiElement.getProperties(propertyName)) {
                ClientApiPropertyAcl defaultAcl;
                ClientApiPropertyAcl acl = this.newClientApiPropertyAcl(clientApiElement, ontologyElement, property.getKey(), propertyName, ontology, privileges, user, workspaceId);
                if (!acl.equals((Object)(defaultAcl = this.newClientApiPropertyAcl(null, ontologyElement, property.getKey(), propertyName, ontology, privileges, user, workspaceId)))) {
                    propertyAcls.add(acl);
                }
                addedPropertyNames.add(propertyName);
            }
        }
        propertyAcls.addAll(ontologyProperties.stream().filter(ontologyProperty -> !addedPropertyNames.contains(ontologyProperty.getTitle())).map(ontologyProperty -> {
            ClientApiPropertyAcl defaultAcl;
            String propertyName = ontologyProperty.getTitle();
            ClientApiPropertyAcl acl = this.newClientApiPropertyAcl(clientApiElement, ontologyElement, null, propertyName, ontology, privileges, user, workspaceId);
            return acl.equals((Object)(defaultAcl = this.newClientApiPropertyAcl(null, ontologyElement, null, propertyName, ontology, privileges, user, workspaceId))) ? null : acl;
        }).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private ClientApiPropertyAcl newClientApiPropertyAcl(ClientApiElement clientApiElement, OntologyElement ontologyElement, String key, String name, Ontology ontology, Set<String> privileges, User user, String workspaceId) {
        ClientApiPropertyAcl propertyAcl = new ClientApiPropertyAcl();
        propertyAcl.setKey(key);
        propertyAcl.setName(name);
        propertyAcl.setAddable(this.internalCanAddProperty(clientApiElement, ontologyElement, key, name, ontology, privileges, user, workspaceId));
        propertyAcl.setUpdateable(this.internalCanUpdateProperty(clientApiElement, ontologyElement, key, name, ontology, privileges, user, workspaceId));
        propertyAcl.setDeleteable(this.internalCanDeleteProperty(clientApiElement, ontologyElement, key, name, ontology, privileges, user, workspaceId));
        return propertyAcl;
    }

    private boolean internalCanDeleteElement(ClientApiElement clientApiElement, OntologyElement ontologyElement, Ontology ontology, Set<String> privileges, User user, String workspaceId) {
        return PrivilegeRepository.hasPrivilege(privileges, "EDIT") && this.canDeleteElement(clientApiElement, ontologyElement, ontology, user, workspaceId);
    }

    private boolean internalCanUpdateElement(ClientApiElement clientApiElement, OntologyElement ontologyElement, Ontology ontology, Set<String> privileges, User user, String workspaceId) {
        return PrivilegeRepository.hasPrivilege(privileges, "EDIT") && this.canUpdateElement(clientApiElement, ontologyElement, ontology, user, workspaceId);
    }

    private boolean internalCanDeleteProperty(Element element, OntologyElement ontologyElement, String propertyKey, String propertyName, Ontology ontology, Set<String> privileges, User user, String workspaceId) {
        boolean canDelete;
        boolean bl = canDelete = this.hasEditOrCommentPrivilege(privileges, propertyName) && this.canDeleteProperty(element, ontologyElement, propertyKey, propertyName, ontology, user, workspaceId);
        if (canDelete && this.isComment(propertyName)) {
            canDelete = PrivilegeRepository.hasPrivilege(privileges, "COMMENT_DELETE_ANY") || PrivilegeRepository.hasPrivilege(privileges, "COMMENT") && this.isAuthor(element, propertyKey, propertyName, user, workspaceId);
        }
        return canDelete;
    }

    private boolean internalCanDeleteProperty(ClientApiElement clientApiElement, OntologyElement ontologyElement, String propertyKey, String propertyName, Ontology ontology, Set<String> privileges, User user, String workspaceId) {
        boolean canDelete;
        boolean bl = canDelete = this.hasEditOrCommentPrivilege(privileges, propertyName) && this.canDeleteProperty(clientApiElement, ontologyElement, propertyKey, propertyName, ontology, user, workspaceId);
        if (canDelete && this.isComment(propertyName)) {
            canDelete = PrivilegeRepository.hasPrivilege(privileges, "COMMENT_DELETE_ANY") || PrivilegeRepository.hasPrivilege(privileges, "COMMENT") && this.isAuthor(clientApiElement, propertyKey, propertyName, user, workspaceId);
        }
        return canDelete;
    }

    private boolean internalCanUpdateProperty(Element element, OntologyElement ontologyElement, String propertyKey, String propertyName, Ontology ontology, Set<String> privileges, User user, String workspaceId) {
        boolean canUpdate;
        boolean bl = canUpdate = this.hasEditOrCommentPrivilege(privileges, propertyName) && this.canUpdateProperty(element, ontologyElement, propertyKey, propertyName, ontology, user, workspaceId);
        if (canUpdate && this.isComment(propertyName)) {
            canUpdate = PrivilegeRepository.hasPrivilege(privileges, "COMMENT_EDIT_ANY") || PrivilegeRepository.hasPrivilege(privileges, "COMMENT") && this.isAuthor(element, propertyKey, propertyName, user, workspaceId);
        }
        return canUpdate;
    }

    private boolean internalCanUpdateProperty(ClientApiElement clientApiElement, OntologyElement ontologyElement, String propertyKey, String propertyName, Ontology ontology, Set<String> privileges, User user, String workspaceId) {
        boolean canUpdate;
        boolean bl = canUpdate = this.hasEditOrCommentPrivilege(privileges, propertyName) && this.canUpdateProperty(clientApiElement, ontologyElement, propertyKey, propertyName, ontology, user, workspaceId);
        if (canUpdate && this.isComment(propertyName)) {
            canUpdate = PrivilegeRepository.hasPrivilege(privileges, "COMMENT_EDIT_ANY") || PrivilegeRepository.hasPrivilege(privileges, "COMMENT") && this.isAuthor(clientApiElement, propertyKey, propertyName, user, workspaceId);
        }
        return canUpdate;
    }

    private boolean internalCanAddProperty(Element element, OntologyElement ontologyElement, String propertyKey, String propertyName, Ontology ontology, Set<String> privileges, User user, String workspaceId) {
        boolean canAdd;
        boolean bl = canAdd = this.hasEditOrCommentPrivilege(privileges, propertyName) && this.canAddProperty(element, ontologyElement, propertyKey, propertyName, ontology, user, workspaceId);
        if (canAdd && this.isComment(propertyName)) {
            canAdd = PrivilegeRepository.hasPrivilege(privileges, "COMMENT");
        }
        return canAdd;
    }

    private boolean internalCanAddProperty(ClientApiElement clientApiElement, OntologyElement ontologyElement, String propertyKey, String propertyName, Ontology ontology, Set<String> privileges, User user, String workspaceId) {
        boolean canAdd;
        boolean bl = canAdd = this.hasEditOrCommentPrivilege(privileges, propertyName) && this.canAddProperty(clientApiElement, ontologyElement, propertyKey, propertyName, ontology, user, workspaceId);
        if (canAdd && this.isComment(propertyName)) {
            canAdd = PrivilegeRepository.hasPrivilege(privileges, "COMMENT");
        }
        return canAdd;
    }

    private boolean hasEditOrCommentPrivilege(Set<String> privileges, String propertyName) {
        return PrivilegeRepository.hasPrivilege(privileges, "EDIT") || this.isComment(propertyName) && PrivilegeRepository.hasPrivilege(privileges, "COMMENT");
    }

    protected OntologyElement getOntologyElement(Element element, String workspaceId) {
        if (element == null) {
            return null;
        }
        if (element instanceof Edge) {
            return this.getOntologyRelationshipFromElement((Edge)element, null, workspaceId);
        }
        if (element instanceof Vertex) {
            return this.getOntologyConceptFromElement((Vertex)element, null, workspaceId);
        }
        throw new VisalloException("Unexpected " + Element.class.getName() + " found " + element.getClass().getName());
    }

    protected OntologyElement getOntologyElement(ClientApiElement clientApiElement, String workspaceId) {
        return this.getOntologyElement(clientApiElement, null, workspaceId);
    }

    protected OntologyElement getOntologyElement(ClientApiElement clientApiElement, Ontology ontology, String workspaceId) {
        if (clientApiElement == null) {
            return null;
        }
        if (clientApiElement instanceof ClientApiEdge) {
            return this.getOntologyRelationshipFromElement((ClientApiEdge)clientApiElement, ontology, workspaceId);
        }
        if (clientApiElement instanceof ClientApiVertex) {
            return this.getOntologyConceptFromElement((ClientApiVertex)clientApiElement, ontology, workspaceId);
        }
        throw new VisalloException("Unexpected " + ClientApiVertex.class.getName() + " found " + clientApiElement.getClass().getName());
    }

    private Relationship getOntologyRelationshipFromElement(Edge e, Ontology ontology, String workspaceId) {
        String label = e.getLabel();
        return this.getOntologyRelationshipFromElement(label, ontology, workspaceId);
    }

    private Relationship getOntologyRelationshipFromElement(ClientApiEdge e, Ontology ontology, String workspaceId) {
        String label = e.getLabel();
        return this.getOntologyRelationshipFromElement(label, ontology, workspaceId);
    }

    private Relationship getOntologyRelationshipFromElement(String edgeLabel, Ontology ontology, String workspaceId) {
        Preconditions.checkNotNull((Object)edgeLabel, (Object)"Edge label cannot be null");
        Relationship relationship = ontology == null ? this.ontologyRepository.getRelationshipByIRI(edgeLabel, workspaceId) : ontology.getRelationshipByIri(edgeLabel);
        Preconditions.checkNotNull((Object)relationship, (Object)(edgeLabel + " does not exist in ontology"));
        return relationship;
    }

    private Concept getOntologyConceptFromElement(Vertex vertex, Ontology ontology, String workspaceId) {
        String iri = VisalloProperties.CONCEPT_TYPE.getPropertyValue((Element)vertex, "http://www.w3.org/2002/07/owl#Thing");
        return this.getOntologyConcept(iri, ontology, workspaceId);
    }

    private Concept getOntologyConceptFromElement(ClientApiVertex vertex, Ontology ontology, String workspaceId) {
        String iri = VisalloProperties.CONCEPT_TYPE.getPropertyValue((ClientApiElement)vertex, "http://www.w3.org/2002/07/owl#Thing");
        return this.getOntologyConcept(iri, ontology, workspaceId);
    }

    private Concept getOntologyConcept(String conceptType, Ontology ontology, String workspaceId) {
        if (conceptType == null) {
            return null;
        }
        return ontology == null ? this.ontologyRepository.getConceptByIRI(conceptType, workspaceId) : ontology.getConceptByIri(conceptType);
    }
}

