/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.status;

import com.codahale.metrics.Counter;
import com.codahale.metrics.DefaultObjectNameFactory;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ObjectNameFactory;
import com.codahale.metrics.Timer;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.visallo.core.status.MetricsManager;

public class JmxMetricsManager
implements MetricsManager {
    private static final MetricRegistry REGISTRY;
    private static final JmxReporter JMX_REPORTER;
    private static final AtomicInteger ID;
    private static final String DOMAIN = "visallo";

    private static int nextId() {
        return ID.getAndIncrement();
    }

    @Override
    public Counter counter(String name) {
        return REGISTRY.counter(name);
    }

    @Override
    public Counter counter(Object source, String name) {
        return this.counter(this.createMetricName(source, "counter", name));
    }

    @Override
    public Timer timer(String name) {
        return REGISTRY.timer(name);
    }

    @Override
    public Timer timer(Object source, String name) {
        return this.timer(this.createMetricName(source, "timer", name));
    }

    @Override
    public Meter meter(String name) {
        return REGISTRY.meter(name);
    }

    @Override
    public Meter meter(Object source, String name) {
        return this.meter(this.createMetricName(source, "meter", name));
    }

    @Override
    public void removeMetric(String metricName) {
        REGISTRY.remove(metricName);
    }

    @Override
    @Deprecated
    public String getNamePrefix(Object obj) {
        return String.format("%s.%d.", obj.getClass().getName(), JmxMetricsManager.nextId());
    }

    @Override
    public String createMetricName(Object source, String metricType, String name) {
        Class rootClass = this.getRootClass(source.getClass());
        return String.format("%s:type=%s,service=%s,name=%s,metricType=%s,id=%s", DOMAIN, rootClass.getSimpleName(), source.getClass().getSimpleName(), name, metricType, Integer.toString(JmxMetricsManager.nextId()));
    }

    private Class getRootClass(Class clazz) {
        Class superClass = clazz.getSuperclass();
        if (superClass == Object.class) {
            return clazz;
        }
        return this.getRootClass(superClass);
    }

    static {
        ID = new AtomicInteger(0);
        REGISTRY = new MetricRegistry();
        JMX_REPORTER = JmxReporter.forRegistry((MetricRegistry)REGISTRY).createsObjectNamesWith((ObjectNameFactory)new DefaultObjectNameFactory(){

            public ObjectName createName(String type, String domain, String name) {
                try {
                    return new ObjectName(name);
                }
                catch (MalformedObjectNameException ex) {
                    return super.createName(type, domain, name);
                }
            }
        }).build();
        JMX_REPORTER.start();
    }
}

