/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.json.JSONObject;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public class FFprobeDateUtil {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(FFprobeDateUtil.class);

    public static Date getDateTaken(JSONObject json) {
        JSONObject tagsObject;
        if (json == null) {
            return null;
        }
        JSONObject formatObject = json.optJSONObject("format");
        if (formatObject != null && (tagsObject = formatObject.optJSONObject("tags")) != null) {
            Date date;
            String dateTaken = null;
            String optionalDateTaken = tagsObject.optString("date");
            if (!optionalDateTaken.equals("")) {
                dateTaken = optionalDateTaken;
            } else {
                String optionalDateTakenEng = tagsObject.optString("date-eng");
                if (!optionalDateTakenEng.equals("")) {
                    dateTaken = optionalDateTakenEng;
                }
            }
            if (dateTaken != null && !dateTaken.equals("") && (date = FFprobeDateUtil.parseDateTakenString(dateTaken)) != null) {
                return date;
            }
        }
        LOGGER.debug("Could not extract dateTaken from json.", new Object[0]);
        return null;
    }

    private static Date parseDateTakenString(String dateTaken) {
        String dateFormat = "yyyy-MM-dd'T'HH:mm:ssZ";
        SimpleDateFormat format = new SimpleDateFormat(dateFormat);
        try {
            Date parsedDate = format.parse(dateTaken);
            return parsedDate;
        }
        catch (ParseException e) {
            LOGGER.debug("ParseException: could not parse dateTaken: " + dateTaken + " with date format: " + dateFormat, new Object[0]);
            return null;
        }
    }
}

