/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.util;

import org.visallo.core.exception.VisalloException;
import org.visallo.core.model.lock.LeaderListener;
import org.visallo.core.model.lock.LockRepository;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public abstract class PeriodicBackgroundService {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(PeriodicBackgroundService.class);
    private final LockRepository lockRepository;
    private volatile boolean enabled;

    protected PeriodicBackgroundService(LockRepository lockRepository) {
        this.lockRepository = lockRepository;
    }

    public void start() {
        if (this.getCheckIntervalSeconds() > 0) {
            this.startBackgroundThread();
        }
    }

    private void startBackgroundThread() {
        Thread t = new Thread(() -> {
            this.enabled = false;
            this.lockRepository.leaderElection(this.getLockName(), new LeaderListener(){

                @Override
                public void isLeader() {
                    LOGGER.debug("using successfully acquired lock (%s)", Thread.currentThread().getName());
                    PeriodicBackgroundService.this.enabled = true;
                }

                @Override
                public void notLeader() {
                    LOGGER.debug("lost leadership (%s)", Thread.currentThread().getName());
                    PeriodicBackgroundService.this.disable();
                }
            });
            while (true) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {
                    LOGGER.error("Failed to sleep", e);
                    throw new VisalloException("Failed to sleep", e);
                }
                this.runPeriodically();
            }
        });
        t.setDaemon(true);
        t.setName(this.getThreadName());
        t.start();
    }

    /*
     * Exception decompiling
     */
    private void runPeriodically() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String getThreadName() {
        return "visallo-periodic-" + this.getClass().getSimpleName();
    }

    protected String getLockName() {
        return this.getClass().getName();
    }

    protected abstract void run();

    protected abstract int getCheckIntervalSeconds();

    public void disable() {
        this.enabled = false;
    }
}

