/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.core.util;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.util.VisalloDate;
import org.visallo.core.util.VisalloTime;

public class VisalloDateTime
implements Comparable<VisalloDateTime> {
    public static final String DATE_TIME_NO_TIME_ZONE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private final VisalloTime time;
    private final VisalloDate date;
    private final String timeZone;

    public VisalloDateTime(Integer year, Integer month, Integer date, Integer hour, Integer minutes, Integer seconds, Integer milliseconds, String timeZone) {
        this(new VisalloDate(year, month, date), new VisalloTime(hour, minutes, seconds, milliseconds), timeZone);
    }

    public VisalloDateTime(String year, String month, String date, String hour, String minutes, String seconds, String milliseconds, String timeZone) {
        this(new VisalloDate(year, month, date), new VisalloTime(hour, minutes, seconds, milliseconds), timeZone);
    }

    public VisalloDateTime(VisalloDate date, VisalloTime time, String timeZone) {
        this.date = date;
        this.time = time;
        this.timeZone = timeZone;
    }

    public Date toDateGMT() {
        return this.toDate(GMT);
    }

    public Date toDate(TimeZone destTimeZone) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(this.timeZone));
        cal.setTimeInMillis(0L);
        cal.set(this.getDate().getYearInt(), this.getDate().getMonthInt() - 1, this.getDate().getDateInt(), this.getTime().getHoursInt(), this.getTime().getMinutesInt(), this.getTime().getSecondsInt());
        cal.set(14, this.getTime().getMillisecondsInt());
        Calendar destCal = Calendar.getInstance(destTimeZone);
        destCal.setTimeInMillis(cal.getTimeInMillis());
        return destCal.getTime();
    }

    public long getEpoch() {
        return this.toDateGMT().getTime();
    }

    public static VisalloDateTime create(Object obj) {
        return VisalloDateTime.create(obj, TimeZone.getDefault());
    }

    public static VisalloDateTime create(Object obj, TimeZone defaultTimeZone) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return VisalloDateTime.parse((String)obj, defaultTimeZone);
        }
        if (obj instanceof Date) {
            return VisalloDateTime.create((Date)obj, defaultTimeZone);
        }
        if (obj instanceof Calendar) {
            return VisalloDateTime.create(((Calendar)obj).getTime(), ((Calendar)obj).getTimeZone());
        }
        throw new VisalloException("Invalid object type to convert to " + VisalloDateTime.class.getSimpleName() + ": " + obj.getClass().getName());
    }

    public static VisalloDateTime create(Date date, String timeZoneString) {
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneString);
        return VisalloDateTime.create(date, timeZone);
    }

    public static VisalloDateTime create(Date date, TimeZone timeZone) {
        Calendar cal = Calendar.getInstance(timeZone);
        cal.setTime(date);
        return new VisalloDateTime(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14), timeZone.getID());
    }

    public static VisalloDateTime parse(String str, TimeZone defaultTimeZone) {
        return VisalloDateTime.create(DatatypeConverter.parseDateTime((String)str), defaultTimeZone);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VisalloDateTime that = (VisalloDateTime)o;
        return this.getEpoch() == that.getEpoch();
    }

    public int hashCode() {
        int result = this.time != null ? this.time.hashCode() : 0;
        result = 31 * result + (this.date != null ? this.date.hashCode() : 0);
        result = 31 * result + (this.timeZone != null ? this.timeZone.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.getDate().toString() + "T" + this.getTime().toString() + this.timeZoneToISO8601(this.getTimeZone());
    }

    private String timeZoneToISO8601(String timeZone) {
        if (timeZone.equals("GMT")) {
            return "Z";
        }
        TimeZone tz = TimeZone.getTimeZone(timeZone);
        int rawOffset = tz.getOffset(this.getEpoch());
        int totalMinutes = rawOffset / 1000 / 60;
        boolean negative = totalMinutes < 0;
        String negPosPrefix = negative ? "-" : "+";
        totalMinutes = Math.abs(totalMinutes);
        int hours = totalMinutes / 60;
        int minutes = totalMinutes % 60;
        return String.format("%s%02d:%02d", negPosPrefix, hours, minutes);
    }

    public VisalloTime getTime() {
        return this.time;
    }

    public VisalloDate getDate() {
        return this.date;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public Date getJavaDate() {
        return new Date(this.getEpoch());
    }

    public VisalloDateTime add(int amount, VisalloDate.Unit units) {
        switch (units) {
            case DAY: {
                Calendar cal = Calendar.getInstance();
                cal.setTime(this.getJavaDate());
                cal.add(5, amount);
                return VisalloDateTime.create(cal.getTime(), this.getTimeZone());
            }
        }
        throw new VisalloException("Unhandled unit: " + (Object)((Object)units));
    }

    @Override
    public int compareTo(VisalloDateTime o) {
        return this.getJavaDate().compareTo(o.getJavaDate());
    }

    public static String getHumanTimeAgo(Date now, Date date) {
        long ago = now.getTime() - date.getTime();
        return VisalloDateTime.getHumanTimeAgo(ago);
    }

    public static String getHumanTimeAgo(long agoMillis) {
        String agoUnits = "ms ago";
        if (agoMillis >= 1000L) {
            agoUnits = "seconds ago";
            if ((agoMillis /= 1000L) >= 60L) {
                agoUnits = "minutes ago";
                if ((agoMillis /= 60L) >= 60L) {
                    agoUnits = "hours ago";
                    if ((agoMillis /= 60L) >= 24L) {
                        agoMillis /= 24L;
                        agoUnits = "days ago";
                    }
                }
            }
        }
        return String.format("%d %s", agoMillis, agoUnits);
    }

    public static String getHumanTimeAgo(Date date) {
        return VisalloDateTime.getHumanTimeAgo(new Date(), date);
    }
}

