/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes;

import com.v5analytics.webster.HandlerChain;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.vertexium.Graph;
import org.vertexium.inmemory.InMemoryGraph;
import org.visallo.core.config.Configuration;
import org.visallo.core.config.ConfigurationLoader;
import org.visallo.core.config.HashMapConfigurationLoader;
import org.visallo.core.config.VisalloResourceBundleManager;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.model.graph.GraphRepository;
import org.visallo.core.model.ontology.OntologyRepository;
import org.visallo.core.model.termMention.TermMentionRepository;
import org.visallo.core.model.user.UserRepository;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.model.workspace.WorkspaceHelper;
import org.visallo.core.model.workspace.WorkspaceRepository;
import org.visallo.core.security.DirectVisibilityTranslator;
import org.visallo.core.security.VisibilityTranslator;
import org.visallo.core.user.ProxyUser;
import org.visallo.core.user.User;
import org.visallo.vertexium.model.user.InMemoryUser;
import org.visallo.web.SessionUser;

public abstract class RouteTestBase {
    public static final String WORKSPACE_ID = "WORKSPACE_12345";
    public static final String USER_ID = "USER_123";
    @Mock
    protected UserRepository userRepository;
    @Mock
    protected HttpServletRequest request;
    @Mock
    protected HttpServletResponse response;
    @Mock
    protected HandlerChain chain;
    @Mock
    protected OntologyRepository ontologyRepository;
    @Mock
    protected WorkspaceRepository workspaceRepository;
    @Mock
    protected TermMentionRepository termMentionRepository;
    @Mock
    protected WorkspaceHelper workspaceHelper;
    @Mock
    protected GraphRepository graphRepository;
    @Mock
    protected WorkQueueRepository workQueueRepository;
    protected ResourceBundle resourceBundle;
    protected VisibilityTranslator visibilityTranslator;
    protected Configuration configuration;
    protected Graph graph;
    @Mock
    protected HttpSession httpSession;
    protected SessionUser sessionUser;
    protected ProxyUser user;
    protected User nonProxiedUser;
    private ByteArrayOutputStream responseByteArrayOutputStream;
    private HashMap<String, String[]> requestParameters;
    private HashMap<String, Object> attributes;

    protected void before() throws IOException {
        this.requestParameters = new HashMap();
        this.attributes = new HashMap();
        HashMap config = new HashMap();
        HashMapConfigurationLoader hashMapConfigurationLoader = new HashMapConfigurationLoader(config);
        this.configuration = new Configuration((ConfigurationLoader)hashMapConfigurationLoader, new HashMap());
        this.graph = this.createGraph();
        this.visibilityTranslator = this.createVisibilityTranslator();
        this.resourceBundle = this.createResourceBundle();
        HashSet privileges = new HashSet();
        String[] authorizations = new String[]{};
        String currentWorkspaceId = null;
        this.nonProxiedUser = new InMemoryUser("jdoe", "Jane Doe", "jane.doe@email.com", privileges, authorizations, currentWorkspaceId);
        Mockito.when((Object)this.userRepository.findById((String)Matchers.eq((Object)USER_ID))).thenReturn((Object)this.nonProxiedUser);
        this.sessionUser = new SessionUser(USER_ID);
        this.user = new ProxyUser(USER_ID, this.userRepository);
        Mockito.when((Object)this.request.getSession()).thenReturn((Object)this.httpSession);
        Mockito.when((Object)this.httpSession.getAttribute((String)Matchers.eq((Object)"user.current"))).thenReturn((Object)this.sessionUser);
        Mockito.when((Object)this.request.getAttribute((String)Matchers.eq((Object)"workspaceId"))).thenReturn((Object)WORKSPACE_ID);
        Mockito.when((Object)this.workspaceRepository.hasReadPermissions((String)Matchers.eq((Object)WORKSPACE_ID), (User)Matchers.eq((Object)this.user))).thenReturn((Object)true);
        this.responseByteArrayOutputStream = new ByteArrayOutputStream();
        Mockito.when((Object)this.response.getWriter()).thenReturn((Object)new PrintWriter(this.responseByteArrayOutputStream));
        Mockito.when((Object)this.request.getParameterNames()).thenAnswer(invocationOnMock -> Collections.enumeration(this.requestParameters.keySet()));
        Mockito.when((Object)this.request.getParameterValues((String)Matchers.any(String.class))).thenAnswer(invocationOnMock -> {
            Object key = invocationOnMock.getArguments()[0];
            return this.requestParameters.get(key);
        });
        Mockito.when((Object)this.request.getParameter((String)Matchers.any(String.class))).thenAnswer(invocationOnMock -> {
            Object key = invocationOnMock.getArguments()[0];
            String[] value = this.requestParameters.get(key);
            if (value == null) {
                return null;
            }
            if (value.length != 1) {
                throw new VisalloException("Unexpected number of values. Expected 1 found " + value.length);
            }
            return value[0];
        });
        Mockito.when((Object)this.request.getParameterMap()).thenReturn(this.requestParameters);
        Mockito.when((Object)this.request.getAttributeNames()).thenAnswer(invocationOnMock -> Collections.enumeration(this.attributes.keySet()));
    }

    protected ResourceBundle createResourceBundle() {
        return new VisalloResourceBundleManager().getBundle();
    }

    protected InMemoryGraph createGraph() {
        return InMemoryGraph.create(this.getGraphConfiguration());
    }

    protected DirectVisibilityTranslator createVisibilityTranslator() {
        return new DirectVisibilityTranslator();
    }

    protected Map<String, Object> getGraphConfiguration() {
        return new HashMap<String, Object>();
    }

    protected byte[] getResponse() {
        return this.responseByteArrayOutputStream.toByteArray();
    }

    protected void setArrayParameter(String parameterName, String[] values) {
        this.requestParameters.put(parameterName, values);
    }

    protected void setParameter(String parameterName, JSONArray json) {
        this.setParameter(parameterName, json.toString());
    }

    protected void setParameter(String parameterName, String value) {
        this.requestParameters.put(parameterName, new String[]{value});
    }
}

