/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.vertex;

import java.io.IOException;
import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.vertexium.Authorizations;
import org.vertexium.Vertex;
import org.visallo.core.model.search.SearchOptions;
import org.visallo.core.model.search.VertexFindRelatedSearchResults;
import org.visallo.core.model.search.VertexFindRelatedSearchRunner;
import org.visallo.core.user.User;
import org.visallo.web.clientapi.model.ClientApiElementFindRelatedResponse;
import org.visallo.web.routes.search.SearchRouteTestBase;
import org.visallo.web.routes.vertex.VertexFindRelated;

@RunWith(value=MockitoJUnitRunner.class)
public class VertexFindRelatedTest
extends SearchRouteTestBase {
    private VertexFindRelated vertexFindRelated;
    @Mock
    private VertexFindRelatedSearchResults results;
    @Mock
    private VertexFindRelatedSearchRunner vertexFindRelatedSearchRunner;

    @Before
    public void before() throws IOException {
        super.before();
        Mockito.when((Object)this.searchRepository.findSearchRunnerByUri("/vertex/find-related")).thenReturn((Object)this.vertexFindRelatedSearchRunner);
        this.vertexFindRelated = new VertexFindRelated(this.searchRepository);
    }

    @Test
    public void testSearchRelated() throws Exception {
        Vertex v1 = this.graph.prepareVertex("v1", this.visibility).save(this.authorizations);
        Vertex v2 = this.graph.prepareVertex("v2", this.visibility).save(this.authorizations);
        Vertex v3 = this.graph.prepareVertex("v3", this.visibility).save(this.authorizations);
        this.graph.addEdge("e1", v1, v2, "label1", this.visibility, this.authorizations);
        this.graph.addEdge("e2", v1, v3, "label1", this.visibility, this.authorizations);
        this.graph.flush();
        ArrayList<Vertex> elements = new ArrayList<Vertex>();
        elements.add(v2);
        elements.add(v3);
        Mockito.when((Object)this.results.getElements()).thenReturn(elements);
        Mockito.when((Object)this.results.getCount()).thenReturn((Object)2L);
        this.setParameter("q", "*");
        this.setArrayParameter("graphVertexIds[]", new String[]{"v1"});
        Mockito.when((Object)this.vertexFindRelatedSearchRunner.run((SearchOptions)Matchers.argThat((Matcher)new ArgumentMatcher<SearchOptions>(){

            public boolean matches(Object o) {
                SearchOptions searchOptions = (SearchOptions)o;
                Assert.assertEquals((Object)"*", (Object)searchOptions.getRequiredParameter("q", String.class));
                Object[] graphVertexIds = (String[])searchOptions.getRequiredParameter("graphVertexIds[]", String[].class);
                Assert.assertArrayEquals((Object[])new String[]{"v1"}, (Object[])graphVertexIds);
                Assert.assertEquals((Object)"WORKSPACE_12345", (Object)searchOptions.getWorkspaceId());
                return true;
            }
        }), (User)Matchers.eq((Object)this.user), (Authorizations)Matchers.eq((Object)this.authorizations))).thenReturn((Object)this.results);
        ClientApiElementFindRelatedResponse response = this.vertexFindRelated.handle(this.request, "WORKSPACE_12345", (User)this.user, this.authorizations);
        Assert.assertEquals((long)2L, (long)response.getElements().size());
        Assert.assertEquals((long)2L, (long)response.getCount());
    }
}

