/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.workspace;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.vertexium.Authorizations;
import org.vertexium.Vertex;
import org.vertexium.Visibility;
import org.visallo.core.model.workspace.Workspace;
import org.visallo.core.user.User;
import org.visallo.vertexium.model.workspace.VertexiumWorkspace;
import org.visallo.web.clientapi.model.ClientApiWorkspaceEdges;
import org.visallo.web.routes.RouteTestBase;
import org.visallo.web.routes.workspace.WorkspaceEdges;

@RunWith(value=MockitoJUnitRunner.class)
public class WorkspaceEdgesTest
extends RouteTestBase {
    private WorkspaceEdges workspaceEdges;
    private VertexiumWorkspace workspace;
    private Vertex workspaceVertex;
    private Authorizations authorizations;

    @Before
    public void before() throws IOException {
        super.before();
        this.workspaceEdges = new WorkspaceEdges(this.graph, this.workspaceRepository){

            protected ClientApiWorkspaceEdges getEdges(HttpServletRequest request, String workspaceId, Iterable<String> vertexIds, Authorizations authorizations) {
                return super.getEdges(request, workspaceId, vertexIds, authorizations);
            }
        };
        Visibility workspaceVisibility = new Visibility("");
        Authorizations workspaceAuthorizations = this.graph.createAuthorizations(new String[]{""});
        Visibility visibility = new Visibility("");
        this.authorizations = this.graph.createAuthorizations(new String[]{""});
        this.workspaceVertex = this.graph.addVertex("WORKSPACE_12345", workspaceVisibility, workspaceAuthorizations);
        Vertex v1 = this.graph.addVertex("v1", visibility, this.authorizations);
        Vertex v2 = this.graph.addVertex("v2", visibility, this.authorizations);
        this.graph.addEdge("e1", v1, v2, "test", visibility, this.authorizations);
        this.workspace = new VertexiumWorkspace(this.workspaceVertex);
        Mockito.when((Object)this.workspaceRepository.findById((String)Matchers.eq((Object)"WORKSPACE_12345"), (User)Matchers.eq((Object)this.user))).thenReturn((Object)this.workspace);
    }

    @Test
    public void testHandleWithNoEntitiesOnWorkspace() throws Exception {
        ArrayList workspaceEntities = new ArrayList();
        Mockito.when((Object)this.workspaceRepository.findEntities((Workspace)this.workspace, (User)this.user)).thenReturn(workspaceEntities);
        ClientApiWorkspaceEdges edges = this.workspaceEdges.handle(this.request, null, this.workspace.getWorkspaceId(), (User)this.user, this.authorizations);
        Assert.assertEquals((long)0L, (long)edges.edges.size());
    }

    @Test
    public void testHandleWithEntitiesOnWorkspace() throws Exception {
        ArrayList<String> workspaceEntityVertexIds = new ArrayList<String>();
        workspaceEntityVertexIds.add("v1");
        workspaceEntityVertexIds.add("v2");
        Mockito.when((Object)this.workspaceRepository.findEntityVertexIds((Workspace)this.workspace, (User)this.user)).thenReturn(workspaceEntityVertexIds);
        ClientApiWorkspaceEdges edges = this.workspaceEdges.handle(this.request, null, this.workspace.getWorkspaceId(), (User)this.user, this.authorizations);
        Assert.assertEquals((long)1L, (long)edges.edges.size());
    }
}

