/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.search;

import java.util.HashMap;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.visallo.core.model.search.SearchRepository;
import org.visallo.core.user.User;
import org.visallo.web.VisalloResponse;
import org.visallo.web.clientapi.model.ClientApiSearch;
import org.visallo.web.routes.search.SearchRun;

@RunWith(value=MockitoJUnitRunner.class)
public class SearchRunTest {
    private SearchRun searchRun;
    @Mock
    private SearchRepository searchRepository;
    @Mock
    private User user;
    @Mock
    private HttpServletRequest request;
    @Mock
    private VisalloResponse response;
    @Mock
    private ServletContext servletContext;
    @Mock
    private RequestDispatcher requestDispatcher;
    @Mock
    private HttpServletResponse servletResponse;

    @Before
    public void setUp() {
        this.searchRun = new SearchRun(this.searchRepository);
        Mockito.when((Object)this.request.getServletContext()).thenReturn((Object)this.servletContext);
        Mockito.when((Object)this.response.getHttpServletResponse()).thenReturn((Object)this.servletResponse);
    }

    @Test
    public void testRun() throws Exception {
        String workspaceId = "WS123";
        String id = "234";
        ClientApiSearch savedSearch = new ClientApiSearch();
        savedSearch.id = id;
        savedSearch.url = "/vertex/search";
        savedSearch.parameters = new HashMap();
        savedSearch.parameters.put("param1", "value1");
        Mockito.when((Object)this.servletContext.getRequestDispatcher(savedSearch.url)).thenReturn((Object)this.requestDispatcher);
        Mockito.when((Object)this.searchRepository.getSavedSearch((String)Matchers.eq((Object)id), (User)Matchers.eq((Object)this.user))).thenReturn((Object)savedSearch);
        this.searchRun.handle(workspaceId, id, this.user, this.request, this.response);
        ((HttpServletRequest)Mockito.verify((Object)this.request)).setAttribute("param1", (Object)"value1");
        ((RequestDispatcher)Mockito.verify((Object)this.requestDispatcher)).forward((ServletRequest)this.request, (ServletResponse)this.servletResponse);
    }

    @Test
    public void testRunNotFound() throws Exception {
        String workspaceId = "WS123";
        String id = "234";
        Mockito.when((Object)this.searchRepository.getSavedSearch((String)Matchers.eq((Object)id), (User)Matchers.eq((Object)this.user))).thenReturn(null);
        this.searchRun.handle(workspaceId, id, this.user, this.request, this.response);
        ((VisalloResponse)Mockito.verify((Object)this.response)).respondWithNotFound((String)Matchers.any(String.class));
    }
}

