/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.vertex;

import java.io.IOException;
import org.hamcrest.Matcher;
import org.json.JSONArray;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.vertexium.Authorizations;
import org.vertexium.Vertex;
import org.visallo.core.model.search.SearchOptions;
import org.visallo.core.model.search.VertexSearchRunner;
import org.visallo.core.user.User;
import org.visallo.web.clientapi.model.ClientApiElementSearchResponse;
import org.visallo.web.routes.search.QueryResultsIterableSearchResultsSearchRouteTestBase;
import org.visallo.web.routes.vertex.VertexSearch;

@RunWith(value=MockitoJUnitRunner.class)
public class VertexSearchTest
extends QueryResultsIterableSearchResultsSearchRouteTestBase {
    private VertexSearch vertexSearch;
    @Mock
    private VertexSearchRunner vertexSearchRunner;

    @Before
    public void before() throws IOException {
        super.before();
        Mockito.when((Object)this.searchRepository.findSearchRunnerByUri("/vertex/search")).thenReturn((Object)this.vertexSearchRunner);
        this.vertexSearch = new VertexSearch(this.searchRepository);
    }

    @Test
    public void testSearch() throws Exception {
        Vertex v1 = this.graph.addVertex("v1", this.visibility, this.authorizations);
        this.setParameter("q", "*");
        final JSONArray filter = new JSONArray();
        this.setParameter("filter", filter);
        this.queryResultsIterableTotalHits = 1L;
        this.queryResultsIterableElements.add(v1);
        Mockito.when((Object)this.vertexSearchRunner.run((SearchOptions)Matchers.argThat((Matcher)new ArgumentMatcher<SearchOptions>(){

            public boolean matches(Object o) {
                SearchOptions searchOptions = (SearchOptions)o;
                Assert.assertEquals((Object)"*", (Object)searchOptions.getRequiredParameter("q", String.class));
                Assert.assertEquals((Object)filter.toString(), (Object)((JSONArray)searchOptions.getRequiredParameter("filter", JSONArray.class)).toString());
                Assert.assertEquals((Object)"WORKSPACE_12345", (Object)searchOptions.getWorkspaceId());
                return true;
            }
        }), (User)Matchers.eq((Object)this.user), (Authorizations)Matchers.eq((Object)this.authorizations))).thenReturn((Object)this.results);
        ClientApiElementSearchResponse response = this.vertexSearch.handle(this.request, "WORKSPACE_12345", (User)this.user, this.authorizations);
        Assert.assertEquals((long)1L, (long)response.getElements().size());
        Assert.assertEquals((long)1L, (long)response.getItemCount());
    }
}

