/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web;

import javax.servlet.http.HttpSession;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.visallo.core.model.user.UserRepository;
import org.visallo.web.MessagingFilter;
import org.visallo.web.SessionUser;

@RunWith(value=MockitoJUnitRunner.class)
public class MessagingFilterTest {
    private MessagingFilter messagingFilter;
    @Mock
    private AtmosphereResource atmosphereResource;
    @Mock
    private UserRepository userRepository;
    @Mock
    private AtmosphereRequest request;
    @Mock
    private HttpSession session;
    @Mock
    private SessionUser sessionUser;

    @Before
    public void before() {
        this.messagingFilter = new MessagingFilter();
        this.messagingFilter.setUserRepository(this.userRepository);
    }

    @Test
    public void testShouldNotSendSetActiveWorkspaceMessage() {
        JSONObject message = new JSONObject();
        message.put("type", (Object)"setActiveWorkspace");
        Assert.assertFalse((boolean)this.messagingFilter.shouldSendMessage(message, null));
    }

    @Test
    public void testShouldSendMessageSessionNull() {
        JSONObject message = new JSONObject();
        Assert.assertFalse((boolean)this.messagingFilter.shouldSendMessage(message, null));
    }

    @Test
    public void testShouldSendMessageSessionNullAndSessionExpiration() {
        JSONObject message = new JSONObject();
        message.put("type", (Object)"sessionExpiration");
        Assert.assertTrue((boolean)this.messagingFilter.shouldSendMessage(message, null));
    }

    @Test
    public void testShouldSendMessageSessionNotNullAndSessionExpirationAndSessionIdPermissions() {
        Mockito.when((Object)this.sessionUser.getUserId()).thenReturn((Object)"user123");
        Mockito.when((Object)this.session.getAttribute("user.current")).thenReturn((Object)this.sessionUser);
        Mockito.when((Object)this.session.getId()).thenReturn((Object)"session123");
        JSONObject message = new JSONObject("{ permissions: { sessionIds: ['session123'] } }");
        message.put("type", (Object)"sessionExpiration");
        Assert.assertTrue((boolean)this.messagingFilter.shouldSendMessage(message, this.session));
    }

    @Test
    public void testShouldNotSendMessageSessionNotNullAndSessionExpirationAndSessionIdPermission() {
        Mockito.when((Object)this.sessionUser.getUserId()).thenReturn((Object)"user123");
        Mockito.when((Object)this.session.getAttribute("user.current")).thenReturn((Object)this.sessionUser);
        Mockito.when((Object)this.session.getId()).thenReturn((Object)"session123");
        JSONObject message = new JSONObject("{ permissions: { sessionIds: ['session456'] } }");
        message.put("type", (Object)"sessionExpiration");
        Assert.assertFalse((boolean)this.messagingFilter.shouldSendMessage(message, this.session));
    }

    @Test
    public void testShouldSendMessageSessionNotNull() {
        JSONObject message = new JSONObject();
        Assert.assertTrue((boolean)this.messagingFilter.shouldSendMessage(message, this.session));
    }

    @Test
    public void testShouldSendMessageBasedOnUserPermissions() {
        Mockito.when((Object)this.sessionUser.getUserId()).thenReturn((Object)"user123");
        Mockito.when((Object)this.session.getAttribute("user.current")).thenReturn((Object)this.sessionUser);
        JSONObject message = new JSONObject("{ permissions: { users: ['user123'] } }");
        Assert.assertTrue((boolean)this.messagingFilter.shouldSendMessage(message, this.session));
    }

    @Test
    public void testShouldNotSendMessageBasedOnUserPermissions() {
        Mockito.when((Object)this.sessionUser.getUserId()).thenReturn((Object)"user123");
        Mockito.when((Object)this.session.getAttribute("user.current")).thenReturn((Object)this.sessionUser);
        JSONObject message = new JSONObject("{ permissions: { users: ['user456'] } }");
        Assert.assertFalse((boolean)this.messagingFilter.shouldSendMessage(message, this.session));
    }

    @Test
    public void testShouldSendMessageBasedOnSessionIdPermissions() {
        Mockito.when((Object)this.session.getId()).thenReturn((Object)"session123");
        JSONObject message = new JSONObject("{ permissions: { sessionIds: ['session123'] } }");
        Assert.assertTrue((boolean)this.messagingFilter.shouldSendMessage(message, this.session));
    }

    @Test
    public void testShouldNotSendMessageBasedOnSessionIdPermissions() {
        Mockito.when((Object)this.session.getId()).thenReturn((Object)"session123");
        JSONObject message = new JSONObject("{ permissions: { sessionIds: ['session456'] } }");
        Assert.assertFalse((boolean)this.messagingFilter.shouldSendMessage(message, this.session));
    }

    @Test
    public void testShouldSendMessageBasedOnWorkspacesPermissions() {
        Mockito.when((Object)this.userRepository.getCurrentWorkspaceId("user123")).thenReturn((Object)"workspace123");
        Mockito.when((Object)this.sessionUser.getUserId()).thenReturn((Object)"user123");
        Mockito.when((Object)this.session.getAttribute("user.current")).thenReturn((Object)this.sessionUser);
        JSONObject message = new JSONObject("{ permissions: { workspaces: ['workspace123'] } }");
        Assert.assertTrue((boolean)this.messagingFilter.shouldSendMessage(message, this.session));
    }

    @Test
    public void testShouldNotSendMessageBasedOnWorkspacesPermissions() {
        Mockito.when((Object)this.userRepository.getCurrentWorkspaceId("user123")).thenReturn((Object)"workspace123");
        Mockito.when((Object)this.sessionUser.getUserId()).thenReturn((Object)"user123");
        Mockito.when((Object)this.session.getAttribute("user.current")).thenReturn((Object)this.sessionUser);
        JSONObject message = new JSONObject("{ permissions: { workspaces: ['workspace456'] } }");
        Assert.assertFalse((boolean)this.messagingFilter.shouldSendMessage(message, this.session));
    }
}

