/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.search;

import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.visallo.core.model.search.SearchRepository;
import org.visallo.core.user.User;
import org.visallo.web.clientapi.model.ClientApiSaveSearchResponse;
import org.visallo.web.routes.search.SearchSave;

@RunWith(value=MockitoJUnitRunner.class)
public class SearchSaveTest {
    private SearchSave searchSave;
    @Mock
    private SearchRepository searchRepository;
    @Mock
    private User user;

    @Before
    public void setUp() {
        this.searchSave = new SearchSave(this.searchRepository);
    }

    @Test
    public void testHandleFirstSave() throws Exception {
        String id = null;
        String name = null;
        String url = "/vertex/search";
        JSONObject searchParameters = new JSONObject();
        String newId = "1234";
        Mockito.when((Object)this.searchRepository.saveSearch((String)Matchers.eq(id), (String)Matchers.eq(name), (String)Matchers.eq((Object)url), (JSONObject)Matchers.eq((Object)searchParameters), (User)Matchers.eq((Object)this.user))).thenReturn((Object)newId);
        ClientApiSaveSearchResponse results = this.searchSave.handle(id, name, url, searchParameters, false, this.user);
        ClientApiSaveSearchResponse expectedResult = new ClientApiSaveSearchResponse();
        expectedResult.id = newId;
        Assert.assertEquals((Object)expectedResult, (Object)results);
    }

    @Test
    public void testHandleExistingSave() throws Exception {
        String id = "1234";
        String name = null;
        String url = "/vertex/search";
        JSONObject searchParameters = new JSONObject();
        String newId = "1234";
        Mockito.when((Object)this.searchRepository.saveSearch((String)Matchers.eq((Object)id), (String)Matchers.eq(name), (String)Matchers.eq((Object)url), (JSONObject)Matchers.eq((Object)searchParameters), (User)Matchers.eq((Object)this.user))).thenReturn((Object)newId);
        ClientApiSaveSearchResponse results = this.searchSave.handle(id, name, url, searchParameters, false, this.user);
        ClientApiSaveSearchResponse expectedResult = new ClientApiSaveSearchResponse();
        expectedResult.id = newId;
        Assert.assertEquals((Object)expectedResult, (Object)results);
    }

    @Test
    public void testHandleExistingSaveGlobal() throws Exception {
        String id = "1234";
        String name = null;
        String url = "/vertex/search";
        JSONObject searchParameters = new JSONObject();
        String newId = "1234";
        Mockito.when((Object)this.searchRepository.saveGlobalSearch((String)Matchers.eq((Object)id), (String)Matchers.eq(name), (String)Matchers.eq((Object)url), (JSONObject)Matchers.eq((Object)searchParameters), (User)Matchers.eq((Object)this.user))).thenReturn((Object)newId);
        ClientApiSaveSearchResponse results = this.searchSave.handle(id, name, url, searchParameters, true, this.user);
        ClientApiSaveSearchResponse expectedResult = new ClientApiSaveSearchResponse();
        expectedResult.id = newId;
        Assert.assertEquals((Object)expectedResult, (Object)results);
    }
}

