/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.user;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.user.User;
import org.visallo.web.clientapi.model.ClientApiUser;
import org.visallo.web.routes.RouteTestBase;
import org.visallo.web.routes.user.MeGet;

@RunWith(value=MockitoJUnitRunner.class)
public class MeGetTest
extends RouteTestBase {
    private MeGet meGet;

    @Before
    public void before() throws IOException {
        super.before();
        this.meGet = new MeGet(this.userRepository, this.workspaceRepository);
    }

    @Test
    public void testNoCurrentWorkspace() throws Exception {
        ClientApiUser clientApiUser = new ClientApiUser();
        clientApiUser.setCurrentWorkspaceId(null);
        Mockito.when((Object)this.userRepository.toClientApiPrivate((User)Matchers.eq((Object)this.user))).thenReturn((Object)clientApiUser);
        ClientApiUser response = this.meGet.handle(this.request, (User)this.user);
        Assert.assertEquals(null, (Object)response.getCurrentWorkspaceId());
    }

    @Test
    public void testValidCurrentWorkspace() throws Exception {
        ClientApiUser clientApiUser = new ClientApiUser();
        clientApiUser.setCurrentWorkspaceId("WORKSPACE_123");
        Mockito.when((Object)this.userRepository.toClientApiPrivate((User)Matchers.eq((Object)this.user))).thenReturn((Object)clientApiUser);
        Mockito.when((Object)this.workspaceRepository.hasReadPermissions((String)Matchers.eq((Object)"WORKSPACE_123"), (User)Matchers.eq((Object)this.user))).thenReturn((Object)true);
        ClientApiUser response = this.meGet.handle(this.request, (User)this.user);
        Assert.assertEquals((Object)"WORKSPACE_123", (Object)response.getCurrentWorkspaceId());
    }

    @Test
    public void testNoReadPermissionsOnCurrentWorkspace() throws Exception {
        ClientApiUser clientApiUser = new ClientApiUser();
        clientApiUser.setCurrentWorkspaceId("WORKSPACE_123");
        Mockito.when((Object)this.userRepository.toClientApiPrivate((User)Matchers.eq((Object)this.user))).thenReturn((Object)clientApiUser);
        Mockito.when((Object)this.workspaceRepository.hasReadPermissions((String)Matchers.eq((Object)"WORKSPACE_123"), (User)Matchers.eq((Object)this.user))).thenReturn((Object)false);
        ClientApiUser response = this.meGet.handle(this.request, (User)this.user);
        Assert.assertEquals(null, (Object)response.getCurrentWorkspaceId());
    }

    @Test
    public void testHasReadPermissionsThrowsException() throws Exception {
        ClientApiUser clientApiUser = new ClientApiUser();
        clientApiUser.setCurrentWorkspaceId("WORKSPACE_123");
        Mockito.when((Object)this.userRepository.toClientApiPrivate((User)Matchers.eq((Object)this.user))).thenReturn((Object)clientApiUser);
        Mockito.when((Object)this.workspaceRepository.hasReadPermissions((String)Matchers.eq((Object)"WORKSPACE_123"), (User)Matchers.eq((Object)this.user))).thenThrow(new Throwable[]{new VisalloException("boom")});
        ClientApiUser response = this.meGet.handle(this.request, (User)this.user);
        Assert.assertEquals(null, (Object)response.getCurrentWorkspaceId());
    }
}

