/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.parameterProviders;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.visallo.core.exception.VisalloAccessDeniedException;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.model.user.UserRepository;
import org.visallo.core.model.workspace.WorkspaceRepository;
import org.visallo.core.user.ProxyUser;
import org.visallo.core.user.User;
import org.visallo.web.SessionUser;
import org.visallo.web.parameterProviders.VisalloBaseParameterProvider;

@RunWith(value=MockitoJUnitRunner.class)
public class VisalloBaseParameterProviderTest {
    private static final String USER_ID = "user123";
    private static final String WORKSPACE_ID = "workspace123";
    @Mock
    private HttpServletRequest request;
    @Mock
    private UserRepository userRepository;
    @Mock
    private WorkspaceRepository workspaceRepository;
    @Mock
    private HttpSession session;

    @Before
    public void before() {
        Mockito.when((Object)this.request.getSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.request.getSession(false)).thenReturn((Object)this.session);
    }

    @Test
    public void testGetUserWhenSetInRequestAlready() {
        ProxyUser user = new ProxyUser(USER_ID, this.userRepository);
        Mockito.when((Object)this.request.getAttribute("user")).thenReturn((Object)user);
        User foundUser = VisalloBaseParameterProvider.getUser((HttpServletRequest)this.request, (UserRepository)this.userRepository);
        Assert.assertEquals((Object)user, (Object)foundUser);
    }

    @Test
    public void testGetUserWhenSetInSession() {
        SessionUser sessionUser = new SessionUser(USER_ID);
        Mockito.when((Object)this.session.getAttribute("user.current")).thenReturn((Object)sessionUser);
        User foundUser = VisalloBaseParameterProvider.getUser((HttpServletRequest)this.request, (UserRepository)this.userRepository);
        Assert.assertEquals((Object)USER_ID, (Object)foundUser.getUserId());
    }

    @Test
    public void testGetUserWhenNotSet() {
        User foundUser = VisalloBaseParameterProvider.getUser((HttpServletRequest)this.request, (UserRepository)this.userRepository);
        Assert.assertNull((String)"user should be null", (Object)foundUser);
    }

    @Test
    public void testGetActiveWorkspaceIdOrDefaultFromAttribute() {
        ProxyUser user = new ProxyUser(USER_ID, this.userRepository);
        Mockito.when((Object)this.request.getAttribute("user")).thenReturn((Object)user);
        Mockito.when((Object)this.request.getAttribute("workspaceId")).thenReturn((Object)WORKSPACE_ID);
        Mockito.when((Object)this.workspaceRepository.hasReadPermissions(WORKSPACE_ID, (User)user)).thenReturn((Object)true);
        String workspaceId = VisalloBaseParameterProvider.getActiveWorkspaceIdOrDefault((HttpServletRequest)this.request, (WorkspaceRepository)this.workspaceRepository, (UserRepository)this.userRepository);
        Assert.assertEquals((Object)WORKSPACE_ID, (Object)workspaceId);
    }

    @Test
    public void testGetActiveWorkspaceIdOrDefaultFromHeader() {
        ProxyUser user = new ProxyUser(USER_ID, this.userRepository);
        Mockito.when((Object)this.request.getAttribute("user")).thenReturn((Object)user);
        Mockito.when((Object)this.request.getHeader("Visallo-Workspace-Id")).thenReturn((Object)WORKSPACE_ID);
        Mockito.when((Object)this.workspaceRepository.hasReadPermissions(WORKSPACE_ID, (User)user)).thenReturn((Object)true);
        String workspaceId = VisalloBaseParameterProvider.getActiveWorkspaceIdOrDefault((HttpServletRequest)this.request, (WorkspaceRepository)this.workspaceRepository, (UserRepository)this.userRepository);
        Assert.assertEquals((Object)WORKSPACE_ID, (Object)workspaceId);
    }

    @Test
    public void testGetActiveWorkspaceIdOrDefaultFromParameter() {
        ProxyUser user = new ProxyUser(USER_ID, this.userRepository);
        Mockito.when((Object)this.request.getAttribute("user")).thenReturn((Object)user);
        Mockito.when((Object)this.request.getParameter("workspaceId")).thenReturn((Object)WORKSPACE_ID);
        Mockito.when((Object)this.workspaceRepository.hasReadPermissions(WORKSPACE_ID, (User)user)).thenReturn((Object)true);
        String workspaceId = VisalloBaseParameterProvider.getActiveWorkspaceIdOrDefault((HttpServletRequest)this.request, (WorkspaceRepository)this.workspaceRepository, (UserRepository)this.userRepository);
        Assert.assertEquals((Object)WORKSPACE_ID, (Object)workspaceId);
    }

    @Test
    public void testGetActiveWorkspaceIdOrDefaultWithMissingWorkspaceId() {
        String workspaceId = VisalloBaseParameterProvider.getActiveWorkspaceIdOrDefault((HttpServletRequest)this.request, (WorkspaceRepository)this.workspaceRepository, (UserRepository)this.userRepository);
        Assert.assertNull((Object)workspaceId);
    }

    @Test(expected=VisalloAccessDeniedException.class)
    public void testGetActiveWorkspaceIdOrDefaultWithNoUser() {
        Mockito.when((Object)this.request.getParameter("workspaceId")).thenReturn((Object)WORKSPACE_ID);
        VisalloBaseParameterProvider.getActiveWorkspaceIdOrDefault((HttpServletRequest)this.request, (WorkspaceRepository)this.workspaceRepository, (UserRepository)this.userRepository);
    }

    @Test(expected=VisalloAccessDeniedException.class)
    public void testGetActiveWorkspaceIdOrDefaultWithNoAccess() {
        ProxyUser user = new ProxyUser(USER_ID, this.userRepository);
        Mockito.when((Object)this.request.getAttribute("user")).thenReturn((Object)user);
        Mockito.when((Object)this.request.getParameter("workspaceId")).thenReturn((Object)WORKSPACE_ID);
        Mockito.when((Object)this.workspaceRepository.hasReadPermissions(WORKSPACE_ID, (User)user)).thenReturn((Object)false);
        VisalloBaseParameterProvider.getActiveWorkspaceIdOrDefault((HttpServletRequest)this.request, (WorkspaceRepository)this.workspaceRepository, (UserRepository)this.userRepository);
    }

    @Test
    public void testGetActiveWorkspaceId() {
        ProxyUser user = new ProxyUser(USER_ID, this.userRepository);
        Mockito.when((Object)this.request.getAttribute("user")).thenReturn((Object)user);
        Mockito.when((Object)this.request.getParameter("workspaceId")).thenReturn((Object)WORKSPACE_ID);
        Mockito.when((Object)this.workspaceRepository.hasReadPermissions(WORKSPACE_ID, (User)user)).thenReturn((Object)true);
        String workspaceId = VisalloBaseParameterProvider.getActiveWorkspaceId((HttpServletRequest)this.request, (WorkspaceRepository)this.workspaceRepository, (UserRepository)this.userRepository);
        Assert.assertEquals((Object)WORKSPACE_ID, (Object)workspaceId);
    }

    @Test(expected=VisalloException.class)
    public void testGetActiveWorkspaceIdWithMissingWorkspaceId() {
        VisalloBaseParameterProvider.getActiveWorkspaceId((HttpServletRequest)this.request, (WorkspaceRepository)this.workspaceRepository, (UserRepository)this.userRepository);
    }

    @Test(expected=VisalloAccessDeniedException.class)
    public void testGetActiveWorkspaceIdNoAccess() {
        ProxyUser user = new ProxyUser(USER_ID, this.userRepository);
        Mockito.when((Object)this.request.getAttribute("user")).thenReturn((Object)user);
        Mockito.when((Object)this.request.getParameter("workspaceId")).thenReturn((Object)WORKSPACE_ID);
        Mockito.when((Object)this.workspaceRepository.hasReadPermissions(WORKSPACE_ID, (User)user)).thenReturn((Object)false);
        VisalloBaseParameterProvider.getActiveWorkspaceId((HttpServletRequest)this.request, (WorkspaceRepository)this.workspaceRepository, (UserRepository)this.userRepository);
    }
}

