/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.edge;

import java.io.IOException;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.vertexium.Authorizations;
import org.vertexium.Edge;
import org.visallo.core.model.user.AuthorizationRepository;
import org.visallo.core.user.User;
import org.visallo.web.clientapi.model.ClientApiEdge;
import org.visallo.web.clientapi.model.ClientApiEdgeMultipleResponse;
import org.visallo.web.clientapi.model.ClientApiElement;
import org.visallo.web.clientapi.model.VisibilityJson;
import org.visallo.web.routes.RouteTestBase;
import org.visallo.web.routes.edge.EdgeMultiple;

@RunWith(value=MockitoJUnitRunner.class)
public class EdgeMultipleTest
extends RouteTestBase {
    private EdgeMultiple route;
    private Authorizations userAuthorizations;
    private Authorizations workspaceAuthorizations;
    @Mock
    private AuthorizationRepository authorizationRepository;
    private Edge publicEdge;
    private Edge sandboxedEdge;

    @Before
    public void before() throws IOException {
        super.before();
        this.userAuthorizations = this.graph.createAuthorizations(new String[]{"junit"});
        this.workspaceAuthorizations = this.graph.createAuthorizations(this.userAuthorizations, new String[]{"WORKSPACE_12345"});
        this.publicEdge = this.graph.addEdge("e1", "v1", "v2", this.visibilityTranslator.getDefaultVisibility(), this.userAuthorizations);
        VisibilityJson visibilityJson = new VisibilityJson();
        visibilityJson.addWorkspace("WORKSPACE_12345");
        this.sandboxedEdge = this.graph.addEdge("e2", "v1", "v2", this.visibilityTranslator.toVisibility(visibilityJson).getVisibility(), this.workspaceAuthorizations);
        this.route = new EdgeMultiple(this.graph, this.authorizationRepository);
    }

    @Test
    public void testGetEdgesWithNoneFound() throws Exception {
        Mockito.when((Object)this.authorizationRepository.getGraphAuthorizations((User)this.user, new String[0])).thenReturn((Object)this.userAuthorizations);
        ClientApiEdgeMultipleResponse response = this.route.handle(new String[]{"no-edge-id"}, null, this.request, (User)this.user);
        Assert.assertEquals((long)0L, (long)response.getEdges().size());
    }

    @Test
    public void testGetEdgesWithNoneSpecfied() throws Exception {
        Mockito.when((Object)this.authorizationRepository.getGraphAuthorizations((User)this.user, new String[0])).thenReturn((Object)this.userAuthorizations);
        ClientApiEdgeMultipleResponse response = this.route.handle(new String[0], null, this.request, (User)this.user);
        Assert.assertEquals((long)0L, (long)response.getEdges().size());
    }

    @Test
    public void testGetEdgesWithNoWorkspaceId() throws Exception {
        Mockito.when((Object)this.authorizationRepository.getGraphAuthorizations((User)this.user, new String[0])).thenReturn((Object)this.userAuthorizations);
        ClientApiEdgeMultipleResponse response = this.route.handle(new String[]{this.publicEdge.getId()}, null, this.request, (User)this.user);
        Assert.assertEquals((long)1L, (long)response.getEdges().size());
        Assert.assertEquals((Object)this.publicEdge.getId(), (Object)((ClientApiEdge)response.getEdges().get(0)).getId());
    }

    @Test
    public void testGetEdges() throws Exception {
        Mockito.when((Object)this.authorizationRepository.getGraphAuthorizations((User)this.user, new String[]{"WORKSPACE_12345"})).thenReturn((Object)this.workspaceAuthorizations);
        ClientApiEdgeMultipleResponse response = this.route.handle(new String[]{this.publicEdge.getId(), this.sandboxedEdge.getId()}, "WORKSPACE_12345", this.request, (User)this.user);
        Assert.assertEquals((long)2L, (long)response.getEdges().size());
        Assert.assertTrue((boolean)response.getEdges().stream().map(ClientApiElement::getId).collect(Collectors.toList()).contains(this.publicEdge.getId()));
        Assert.assertTrue((boolean)response.getEdges().stream().map(ClientApiElement::getId).collect(Collectors.toList()).contains(this.sandboxedEdge.getId()));
    }
}

