/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.ontology;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.model.ontology.Concept;
import org.visallo.core.model.ontology.OntologyPropertyDefinition;
import org.visallo.core.user.User;
import org.visallo.web.clientapi.model.ClientApiOntology;
import org.visallo.web.clientapi.model.PropertyType;
import org.visallo.web.routes.ontology.OntologyGet;
import org.visallo.web.routes.ontology.OntologyRouteTestBase;

@RunWith(value=MockitoJUnitRunner.class)
public class OntologyGetTest
extends OntologyRouteTestBase {
    private OntologyGet route;

    @Override
    @Before
    public void before() throws IOException {
        super.before();
        this.route = new OntologyGet(this.ontologyRepository);
    }

    @Test
    public void testGetPublicOntologyElements() throws Exception {
        this.doRouteTest("public-concept-a", 1, "public-relationship", 1, "public-property", 1);
    }

    @Test
    public void testGetSandboxedOntologyElements() throws Exception {
        Mockito.when((Object)this.privilegeRepository.hasPrivilege((User)this.user, "ONTOLOGY_ADD")).thenReturn((Object)true);
        String sandboxConceptIri = "sandboxed-concept";
        String sandboxRelationshipIri = "sandboxed-relationship";
        String sandboxedPropertyIri = "sandboxed-property";
        Concept thingConcept = this.ontologyRepository.getEntityConcept("public-ontology");
        List<Concept> things = Collections.singletonList(thingConcept);
        this.ontologyRepository.getOrCreateConcept(thingConcept, sandboxConceptIri, "Sandboxed Concept", null, (User)this.user, "WORKSPACE_12345");
        this.ontologyRepository.getOrCreateRelationshipType(null, things, things, sandboxRelationshipIri, true, (User)this.user, "WORKSPACE_12345");
        OntologyPropertyDefinition ontologyPropertyDefinition = new OntologyPropertyDefinition(things, sandboxedPropertyIri, "Sandboxed Property", PropertyType.DATE);
        this.ontologyRepository.getOrCreateProperty(ontologyPropertyDefinition, (User)this.user, "WORKSPACE_12345");
        this.ontologyRepository.clearCache();
        this.doRouteTest(sandboxConceptIri, 1, sandboxRelationshipIri, 1, sandboxedPropertyIri, 1);
    }

    @Test
    public void testGetPublicOntologyElementsWithJustConcepts() throws Exception {
        this.doRouteTest("public-concept-a", 1, null, 0, null, 0);
    }

    @Test
    public void testGetPublicOntologyElementsWithJustRelationships() throws Exception {
        this.doRouteTest(null, 0, "public-relationship", 1, null, 0);
    }

    @Test
    public void testGetPublicOntologyElementsWithJustProperties() throws Exception {
        this.doRouteTest(null, 0, null, 0, "public-property", 1);
    }

    @Test
    public void testGetPublicOntologyElementsWithUnknownConcept() throws Exception {
        try {
            this.route.handle(null, new String[]{"unknown-id"}, null, "WORKSPACE_12345");
            Assert.fail((String)"Expected route to fail due to unknown concept id");
        }
        catch (VisalloException ve) {
            Assert.assertEquals((Object)"Unable to load concept with IRI: unknown-id", (Object)ve.getMessage());
        }
    }

    @Test
    public void testGetPublicOntologyElementsWithUnknownRelationship() throws Exception {
        try {
            this.route.handle(null, null, new String[]{"unknown-id"}, "WORKSPACE_12345");
            Assert.fail((String)"Expected route to fail due to unknown relationship id");
        }
        catch (VisalloException ve) {
            Assert.assertEquals((Object)"Unable to load relationship with IRI: unknown-id", (Object)ve.getMessage());
        }
    }

    @Test
    public void testGetPublicOntologyElementsWithUnknownProperty() throws Exception {
        try {
            this.route.handle(new String[]{"unknown-id"}, null, null, "WORKSPACE_12345");
            Assert.fail((String)"Expected route to fail due to unknown property id");
        }
        catch (VisalloException ve) {
            Assert.assertEquals((Object)"Unable to load property with IRI: unknown-id", (Object)ve.getMessage());
        }
    }

    private void doRouteTest(String conceptIri, int expectedConcepts, String relationshipIri, int expectedRelationships, String propertyIri, int expectedProperties) throws Exception {
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3;
        if (propertyIri == null) {
            stringArray3 = null;
        } else {
            String[] stringArray4 = new String[1];
            stringArray3 = stringArray4;
            stringArray4[0] = this.ontologyRepository.getPropertyByIRI(propertyIri, "WORKSPACE_12345").getId();
        }
        if (conceptIri == null) {
            stringArray2 = null;
        } else {
            String[] stringArray5 = new String[1];
            stringArray2 = stringArray5;
            stringArray5[0] = this.ontologyRepository.getConceptByIRI(conceptIri, "WORKSPACE_12345").getId();
        }
        if (relationshipIri == null) {
            stringArray = null;
        } else {
            String[] stringArray6 = new String[1];
            stringArray = stringArray6;
            stringArray6[0] = this.ontologyRepository.getRelationshipByIRI(relationshipIri, "WORKSPACE_12345").getId();
        }
        ClientApiOntology response = this.route.handle(stringArray3, stringArray2, stringArray, "WORKSPACE_12345");
        Assert.assertEquals((long)expectedConcepts, (long)response.getConcepts().size());
        if (expectedConcepts != 0) {
            Assert.assertEquals((Object)conceptIri, (Object)((ClientApiOntology.Concept)response.getConcepts().get(0)).getId());
        }
        Assert.assertEquals((long)expectedRelationships, (long)response.getRelationships().size());
        if (expectedRelationships != 0) {
            Assert.assertEquals((Object)relationshipIri, (Object)((ClientApiOntology.Relationship)response.getRelationships().get(0)).getTitle());
        }
        Assert.assertEquals((long)expectedProperties, (long)response.getProperties().size());
        if (expectedProperties != 0) {
            Assert.assertEquals((Object)propertyIri, (Object)((ClientApiOntology.Property)response.getProperties().get(0)).getTitle());
        }
    }
}

