/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.ontology;

import java.io.IOException;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.visallo.core.exception.VisalloAccessDeniedException;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.model.ontology.Concept;
import org.visallo.core.model.ontology.Relationship;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.model.workspace.WorkspaceUser;
import org.visallo.core.user.User;
import org.visallo.web.clientapi.model.ClientApiOntology;
import org.visallo.web.clientapi.model.SandboxStatus;
import org.visallo.web.clientapi.model.WorkspaceAccess;
import org.visallo.web.routes.ontology.OntologyRelationshipSave;
import org.visallo.web.routes.ontology.OntologyRouteTestBase;

@RunWith(value=MockitoJUnitRunner.class)
public class OntologyRelationshipSaveTest
extends OntologyRouteTestBase {
    private static final String SANDBOX_RELATIONSHIP_IRI = "sandbox-relationship";
    private OntologyRelationshipSave route;

    @Override
    @Before
    public void before() throws IOException {
        super.before();
        this.route = new OntologyRelationshipSave(this.ontologyRepository, this.workQueueRepository);
    }

    @Test
    public void testSaveNewRelationship() throws Exception {
        Mockito.when((Object)this.privilegeRepository.hasPrivilege((User)this.user, "ONTOLOGY_ADD")).thenReturn((Object)true);
        String relationshipIRI = "junit-relationship";
        ClientApiOntology.Relationship response = this.route.handle("New Relationship", new String[]{"public-concept-a"}, new String[]{this.ontologyRepository.getEntityConcept("public-ontology").getIRI()}, "public-relationship", relationshipIRI, "WORKSPACE_12345", this.workspaceAuthorizations, (User)this.user);
        Assert.assertEquals((Object)relationshipIRI, (Object)response.getTitle());
        Assert.assertEquals((Object)"public-relationship", (Object)response.getParentIri());
        Assert.assertEquals((Object)"New Relationship", (Object)response.getDisplayName());
        Assert.assertEquals((Object)SandboxStatus.PRIVATE, (Object)response.getSandboxStatus());
        Assert.assertEquals((long)1L, (long)response.getDomainConceptIris().size());
        Assert.assertEquals((Object)"public-concept-a", response.getDomainConceptIris().get(0));
        Assert.assertEquals((long)1L, (long)response.getRangeConceptIris().size());
        Assert.assertEquals((Object)this.ontologyRepository.getEntityConcept("public-ontology").getIRI(), response.getRangeConceptIris().get(0));
        Relationship relationship = this.ontologyRepository.getRelationshipByIRI(relationshipIRI, "WORKSPACE_12345");
        Assert.assertNotNull((Object)relationship);
        Assert.assertEquals((Object)"New Relationship", (Object)relationship.getDisplayName());
        Assert.assertEquals((Object)SandboxStatus.PRIVATE, (Object)relationship.getSandboxStatus());
        Assert.assertEquals((Object)"public-relationship", (Object)this.ontologyRepository.getParentRelationship(relationship, "WORKSPACE_12345").getIRI());
        Assert.assertNull((Object)this.ontologyRepository.getRelationshipByIRI(relationshipIRI, "public-ontology"));
        ((WorkQueueRepository)Mockito.verify((Object)this.workQueueRepository, (VerificationMode)Mockito.times((int)1))).pushOntologyRelationshipsChange("WORKSPACE_12345", new String[]{relationship.getId()});
    }

    @Test(expected=VisalloAccessDeniedException.class)
    public void testSaveNewRelationshipNoPrivilege() throws Exception {
        this.route.handle("New Relationship", new String[]{"public-concept-a"}, new String[]{this.ontologyRepository.getEntityConcept("public-ontology").getIRI()}, "public-relationship", "junit-relationship", "WORKSPACE_12345", this.workspaceAuthorizations, (User)this.user);
    }

    @Test
    public void testSaveNewRelationshipWithUnknownDomainConcept() throws Exception {
        try {
            this.route.handle("New Relationship", new String[]{"unknown-concept"}, new String[]{"public-concept-a"}, null, "junit-relationship", "WORKSPACE_12345", this.workspaceAuthorizations, (User)this.user);
            Assert.fail((String)"Expected to raise a VisalloException for unknown concept iri.");
        }
        catch (VisalloException ve) {
            Assert.assertEquals((Object)"Unable to load concept with IRI: unknown-concept", (Object)ve.getMessage());
        }
    }

    @Test
    public void testSaveNewRelationshipWithUnknownRangeConcept() throws Exception {
        try {
            this.route.handle("New Relationship", new String[]{"public-concept-a"}, new String[]{"unknown-concept"}, null, "junit-relationship", "WORKSPACE_12345", this.workspaceAuthorizations, (User)this.user);
            Assert.fail((String)"Expected to raise a VisalloException for unknown concept iri.");
        }
        catch (VisalloException ve) {
            Assert.assertEquals((Object)"Unable to load concept with IRI: unknown-concept", (Object)ve.getMessage());
        }
    }

    @Test
    public void testSaveNewRelationshipWithUnknownParentIri() throws Exception {
        try {
            this.route.handle("New Relationship", new String[]{"public-concept-a"}, new String[]{this.ontologyRepository.getEntityConcept("public-ontology").getIRI()}, "unknown-parent-relationship", "junit-relationship", "WORKSPACE_12345", this.workspaceAuthorizations, (User)this.user);
            Assert.fail((String)"Expected to raise a VisalloException for unknown relationship iri.");
        }
        catch (VisalloException ve) {
            Assert.assertEquals((Object)"Unable to load parent relationship with IRI: unknown-parent-relationship", (Object)ve.getMessage());
        }
    }

    @Test
    public void testSaveNewRelationshipWithGeneratedIriAndNoParent() throws Exception {
        Mockito.when((Object)this.privilegeRepository.hasPrivilege((User)this.user, "ONTOLOGY_ADD")).thenReturn((Object)true);
        String displayName = "New Relationship";
        String[] sourceConcepts = new String[]{"public-concept-a"};
        String[] targetConcepts = new String[]{"public-concept-b"};
        ClientApiOntology.Relationship response = this.route.handle(displayName, sourceConcepts, targetConcepts, null, null, "WORKSPACE_12345", this.workspaceAuthorizations, (User)this.user);
        String originalIri = response.getTitle();
        Assert.assertTrue((boolean)originalIri.matches("http://visallo.org/new_relationship#[a-z0-9]+"));
    }

    @Test
    public void testAddAdditionalConceptsToNewRelationship() throws Exception {
        Mockito.when((Object)this.privilegeRepository.hasPrivilege((User)this.user, "ONTOLOGY_ADD")).thenReturn((Object)true);
        Concept thing = this.ontologyRepository.getEntityConcept("public-ontology");
        String displayName = "New Relationship";
        String[] sourceConcepts = new String[]{thing.getIRI()};
        String[] targetConcepts = new String[]{"public-concept-a"};
        ClientApiOntology.Relationship response = this.route.handle(displayName, sourceConcepts, targetConcepts, null, SANDBOX_RELATIONSHIP_IRI, "WORKSPACE_12345", this.workspaceAuthorizations, (User)this.user);
        Assert.assertEquals((long)1L, (long)response.getDomainConceptIris().size());
        Assert.assertEquals((Object)thing.getIRI(), response.getDomainConceptIris().get(0));
        Assert.assertEquals((long)1L, (long)response.getRangeConceptIris().size());
        Assert.assertEquals((Object)"public-concept-a", response.getRangeConceptIris().get(0));
        Relationship relationship = this.ontologyRepository.getRelationshipByIRI(SANDBOX_RELATIONSHIP_IRI, "WORKSPACE_12345");
        Assert.assertEquals((long)1L, (long)relationship.getDomainConceptIRIs().size());
        Assert.assertEquals((Object)thing.getIRI(), relationship.getDomainConceptIRIs().get(0));
        Assert.assertEquals((long)1L, (long)relationship.getRangeConceptIRIs().size());
        Assert.assertEquals((Object)"public-concept-a", relationship.getRangeConceptIRIs().get(0));
        String sanboxConceptIri = "sandbox-concept-iri";
        this.ontologyRepository.getOrCreateConcept(thing, sanboxConceptIri, "Sandbox Concept", null, (User)this.user, "WORKSPACE_12345");
        this.ontologyRepository.clearCache();
        sourceConcepts = new String[]{"public-concept-b"};
        targetConcepts = new String[]{sanboxConceptIri};
        response = this.route.handle(displayName, sourceConcepts, targetConcepts, null, SANDBOX_RELATIONSHIP_IRI, "WORKSPACE_12345", this.workspaceAuthorizations, (User)this.user);
        Assert.assertEquals((long)2L, (long)response.getDomainConceptIris().size());
        Assert.assertTrue((boolean)response.getDomainConceptIris().contains(thing.getIRI()));
        Assert.assertTrue((boolean)response.getDomainConceptIris().contains("public-concept-b"));
        Assert.assertEquals((long)2L, (long)response.getRangeConceptIris().size());
        Assert.assertTrue((boolean)response.getRangeConceptIris().contains("public-concept-a"));
        Assert.assertTrue((boolean)response.getRangeConceptIris().contains(sanboxConceptIri));
        relationship = this.ontologyRepository.getRelationshipByIRI(SANDBOX_RELATIONSHIP_IRI, "WORKSPACE_12345");
        Assert.assertEquals((long)2L, (long)relationship.getDomainConceptIRIs().size());
        Assert.assertTrue((boolean)relationship.getDomainConceptIRIs().contains(thing.getIRI()));
        Assert.assertTrue((boolean)relationship.getDomainConceptIRIs().contains("public-concept-b"));
        Assert.assertEquals((long)2L, (long)relationship.getRangeConceptIRIs().size());
        Assert.assertTrue((boolean)relationship.getRangeConceptIRIs().contains("public-concept-a"));
        Assert.assertTrue((boolean)relationship.getRangeConceptIRIs().contains(sanboxConceptIri));
    }

    @Test
    public void testSaveNewRelationshipWithGeneratedIri() throws Exception {
        Mockito.when((Object)this.privilegeRepository.hasPrivilege((User)this.user, "ONTOLOGY_ADD")).thenReturn((Object)true);
        String displayName = "New Relationship";
        String[] sourceConcepts = new String[]{"public-concept-a"};
        String[] targetConcepts = new String[]{"public-concept-b"};
        ClientApiOntology.Relationship response = this.route.handle(displayName, sourceConcepts, targetConcepts, "public-relationship", null, "WORKSPACE_12345", this.workspaceAuthorizations, (User)this.user);
        String originalIri = response.getTitle();
        Assert.assertTrue((boolean)originalIri.matches("http://visallo.org/new_relationship#[a-z0-9]+"));
        response = this.route.handle(displayName + "1", sourceConcepts, targetConcepts, "public-relationship", null, "WORKSPACE_12345", this.workspaceAuthorizations, (User)this.user);
        Assert.assertNotEquals((Object)originalIri, (Object)response.getTitle());
        Assert.assertTrue((boolean)response.getTitle().matches("http://visallo.org/new_relationship1#[a-z0-9]+"));
        response = this.route.handle(displayName, targetConcepts, targetConcepts, "public-relationship", null, "WORKSPACE_12345", this.workspaceAuthorizations, (User)this.user);
        Assert.assertEquals((Object)originalIri, (Object)response.getTitle());
        response = this.route.handle(displayName, sourceConcepts, sourceConcepts, "public-relationship", null, "WORKSPACE_12345", this.workspaceAuthorizations, (User)this.user);
        Assert.assertEquals((Object)originalIri, (Object)response.getTitle());
        response = this.route.handle(displayName, sourceConcepts, targetConcepts, "public-relationship-b", null, "WORKSPACE_12345", this.workspaceAuthorizations, (User)this.user);
        Assert.assertNotEquals((Object)originalIri, (Object)response.getTitle());
        Assert.assertTrue((boolean)response.getTitle().matches("http://visallo.org/new_relationship#[a-z0-9]+"));
        WorkspaceUser workspaceUser = new WorkspaceUser(this.user.getUserId(), WorkspaceAccess.WRITE, true);
        Mockito.when((Object)this.workspaceRepository.findUsersWithAccess("other-workspace", (User)this.user)).thenReturn(Collections.singletonList(workspaceUser));
        response = this.route.handle(displayName, sourceConcepts, targetConcepts, "public-relationship", null, "other-workspace", this.workspaceAuthorizations, (User)this.user);
        Assert.assertNotEquals((Object)originalIri, (Object)response.getTitle());
        Assert.assertTrue((boolean)response.getTitle().matches("http://visallo.org/new_relationship#[a-z0-9]+"));
    }
}

