/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.user;

import java.io.IOException;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.model.workspace.Workspace;
import org.visallo.core.user.ProxyUser;
import org.visallo.core.user.User;
import org.visallo.web.clientapi.model.ClientApiUser;
import org.visallo.web.routes.RouteTestBase;
import org.visallo.web.routes.user.MeGet;

@RunWith(value=MockitoJUnitRunner.class)
public class MeGetTest
extends RouteTestBase {
    private MeGet meGet;
    private Workspace workspaceShared1;
    private Workspace workspaceShared2;
    private Workspace workspaceCreator1;
    private Workspace workspaceCreator2;

    @Before
    public void before() throws IOException {
        super.before();
        this.meGet = new MeGet(this.userRepository, this.workspaceRepository);
        ProxyUser otherUser = new ProxyUser("other-user", this.userRepository);
        this.workspaceShared1 = new TestWorkspace("junit-id-1", "B-junit-display-title");
        this.workspaceShared2 = new TestWorkspace("junit-id-2", "a-junit-display-title");
        this.workspaceCreator1 = new TestWorkspace("junit-id-3", "b-junit-display-title");
        this.workspaceCreator2 = new TestWorkspace("junit-id-4", "A-junit-display-title");
        Mockito.when((Object)this.workspaceRepository.getCreatorUserId(this.workspaceShared1.getWorkspaceId(), (User)this.user)).thenReturn((Object)otherUser.getUserId());
        Mockito.when((Object)this.workspaceRepository.getCreatorUserId(this.workspaceShared2.getWorkspaceId(), (User)this.user)).thenReturn((Object)otherUser.getUserId());
        Mockito.when((Object)this.workspaceRepository.getCreatorUserId(this.workspaceCreator1.getWorkspaceId(), (User)this.user)).thenReturn((Object)this.user.getUserId());
        Mockito.when((Object)this.workspaceRepository.getCreatorUserId(this.workspaceCreator2.getWorkspaceId(), (User)this.user)).thenReturn((Object)this.user.getUserId());
    }

    @Test
    public void testNoCurrentWorkspace() throws Exception {
        ClientApiUser clientApiUser = new ClientApiUser();
        clientApiUser.setCurrentWorkspaceId(null);
        Mockito.when((Object)this.userRepository.toClientApiPrivate((User)Matchers.eq((Object)this.user))).thenReturn((Object)clientApiUser);
        TestWorkspace workspace = new TestWorkspace("junit-id", "junit-display-title");
        Mockito.when((Object)this.workspaceRepository.add((User)this.user)).thenReturn((Object)workspace);
        ClientApiUser response = this.meGet.handle(this.request, (User)this.user);
        Assert.assertEquals((Object)workspace.getWorkspaceId(), (Object)response.getCurrentWorkspaceId());
        Assert.assertEquals((Object)workspace.getDisplayTitle(), (Object)response.getCurrentWorkspaceName());
    }

    @Test
    public void testValidCurrentWorkspace() throws Exception {
        ClientApiUser clientApiUser = new ClientApiUser();
        clientApiUser.setCurrentWorkspaceId("WORKSPACE_123");
        Mockito.when((Object)this.userRepository.toClientApiPrivate((User)Matchers.eq((Object)this.user))).thenReturn((Object)clientApiUser);
        Mockito.when((Object)this.workspaceRepository.hasReadPermissions((String)Matchers.eq((Object)"WORKSPACE_123"), (User)Matchers.eq((Object)this.user))).thenReturn((Object)true);
        ClientApiUser response = this.meGet.handle(this.request, (User)this.user);
        Assert.assertEquals((Object)"WORKSPACE_123", (Object)response.getCurrentWorkspaceId());
    }

    @Test
    public void testNoReadPermissionsOnCurrentWorkspaceAddNew() throws Exception {
        ClientApiUser clientApiUser = new ClientApiUser();
        clientApiUser.setCurrentWorkspaceId("WORKSPACE_123");
        Mockito.when((Object)this.userRepository.toClientApiPrivate((User)Matchers.eq((Object)this.user))).thenReturn((Object)clientApiUser);
        Mockito.when((Object)this.workspaceRepository.hasReadPermissions((String)Matchers.eq((Object)"WORKSPACE_123"), (User)Matchers.eq((Object)this.user))).thenReturn((Object)false);
        TestWorkspace workspace = new TestWorkspace("junit-id", "junit-display-title");
        Mockito.when((Object)this.workspaceRepository.add((User)this.user)).thenReturn((Object)workspace);
        ClientApiUser response = this.meGet.handle(this.request, (User)this.user);
        Assert.assertEquals((Object)workspace.getWorkspaceId(), (Object)response.getCurrentWorkspaceId());
        Assert.assertEquals((Object)workspace.getDisplayTitle(), (Object)response.getCurrentWorkspaceName());
    }

    @Test
    public void testNoReadPermissionsOnCurrentWorkspaceWithOtherAsCreator() throws Exception {
        ClientApiUser clientApiUser = new ClientApiUser();
        clientApiUser.setCurrentWorkspaceId("WORKSPACE_123");
        Mockito.when((Object)this.userRepository.toClientApiPrivate((User)Matchers.eq((Object)this.user))).thenReturn((Object)clientApiUser);
        Mockito.when((Object)this.workspaceRepository.hasReadPermissions((String)Matchers.eq((Object)"WORKSPACE_123"), (User)Matchers.eq((Object)this.user))).thenReturn((Object)false);
        Mockito.when((Object)this.workspaceRepository.findAllForUser((User)this.user)).thenReturn(Arrays.asList(this.workspaceShared1, this.workspaceCreator1, this.workspaceCreator2));
        ClientApiUser response = this.meGet.handle(this.request, (User)this.user);
        Assert.assertEquals((Object)this.workspaceCreator2.getWorkspaceId(), (Object)response.getCurrentWorkspaceId());
        Assert.assertEquals((Object)this.workspaceCreator2.getDisplayTitle(), (Object)response.getCurrentWorkspaceName());
    }

    @Test
    public void testNoReadPermissionsOnCurrentWorkspaceWithOtherAsShared() throws Exception {
        ClientApiUser clientApiUser = new ClientApiUser();
        clientApiUser.setCurrentWorkspaceId("WORKSPACE_123");
        Mockito.when((Object)this.userRepository.toClientApiPrivate((User)Matchers.eq((Object)this.user))).thenReturn((Object)clientApiUser);
        Mockito.when((Object)this.workspaceRepository.hasReadPermissions((String)Matchers.eq((Object)"WORKSPACE_123"), (User)Matchers.eq((Object)this.user))).thenReturn((Object)false);
        Mockito.when((Object)this.workspaceRepository.findAllForUser((User)this.user)).thenReturn(Arrays.asList(this.workspaceShared1, this.workspaceShared2));
        ClientApiUser response = this.meGet.handle(this.request, (User)this.user);
        Assert.assertEquals((Object)this.workspaceShared2.getWorkspaceId(), (Object)response.getCurrentWorkspaceId());
        Assert.assertEquals((Object)this.workspaceShared2.getDisplayTitle(), (Object)response.getCurrentWorkspaceName());
    }

    @Test
    public void testHasReadPermissionsThrowsExceptionAddNew() throws Exception {
        ClientApiUser clientApiUser = new ClientApiUser();
        clientApiUser.setCurrentWorkspaceId("WORKSPACE_123");
        Mockito.when((Object)this.userRepository.toClientApiPrivate((User)Matchers.eq((Object)this.user))).thenReturn((Object)clientApiUser);
        Mockito.when((Object)this.workspaceRepository.hasReadPermissions((String)Matchers.eq((Object)"WORKSPACE_123"), (User)Matchers.eq((Object)this.user))).thenThrow(new Throwable[]{new VisalloException("boom")});
        TestWorkspace workspace = new TestWorkspace("junit-id", "junit-display-title");
        Mockito.when((Object)this.workspaceRepository.add((User)this.user)).thenReturn((Object)workspace);
        ClientApiUser response = this.meGet.handle(this.request, (User)this.user);
        Assert.assertEquals((Object)workspace.getWorkspaceId(), (Object)response.getCurrentWorkspaceId());
        Assert.assertEquals((Object)workspace.getDisplayTitle(), (Object)response.getCurrentWorkspaceName());
    }

    @Test
    public void testHasReadPermissionsThrowsExceptionWithOtherAsCreator() throws Exception {
        ClientApiUser clientApiUser = new ClientApiUser();
        clientApiUser.setCurrentWorkspaceId("WORKSPACE_123");
        Mockito.when((Object)this.userRepository.toClientApiPrivate((User)Matchers.eq((Object)this.user))).thenReturn((Object)clientApiUser);
        Mockito.when((Object)this.workspaceRepository.hasReadPermissions((String)Matchers.eq((Object)"WORKSPACE_123"), (User)Matchers.eq((Object)this.user))).thenThrow(new Throwable[]{new VisalloException("boom")});
        Mockito.when((Object)this.workspaceRepository.findAllForUser((User)this.user)).thenReturn(Arrays.asList(this.workspaceCreator1, this.workspaceShared1, this.workspaceCreator2));
        ClientApiUser response = this.meGet.handle(this.request, (User)this.user);
        Assert.assertEquals((Object)this.workspaceCreator2.getWorkspaceId(), (Object)response.getCurrentWorkspaceId());
        Assert.assertEquals((Object)this.workspaceCreator2.getDisplayTitle(), (Object)response.getCurrentWorkspaceName());
    }

    @Test
    public void testHasReadPermissionsThrowsExceptionWithOtherAsShared() throws Exception {
        ClientApiUser clientApiUser = new ClientApiUser();
        clientApiUser.setCurrentWorkspaceId("WORKSPACE_123");
        Mockito.when((Object)this.userRepository.toClientApiPrivate((User)Matchers.eq((Object)this.user))).thenReturn((Object)clientApiUser);
        Mockito.when((Object)this.workspaceRepository.hasReadPermissions((String)Matchers.eq((Object)"WORKSPACE_123"), (User)Matchers.eq((Object)this.user))).thenThrow(new Throwable[]{new VisalloException("boom")});
        Mockito.when((Object)this.workspaceRepository.findAllForUser((User)this.user)).thenReturn(Arrays.asList(this.workspaceShared1, this.workspaceShared2));
        ClientApiUser response = this.meGet.handle(this.request, (User)this.user);
        Assert.assertEquals((Object)this.workspaceShared2.getWorkspaceId(), (Object)response.getCurrentWorkspaceId());
        Assert.assertEquals((Object)this.workspaceShared2.getDisplayTitle(), (Object)response.getCurrentWorkspaceName());
    }

    private class TestWorkspace
    implements Workspace {
        private String id;
        private String title;

        TestWorkspace(String id, String title) {
            this.id = id;
            this.title = title;
        }

        public String getWorkspaceId() {
            return this.id;
        }

        public String getDisplayTitle() {
            return this.title;
        }
    }
}

