/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.vertex;

import java.io.IOException;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.vertexium.Authorizations;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.Vertex;
import org.vertexium.Visibility;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.model.workspace.WorkspaceHelper;
import org.visallo.web.clientapi.model.VisibilityJson;
import org.visallo.web.routes.RouteTestBase;
import org.visallo.web.routes.vertex.UnresolveTermEntity;

@RunWith(value=MockitoJUnitRunner.class)
public class UnresolveTermEntityTest
extends RouteTestBase {
    private UnresolveTermEntity unresolveTermEntity;
    private Visibility visibility;
    private Visibility termMentionVisibility;
    private Authorizations authorizations;

    @Before
    public void before() throws IOException {
        super.before();
        this.visibility = new Visibility("");
        this.termMentionVisibility = new Visibility("termMention");
        this.authorizations = this.graph.createAuthorizations(new String[]{"termMention"});
        this.unresolveTermEntity = new UnresolveTermEntity(this.termMentionRepository, this.graph, this.workspaceHelper);
    }

    @Test
    public void testHandle() throws Exception {
        Vertex v1 = this.graph.addVertex("v1", this.visibility, this.authorizations);
        Vertex v1tm1 = this.graph.addVertex("v1tm1", this.termMentionVisibility, this.authorizations);
        VisalloProperties.TERM_MENTION_RESOLVED_EDGE_ID.setProperty((Element)v1tm1, (Object)"v1_to_v2", this.termMentionVisibility, this.authorizations);
        Vertex v2 = this.graph.addVertex("v2", this.visibility, this.authorizations);
        this.graph.addEdge("v1_to_c1tm1", v1, v1tm1, "http://visallo.org/termMention#hasTermMention", this.termMentionVisibility, this.authorizations);
        this.graph.addEdge("c1tm1_to_v2", v1tm1, v2, "http://visallo.org/termMention#resolvedTo", this.termMentionVisibility, this.authorizations);
        Edge e = this.graph.addEdge("v1_to_v2", v1, v2, "link", this.visibility, this.authorizations);
        VisibilityJson visibilityJson = new VisibilityJson();
        visibilityJson.addWorkspace("WORKSPACE_12345");
        VisalloProperties.VISIBILITY_JSON.setProperty((Element)e, (Object)visibilityJson, new Visibility(""), this.authorizations);
        this.graph.flush();
        Mockito.when((Object)this.termMentionRepository.findById((String)Matchers.eq((Object)"v1tm1"), (Authorizations)Matchers.eq((Object)this.authorizations))).thenReturn((Object)v1tm1);
        this.unresolveTermEntity.handle("v1tm1", "WORKSPACE_12345", this.authorizations);
        ((WorkspaceHelper)Mockito.verify((Object)this.workspaceHelper)).unresolveTerm((Vertex)Matchers.eq((Object)v1tm1), (Authorizations)Matchers.eq((Object)this.authorizations));
    }
}

