/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.vertex;

import java.io.IOException;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.vertexium.Authorizations;
import org.vertexium.Vertex;
import org.visallo.core.exception.VisalloAccessDeniedException;
import org.visallo.core.model.user.AuthorizationRepository;
import org.visallo.core.user.User;
import org.visallo.web.clientapi.model.ClientApiElement;
import org.visallo.web.clientapi.model.ClientApiVertex;
import org.visallo.web.clientapi.model.ClientApiVertexMultipleResponse;
import org.visallo.web.clientapi.model.VisibilityJson;
import org.visallo.web.routes.RouteTestBase;
import org.visallo.web.routes.vertex.VertexMultiple;

@RunWith(value=MockitoJUnitRunner.class)
public class VertexMultipleTest
extends RouteTestBase {
    private VertexMultiple route;
    private Authorizations userAuthorizations;
    private Authorizations workspaceAuthorizations;
    @Mock
    private AuthorizationRepository authorizationRepository;
    private Vertex publicVertex;
    private Vertex sandboxedVertex;

    @Before
    public void before() throws IOException {
        super.before();
        this.userAuthorizations = this.graph.createAuthorizations(new String[]{"junit"});
        this.workspaceAuthorizations = this.graph.createAuthorizations(this.userAuthorizations, new String[]{"WORKSPACE_12345"});
        this.publicVertex = this.graph.addVertex("v1", this.visibilityTranslator.getDefaultVisibility(), this.userAuthorizations);
        VisibilityJson visibilityJson = new VisibilityJson();
        visibilityJson.addWorkspace("WORKSPACE_12345");
        this.sandboxedVertex = this.graph.addVertex("v2", this.visibilityTranslator.toVisibility(visibilityJson).getVisibility(), this.workspaceAuthorizations);
        this.route = new VertexMultiple(this.graph, this.userRepository, this.workspaceRepository, this.authorizationRepository);
    }

    @Test
    public void testGetVerticesWithNoWorkspaceId() throws Exception {
        Mockito.when((Object)this.authorizationRepository.getGraphAuthorizations((User)this.user, new String[0])).thenReturn((Object)this.userAuthorizations);
        Mockito.when((Object)this.request.getAttribute((String)Matchers.eq((Object)"workspaceId"))).thenReturn(null);
        ClientApiVertexMultipleResponse response = this.route.handle(this.request, new String[]{this.publicVertex.getId()}, true, false, (User)this.user);
        Assert.assertFalse((boolean)response.isRequiredFallback());
        Assert.assertEquals((long)1L, (long)response.getVertices().size());
        Assert.assertEquals((Object)this.publicVertex.getId(), (Object)((ClientApiVertex)response.getVertices().get(0)).getId());
    }

    @Test(expected=VisalloAccessDeniedException.class)
    public void testGetVerticesWithNoWorkspaceAccessAndNoFallback() throws Exception {
        Mockito.when((Object)this.authorizationRepository.getGraphAuthorizations((User)this.user, new String[0])).thenReturn((Object)this.userAuthorizations);
        Mockito.when((Object)this.request.getAttribute("user")).thenReturn((Object)this.user);
        Mockito.when((Object)this.workspaceRepository.hasReadPermissions("WORKSPACE_12345", (User)this.user)).thenReturn((Object)false);
        this.route.handle(this.request, new String[]{this.publicVertex.getId()}, false, false, (User)this.user);
    }

    @Test
    public void testGetVerticesWithNoWorkspaceAccessAndFallbackToPublic() throws Exception {
        Mockito.when((Object)this.authorizationRepository.getGraphAuthorizations((User)this.user, new String[0])).thenReturn((Object)this.userAuthorizations);
        Mockito.when((Object)this.request.getAttribute("user")).thenReturn((Object)this.user);
        Mockito.when((Object)this.workspaceRepository.hasReadPermissions("WORKSPACE_12345", (User)this.user)).thenReturn((Object)false);
        ClientApiVertexMultipleResponse response = this.route.handle(this.request, new String[]{this.publicVertex.getId(), this.sandboxedVertex.getId()}, true, false, (User)this.user);
        Assert.assertTrue((boolean)response.isRequiredFallback());
        Assert.assertEquals((long)1L, (long)response.getVertices().size());
        Assert.assertEquals((Object)this.publicVertex.getId(), (Object)((ClientApiVertex)response.getVertices().get(0)).getId());
    }

    @Test
    public void testGetVertices() throws Exception {
        Mockito.when((Object)this.authorizationRepository.getGraphAuthorizations((User)this.user, new String[]{"WORKSPACE_12345"})).thenReturn((Object)this.workspaceAuthorizations);
        Mockito.when((Object)this.request.getAttribute("user")).thenReturn((Object)this.user);
        Mockito.when((Object)this.workspaceRepository.hasReadPermissions("WORKSPACE_12345", (User)this.user)).thenReturn((Object)true);
        ClientApiVertexMultipleResponse response = this.route.handle(this.request, new String[]{this.publicVertex.getId(), this.sandboxedVertex.getId()}, true, false, (User)this.user);
        Assert.assertFalse((boolean)response.isRequiredFallback());
        Assert.assertEquals((long)2L, (long)response.getVertices().size());
        Assert.assertTrue((boolean)response.getVertices().stream().map(ClientApiElement::getId).collect(Collectors.toList()).contains(this.publicVertex.getId()));
        Assert.assertTrue((boolean)response.getVertices().stream().map(ClientApiElement::getId).collect(Collectors.toList()).contains(this.sandboxedVertex.getId()));
    }

    @Test
    public void testGetVerticesWithUnknownId() throws Exception {
        Mockito.when((Object)this.authorizationRepository.getGraphAuthorizations((User)this.user, new String[]{"WORKSPACE_12345"})).thenReturn((Object)this.workspaceAuthorizations);
        Mockito.when((Object)this.request.getAttribute("user")).thenReturn((Object)this.user);
        Mockito.when((Object)this.workspaceRepository.hasReadPermissions("WORKSPACE_12345", (User)this.user)).thenReturn((Object)true);
        ClientApiVertexMultipleResponse response = this.route.handle(this.request, new String[]{"no-vertex-id"}, true, false, (User)this.user);
        Assert.assertFalse((boolean)response.isRequiredFallback());
        Assert.assertEquals((long)0L, (long)response.getVertices().size());
    }

    @Test
    public void testGetVerticesWithNoneSpecified() throws Exception {
        Mockito.when((Object)this.authorizationRepository.getGraphAuthorizations((User)this.user, new String[]{"WORKSPACE_12345"})).thenReturn((Object)this.workspaceAuthorizations);
        Mockito.when((Object)this.request.getAttribute("user")).thenReturn((Object)this.user);
        Mockito.when((Object)this.workspaceRepository.hasReadPermissions("WORKSPACE_12345", (User)this.user)).thenReturn((Object)true);
        ClientApiVertexMultipleResponse response = this.route.handle(this.request, new String[0], true, false, (User)this.user);
        Assert.assertFalse((boolean)response.isRequiredFallback());
        Assert.assertEquals((long)0L, (long)response.getVertices().size());
    }
}

