/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.util.js;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Future;
import javax.script.ScriptException;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.visallo.web.util.js.BabelExecutor;
import org.visallo.web.util.js.CachedCompilation;
import org.visallo.web.util.js.SourceMapType;

public class BabelExecutorTest {
    private static BabelExecutor executor;

    @BeforeClass
    public static void before() {
        executor = new BabelExecutor();
    }

    @Test
    public void testShouldCompileJsx() throws Exception {
        this.testFixture("basic");
        this.testFixture("objectspread");
    }

    @Test
    public void testShouldCreateSourceMaps() throws Exception {
        Assert.assertEquals(null, (Object)this.testFixture("sourcemapinline", SourceMapType.INLINE).getSourceMap());
        Assert.assertEquals((Object)this.getResource("sourcemapext-expected.js.map"), (Object)this.testFixture("sourcemapext", SourceMapType.EXTERNAL).getSourceMap());
    }

    private void testFixture(String prefix) throws Exception {
        this.testFixture(prefix, SourceMapType.NONE);
    }

    private CachedCompilation testFixture(String prefix, SourceMapType mapType) throws Exception {
        Future compilationTask = executor.submit(() -> this.compileFixtureForPrefix(prefix, mapType));
        CachedCompilation out = (CachedCompilation)compilationTask.get();
        Assert.assertEquals((Object)this.expectedForPrefix(prefix), (Object)out.getOutput());
        return out;
    }

    private String expectedForPrefix(String prefix) {
        return this.getResource(prefix + "-expected.js");
    }

    private CachedCompilation compileFixtureForPrefix(String prefix, SourceMapType sourceMap) {
        String resourcePath = prefix + "-source.jsx";
        CachedCompilation c = new CachedCompilation();
        c.setPath("/path");
        c.setInput(this.getResource(resourcePath));
        c.setResourcePath(resourcePath);
        try {
            executor.compileWithSharedEngine(c, sourceMap);
        }
        catch (ScriptException e) {
            throw new RuntimeException(e);
        }
        return c;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getResource(String resourcePath) {
        try (InputStream input = this.getClass().getResourceAsStream(resourcePath);){
            String string = IOUtils.toString((InputStream)input, (Charset)StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

