/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.PerRequestBroadcastFilter;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.visallo.core.bootstrap.InjectHelper;
import org.visallo.core.config.Configuration;
import org.visallo.core.model.user.UserRepository;
import org.visallo.core.util.JSONUtil;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public class MessagingThrottleFilter
implements PerRequestBroadcastFilter {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(MessagingThrottleFilter.class);
    private UserRepository userRepository;
    private Integer throttleMillis;
    private final Map<String, Long> lastRequestForUuid = new ConcurrentHashMap<String, Long>();
    private final Map<String, List<JSONObject>> messagesForUuid = new ConcurrentHashMap<String, List<JSONObject>>();
    private final Map<String, Boolean> broadcastScheduledForUuid = new ConcurrentHashMap<String, Boolean>();

    public BroadcastFilter.BroadcastAction filter(String broadcasterId, Object originalMessage, Object message) {
        return new BroadcastFilter.BroadcastAction(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BroadcastFilter.BroadcastAction filter(String broadcasterId, AtmosphereResource r, Object originalMessage, Object message) {
        this.ensureInitialized();
        try {
            if (message == null || r.isCancelled()) {
                return new BroadcastFilter.BroadcastAction(BroadcastFilter.BroadcastAction.ACTION.ABORT, null);
            }
            JSONObject json = new JSONObject(message.toString());
            if (this.throttleMillis > 0 && !"batch".equals(json.optString("type"))) {
                String uuid = r.uuid();
                String string = this.getMutex(uuid);
                synchronized (string) {
                    boolean queueFuture = !this.broadcastScheduledForUuid.containsKey(uuid);
                    Long timeSinceLastRequest = this.getTimeSinceLastRequest(uuid);
                    if (timeSinceLastRequest < (long)this.throttleMillis.intValue()) {
                        this.addMessageToBatch(json, uuid);
                        if (queueFuture) {
                            this.delayBatchBroadcast(r, (long)this.throttleMillis.intValue() - timeSinceLastRequest);
                        }
                        return new BroadcastFilter.BroadcastAction(BroadcastFilter.BroadcastAction.ACTION.ABORT, message);
                    }
                }
            }
            return new BroadcastFilter.BroadcastAction(message);
        }
        catch (JSONException e) {
            LOGGER.error("Failed to filter message:\n" + originalMessage, (Throwable)e);
            return new BroadcastFilter.BroadcastAction(BroadcastFilter.BroadcastAction.ACTION.ABORT, message);
        }
    }

    private void addMessageToBatch(JSONObject json, String uuid) {
        List<Object> messages;
        if (!this.messagesForUuid.containsKey(uuid)) {
            messages = new ArrayList();
            this.messagesForUuid.put(uuid, messages);
        } else {
            messages = this.messagesForUuid.get(uuid);
        }
        boolean contains = messages.stream().anyMatch(jsonObject -> JSONUtil.areEqual((Object)jsonObject, (Object)json));
        if (!contains) {
            messages.add(json);
        }
    }

    private Long getTimeSinceLastRequest(String uuid) {
        Long lastRequest = 0L;
        Long now = new Date().getTime();
        if (this.lastRequestForUuid.containsKey(uuid)) {
            lastRequest = this.lastRequestForUuid.get(uuid);
        }
        this.lastRequestForUuid.put(uuid, now);
        return now - lastRequest;
    }

    private void delayBatchBroadcast(final AtmosphereResource r, Long delay) {
        final String uuid = r.uuid();
        r.getBroadcaster().getBroadcasterConfig().getScheduledExecutorService().schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String string = MessagingThrottleFilter.this.getMutex(uuid);
                synchronized (string) {
                    List messages = (List)MessagingThrottleFilter.this.messagesForUuid.get(uuid);
                    if (messages != null) {
                        JSONObject batchMessage = new JSONObject();
                        JSONArray jsonMessages = new JSONArray((Collection)messages);
                        batchMessage.put("data", (Object)jsonMessages);
                        batchMessage.put("type", (Object)"batch");
                        r.getBroadcaster().broadcast((Object)batchMessage.toString(), r);
                        MessagingThrottleFilter.this.broadcastScheduledForUuid.remove(uuid);
                        messages.clear();
                    }
                }
            }
        }, (long)delay, TimeUnit.MILLISECONDS);
        this.broadcastScheduledForUuid.put(uuid, true);
    }

    private String getMutex(String uuid) {
        return (this.getClass().getName() + uuid).intern();
    }

    public void ensureInitialized() {
        if (this.userRepository == null) {
            InjectHelper.inject((Object)this);
            if (this.userRepository == null) {
                LOGGER.error("userRepository cannot be null", new Object[0]);
                Preconditions.checkNotNull((Object)this.userRepository, (Object)"userRepository cannot be null");
            }
            if (this.throttleMillis == null) {
                LOGGER.error("throttleMillis cannot be null", new Object[0]);
                Preconditions.checkNotNull((Object)this.throttleMillis, (Object)"throttleMillis cannot be null");
            }
        }
    }

    @Inject
    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    @Inject
    public void setConfiguration(Configuration configuration) {
        this.throttleMillis = configuration.getInt("web.ui.throttle.messaging.seconds") * 1000;
    }
}

