/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;

public class RequestDebugFilter
implements Filter {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(RequestDebugFilter.class);
    public static final String VISALLO_REQUEST_DEBUG = "visallo.request.debug";
    public static final String HEADER_DELAY = "Visallo-Request-Delay-Millis";
    public static final String HEADER_ERROR = "Visallo-Request-Error";
    public static final String HEADER_ERROR_JSON = "Visallo-Request-Error-Json";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if ("true".equals(System.getProperty(VISALLO_REQUEST_DEBUG)) && this.processDebugCommands(request, response)) {
            return;
        }
        chain.doFilter(request, response);
    }

    private boolean processDebugCommands(ServletRequest request, ServletResponse response) throws IOException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            String delay = httpRequest.getHeader(HEADER_DELAY);
            String error = httpRequest.getHeader(HEADER_ERROR);
            String json = httpRequest.getHeader(HEADER_ERROR_JSON);
            if (delay != null) {
                try {
                    LOGGER.warn("Visallo Debug Header Found %s. Delaying for %s", new Object[]{HEADER_DELAY, delay});
                    Thread.sleep(Integer.parseInt(delay));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (json != null) {
                LOGGER.warn("Visallo Debug Header Found %s. Sending error json instead: %s", new Object[]{HEADER_ERROR_JSON, json});
                httpResponse.setStatus(400);
                httpResponse.setContentType("application/json");
                httpResponse.setCharacterEncoding("UTF-8");
                httpResponse.getWriter().write(json);
                return true;
            }
            if (error != null) {
                LOGGER.warn("Visallo Debug Header Found %s. Sending error instead: %s", new Object[]{HEADER_ERROR, error});
                Integer code = Integer.parseInt(error);
                ((HttpServletResponse)response).sendError(code.intValue());
                return true;
            }
        }
        return false;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    static {
        if ("true".equals(System.getProperty(VISALLO_REQUEST_DEBUG))) {
            LOGGER.warn("Request debugging is enabled. Set -D%s=false to disable", new Object[]{VISALLO_REQUEST_DEBUG});
        }
    }
}

