/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.parameterProviders;

import com.google.inject.Inject;
import com.v5analytics.webster.HandlerChain;
import com.v5analytics.webster.parameterProviders.ParameterProvider;
import com.v5analytics.webster.parameterProviders.ParameterProviderFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.visallo.core.config.Configuration;
import org.visallo.core.model.user.UserRepository;
import org.visallo.web.WebApp;
import org.visallo.web.parameterProviders.VisalloBaseParameterProvider;

public class ResourceBundleParameterProviderFactory
extends ParameterProviderFactory<ResourceBundle> {
    private ParameterProvider<ResourceBundle> parameterProvider;

    @Inject
    public ResourceBundleParameterProviderFactory(UserRepository userRepository, Configuration configuration) {
        this.parameterProvider = new VisalloBaseParameterProvider<ResourceBundle>(userRepository, configuration){

            public ResourceBundle getParameter(HttpServletRequest request, HttpServletResponse response, HandlerChain chain) {
                WebApp webApp = this.getWebApp(request);
                Locale locale = this.getLocale(request);
                return webApp.getBundle(locale);
            }
        };
    }

    public boolean isHandled(Method handleMethod, Class<? extends ResourceBundle> parameterType, Annotation[] parameterAnnotations) {
        return ResourceBundle.class.isAssignableFrom(parameterType);
    }

    public ParameterProvider<ResourceBundle> createParameterProvider(Method handleMethod, Class<?> parameterType, Annotation[] parameterAnnotations) {
        return this.parameterProvider;
    }
}

