/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.edge;

import com.google.inject.Inject;
import com.v5analytics.webster.ParameterizedHandler;
import com.v5analytics.webster.annotations.Handle;
import com.v5analytics.webster.annotations.Optional;
import com.v5analytics.webster.annotations.Required;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.vertexium.Authorizations;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.Graph;
import org.vertexium.Metadata;
import org.vertexium.Visibility;
import org.visallo.core.config.Configuration;
import org.visallo.core.model.graph.GraphRepository;
import org.visallo.core.model.graph.VisibilityAndElementMutation;
import org.visallo.core.model.ontology.OntologyProperty;
import org.visallo.core.model.ontology.OntologyRepository;
import org.visallo.core.model.workQueue.Priority;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.model.workspace.WorkspaceRepository;
import org.visallo.core.security.ACLProvider;
import org.visallo.core.security.VisibilityTranslator;
import org.visallo.core.user.User;
import org.visallo.core.util.VertexiumMetadataUtil;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.BadRequestException;
import org.visallo.web.VisalloResponse;
import org.visallo.web.clientapi.model.ClientApiSourceInfo;
import org.visallo.web.clientapi.model.ClientApiSuccess;
import org.visallo.web.parameterProviders.ActiveWorkspaceId;
import org.visallo.web.parameterProviders.JustificationText;
import org.visallo.web.routes.SetPropertyBase;
import org.visallo.web.util.VisibilityValidator;

public class EdgeSetProperty
extends SetPropertyBase
implements ParameterizedHandler {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(EdgeSetProperty.class);
    private final OntologyRepository ontologyRepository;
    private final WorkQueueRepository workQueueRepository;
    private final WorkspaceRepository workspaceRepository;
    private final GraphRepository graphRepository;
    private final ACLProvider aclProvider;
    private final boolean autoPublishComments;

    @Inject
    public EdgeSetProperty(OntologyRepository ontologyRepository, Graph graph, VisibilityTranslator visibilityTranslator, WorkQueueRepository workQueueRepository, WorkspaceRepository workspaceRepository, GraphRepository graphRepository, ACLProvider aclProvider, Configuration configuration) {
        super(graph, visibilityTranslator);
        this.ontologyRepository = ontologyRepository;
        this.workQueueRepository = workQueueRepository;
        this.workspaceRepository = workspaceRepository;
        this.graphRepository = graphRepository;
        this.aclProvider = aclProvider;
        this.autoPublishComments = configuration.getBoolean("comments.autoPublish", false);
    }

    @Handle
    public ClientApiSuccess handle(HttpServletRequest request, @Required(name="edgeId") String edgeId, @Optional(name="propertyKey") String propertyKey, @Required(name="propertyName") String propertyName, @Required(name="value") String valueStr, @Required(name="visibilitySource") String visibilitySource, @Optional(name="sourceInfo") String sourceInfo, @Optional(name="metadata") String metadataString, @JustificationText String justificationText, @ActiveWorkspaceId String workspaceId, ResourceBundle resourceBundle, User user, Authorizations authorizations) throws Exception {
        Object value;
        boolean autoPublish;
        VisibilityValidator.validate(this.graph, this.visibilityTranslator, resourceBundle, visibilitySource, user, authorizations);
        this.checkRoutePath("edge", propertyName, request);
        boolean isComment = this.isCommentProperty(propertyName);
        boolean bl = autoPublish = isComment && this.autoPublishComments;
        if (autoPublish) {
            workspaceId = null;
        }
        if (propertyKey == null) {
            propertyKey = this.createPropertyKey(propertyName, this.graph);
        }
        Edge edge = this.graph.getEdge(edgeId, authorizations);
        this.aclProvider.checkCanAddOrUpdateProperty((Element)edge, propertyKey, propertyName, user);
        OntologyProperty property = this.ontologyRepository.getRequiredPropertyByIRI(propertyName);
        try {
            value = property.convertString(valueStr);
        }
        catch (Exception ex) {
            LOGGER.warn(String.format("Validation error propertyName: %s, valueStr: %s", propertyName, valueStr), (Throwable)ex);
            throw new BadRequestException(ex.getMessage());
        }
        Metadata metadata = VertexiumMetadataUtil.metadataStringToMap((String)metadataString, (Visibility)this.visibilityTranslator.getDefaultVisibility());
        VisibilityAndElementMutation setPropertyResult = this.graphRepository.setProperty((Element)edge, propertyName, propertyKey, value, metadata, null, visibilitySource, workspaceId, justificationText, ClientApiSourceInfo.fromString((String)sourceInfo), user, authorizations);
        setPropertyResult.elementMutation.save(authorizations);
        if (!autoPublish) {
            this.workspaceRepository.updateEntityOnWorkspace(workspaceId, edge.getVertexId(Direction.IN), null, null, user);
            this.workspaceRepository.updateEntityOnWorkspace(workspaceId, edge.getVertexId(Direction.OUT), null, null, user);
        }
        this.workQueueRepository.pushGraphPropertyQueue((Element)edge, propertyKey, propertyName, workspaceId, visibilitySource, Priority.HIGH);
        return VisalloResponse.SUCCESS;
    }
}

