/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.resource;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.inject.Inject;
import com.v5analytics.webster.ParameterizedHandler;
import com.v5analytics.webster.annotations.Handle;
import com.v5analytics.webster.annotations.Optional;
import com.v5analytics.webster.annotations.Required;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import org.visallo.core.model.artifactThumbnails.ArtifactThumbnailRepository;
import org.visallo.core.model.ontology.Concept;
import org.visallo.core.model.ontology.OntologyRepository;
import org.visallo.core.user.User;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.VisalloResponse;

public class MapMarkerImage
implements ParameterizedHandler {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(MapMarkerImage.class);
    private final OntologyRepository ontologyRepository;
    private ArtifactThumbnailRepository artifactThumbnailRepository;
    private final Cache<String, byte[]> imageCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build();

    @Inject
    public MapMarkerImage(OntologyRepository ontologyRepository, ArtifactThumbnailRepository artifactThumbnailRepository) {
        this.ontologyRepository = ontologyRepository;
        this.artifactThumbnailRepository = artifactThumbnailRepository;
    }

    @Handle
    public void handle(@Required(name="type") String typeStr, @Optional(name="scale", defaultValue="1") long scale, @Optional(name="heading", defaultValue="0.0") double headingParam, @Optional(name="selected", defaultValue="false") boolean selected, VisalloResponse response, User user) throws Exception {
        int heading = this.roundHeadingAngle(headingParam);
        String cacheKey = typeStr + scale + heading + (selected ? "selected" : "unselected");
        byte[] imageData = (byte[])this.imageCache.getIfPresent((Object)cacheKey);
        if (imageData == null) {
            LOGGER.info("map marker cache miss %s (scale: %d, heading: %d)", new Object[]{typeStr, scale, heading});
            Concept concept = this.ontologyRepository.getConceptByIRI(typeStr);
            if (concept == null) {
                concept = this.ontologyRepository.getConceptByIRI(typeStr);
            }
            boolean isMapGlyphIcon = false;
            byte[] glyphIcon = this.getMapGlyphIcon(concept, user);
            if (glyphIcon != null) {
                isMapGlyphIcon = true;
            } else {
                glyphIcon = this.getGlyphIcon(concept, user);
                if (glyphIcon == null) {
                    response.respondWithNotFound();
                    return;
                }
            }
            imageData = this.getMarkerImage(new ByteArrayInputStream(glyphIcon), scale, selected, heading, isMapGlyphIcon);
            this.imageCache.put((Object)cacheKey, (Object)imageData);
        }
        response.setHeader("Cache-Control", "max-age=300");
        response.write(imageData);
    }

    private int roundHeadingAngle(double heading) {
        while (heading < 0.0) {
            heading += 360.0;
        }
        while (heading > 360.0) {
            heading -= 360.0;
        }
        return (int)((double)Math.round(heading / 10.0) * 10.0);
    }

    private byte[] getMarkerImage(InputStream resource, long scale, boolean selected, int heading, boolean isMapGlyphIcon) throws IOException {
        BufferedImage backgroundImage;
        BufferedImage resourceImage = ImageIO.read(resource);
        if (resourceImage == null) {
            return null;
        }
        if (heading != 0) {
            resourceImage = this.rotateImage(resourceImage, heading);
        }
        if ((backgroundImage = this.getBackgroundImage(scale, selected)) == null) {
            return null;
        }
        int[] resourceImageDim = new int[]{resourceImage.getWidth(), resourceImage.getHeight()};
        BufferedImage image = new BufferedImage(backgroundImage.getWidth(), backgroundImage.getHeight(), 2);
        Graphics2D g = image.createGraphics();
        if (isMapGlyphIcon) {
            int[] boundary = new int[]{backgroundImage.getWidth(), backgroundImage.getHeight()};
            int[] scaledDims = this.artifactThumbnailRepository.getScaledDimension(resourceImageDim, boundary);
            g.drawImage(resourceImage, 0, 0, scaledDims[0], scaledDims[1], null);
        } else {
            g.drawImage(backgroundImage, 0, 0, backgroundImage.getWidth(), backgroundImage.getHeight(), null);
            int size = image.getWidth() * 2 / 3;
            int[] boundary = new int[]{size, size};
            int[] scaledDims = this.artifactThumbnailRepository.getScaledDimension(resourceImageDim, boundary);
            int x = (backgroundImage.getWidth() - scaledDims[0]) / 2;
            int y = (backgroundImage.getWidth() - scaledDims[1]) / 2;
            g.drawImage(resourceImage, x, y, scaledDims[0], scaledDims[1], null);
        }
        g.dispose();
        return this.imageToBytes(image);
    }

    private BufferedImage rotateImage(BufferedImage image, int angleDeg) {
        BufferedImage rotatedImage = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
        Graphics2D g = rotatedImage.createGraphics();
        g.rotate(Math.toRadians(angleDeg), rotatedImage.getWidth() / 2, rotatedImage.getHeight() / 2);
        g.drawImage(image, 0, 0, image.getWidth(), image.getHeight(), null);
        g.dispose();
        return rotatedImage;
    }

    private BufferedImage getBackgroundImage(long scale, boolean selected) throws IOException {
        String imageFileName;
        if (scale == 1L) {
            imageFileName = selected ? "marker-background-selected.png" : "marker-background.png";
        } else if (scale == 2L) {
            imageFileName = selected ? "marker-background-selected-2x.png" : "marker-background-2x.png";
        } else {
            return null;
        }
        try (InputStream resourceInputStream = MapMarkerImage.class.getResourceAsStream(imageFileName);){
            Preconditions.checkNotNull((Object)resourceInputStream, (Object)("Could not find image resource: " + imageFileName));
            BufferedImage bufferedImage = ImageIO.read(resourceInputStream);
            return bufferedImage;
        }
    }

    private byte[] imageToBytes(BufferedImage image) throws IOException {
        ByteArrayOutputStream imageData = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", imageData);
        imageData.close();
        return imageData.toByteArray();
    }

    private byte[] getMapGlyphIcon(Concept concept, User user) {
        byte[] mapGlyphIcon = null;
        Concept con = concept;
        while (mapGlyphIcon == null && con != null) {
            mapGlyphIcon = con.getMapGlyphIcon();
            con = this.ontologyRepository.getParentConcept(con);
        }
        return mapGlyphIcon;
    }

    private byte[] getGlyphIcon(Concept concept, User user) {
        byte[] glyphIcon = null;
        Concept con = concept;
        while (glyphIcon == null && con != null) {
            glyphIcon = con.hasGlyphIconResource() ? con.getGlyphIcon() : null;
            con = this.ontologyRepository.getParentConcept(con);
        }
        return glyphIcon;
    }
}

