/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.user;

import com.google.inject.Inject;
import com.v5analytics.webster.ParameterizedHandler;
import com.v5analytics.webster.annotations.Handle;
import javax.servlet.http.HttpServletRequest;
import org.visallo.core.model.user.UserSessionCounterRepository;
import org.visallo.web.CurrentUser;
import org.visallo.web.VisalloResponse;
import org.visallo.web.clientapi.model.ClientApiSuccess;

public class Logout
implements ParameterizedHandler {
    private UserSessionCounterRepository userSessionCounterRepository;

    @Inject
    public Logout(UserSessionCounterRepository userSessionCounterRepository) {
        this.userSessionCounterRepository = userSessionCounterRepository;
    }

    @Handle
    public ClientApiSuccess handle(HttpServletRequest request) throws Exception {
        String userId = CurrentUser.getUserId(request);
        String sessionId = request.getSession().getId();
        this.userSessionCounterRepository.deleteSession(userId, sessionId);
        CurrentUser.clearUserFromSession(request);
        request.getSession().invalidate();
        return VisalloResponse.SUCCESS;
    }
}

