/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.vertex;

import com.google.common.base.Preconditions;
import com.v5analytics.webster.annotations.Handle;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.vertexium.Authorizations;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.Vertex;
import org.vertexium.query.Aggregation;
import org.vertexium.query.AggregationResult;
import org.vertexium.query.CalendarFieldAggregation;
import org.vertexium.query.GeohashAggregation;
import org.vertexium.query.GeohashBucket;
import org.vertexium.query.GeohashResult;
import org.vertexium.query.HistogramAggregation;
import org.vertexium.query.HistogramBucket;
import org.vertexium.query.HistogramResult;
import org.vertexium.query.IterableWithScores;
import org.vertexium.query.IterableWithSearchTime;
import org.vertexium.query.QueryResultsIterable;
import org.vertexium.query.StatisticsAggregation;
import org.vertexium.query.StatisticsResult;
import org.vertexium.query.TermsAggregation;
import org.vertexium.query.TermsBucket;
import org.vertexium.query.TermsResult;
import org.vertexium.type.GeoPoint;
import org.vertexium.type.GeoRect;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.model.search.ElementSearchRunnerBase;
import org.visallo.core.model.search.QueryResultsIterableSearchResults;
import org.visallo.core.model.search.SearchOptions;
import org.visallo.core.user.User;
import org.visallo.core.util.ClientApiConverter;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.clientapi.model.ClientApiElement;
import org.visallo.web.clientapi.model.ClientApiElementSearchResponse;
import org.visallo.web.clientapi.model.ClientApiSearchResponse;
import org.visallo.web.clientapi.model.ClientApiVertex;
import org.visallo.web.parameterProviders.ActiveWorkspaceId;
import org.visallo.web.routes.search.WebSearchOptionsFactory;

public abstract class ElementSearchBase {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(ElementSearchBase.class);
    private static final Pattern DATE_TIME_PATTERN = Pattern.compile("^\\d{4}-\\d{2}-\\d{2}T.*");
    private final ElementSearchRunnerBase searchRunner;

    public ElementSearchBase(ElementSearchRunnerBase searchRunner) {
        Preconditions.checkNotNull((Object)searchRunner, (Object)"searchRunner is required");
        this.searchRunner = searchRunner;
    }

    @Handle
    public ClientApiElementSearchResponse handle(HttpServletRequest request, @ActiveWorkspaceId String workspaceId, User user, Authorizations authorizations) throws Exception {
        SearchOptions searchOptions = WebSearchOptionsFactory.create(request, workspaceId);
        try (QueryResultsIterableSearchResults searchResults = this.searchRunner.run(searchOptions, user, authorizations);){
            Map scores = null;
            if (searchResults.getQueryResultsIterable() instanceof IterableWithScores) {
                scores = ((IterableWithScores)searchResults.getQueryResultsIterable()).getScores();
            }
            List<ClientApiElement> elementList = this.convertElementsToClientApi(searchResults.getQueryAndData(), (Iterable<? extends Element>)searchResults.getQueryResultsIterable(), scores, searchOptions.getWorkspaceId(), authorizations);
            ClientApiElementSearchResponse results = new ClientApiElementSearchResponse();
            results.getElements().addAll(elementList);
            results.setNextOffset(Integer.valueOf((int)(searchResults.getOffset() + searchResults.getSize())));
            this.addSearchResultsDataToResults(results, searchResults.getQueryAndData(), (QueryResultsIterable<? extends Element>)searchResults.getQueryResultsIterable());
            ClientApiElementSearchResponse clientApiElementSearchResponse = results;
            return clientApiElementSearchResponse;
        }
    }

    private void addSearchResultsDataToResults(ClientApiElementSearchResponse results, ElementSearchRunnerBase.QueryAndData queryAndData, QueryResultsIterable<? extends Element> searchResults) {
        results.setTotalHits(Long.valueOf(searchResults.getTotalHits()));
        if (searchResults instanceof IterableWithSearchTime) {
            results.setSearchTime(Long.valueOf(((IterableWithSearchTime)searchResults).getSearchTimeNanoSeconds()));
        }
        for (Aggregation aggregation : queryAndData.getQuery().getAggregations()) {
            results.getAggregates().put(aggregation.getAggregationName(), this.toClientApiAggregateResult(searchResults, aggregation));
        }
    }

    private ClientApiSearchResponse.AggregateResult toClientApiAggregateResult(QueryResultsIterable<? extends Element> searchResults, Aggregation aggregation) {
        AggregationResult aggResult;
        if (aggregation instanceof TermsAggregation) {
            aggResult = searchResults.getAggregationResult(aggregation.getAggregationName(), TermsResult.class);
        } else if (aggregation instanceof GeohashAggregation) {
            aggResult = searchResults.getAggregationResult(aggregation.getAggregationName(), GeohashResult.class);
        } else if (aggregation instanceof HistogramAggregation || aggregation instanceof CalendarFieldAggregation) {
            aggResult = searchResults.getAggregationResult(aggregation.getAggregationName(), HistogramResult.class);
        } else if (aggregation instanceof StatisticsAggregation) {
            aggResult = searchResults.getAggregationResult(aggregation.getAggregationName(), StatisticsResult.class);
        } else {
            throw new VisalloException("Unhandled aggregation type: " + aggregation.getClass().getName());
        }
        return this.toClientApiAggregateResult(aggResult);
    }

    private Map<String, ClientApiSearchResponse.AggregateResult> toClientApiNestedResults(Map<String, AggregationResult> nestedResults) {
        HashMap<String, ClientApiSearchResponse.AggregateResult> results = new HashMap<String, ClientApiSearchResponse.AggregateResult>();
        for (Map.Entry<String, AggregationResult> entry : nestedResults.entrySet()) {
            ClientApiSearchResponse.AggregateResult aggResult = this.toClientApiAggregateResult(entry.getValue());
            results.put(entry.getKey(), aggResult);
        }
        if (results.size() == 0) {
            return null;
        }
        return results;
    }

    private ClientApiSearchResponse.AggregateResult toClientApiAggregateResult(AggregationResult aggResult) {
        if (aggResult instanceof TermsResult) {
            return this.toClientApiTermsAggregateResult((TermsResult)aggResult);
        }
        if (aggResult instanceof GeohashResult) {
            return this.toClientApiGeohashResult((GeohashResult)aggResult);
        }
        if (aggResult instanceof HistogramResult) {
            return this.toClientApiHistogramResult((HistogramResult)aggResult);
        }
        if (aggResult instanceof StatisticsResult) {
            return this.toClientApiStatisticsResult((StatisticsResult)aggResult);
        }
        throw new VisalloException("Unhandled aggregation result type: " + aggResult.getClass().getName());
    }

    private ClientApiSearchResponse.AggregateResult toClientApiStatisticsResult(StatisticsResult agg) {
        ClientApiSearchResponse.StatisticsAggregateResult result = new ClientApiSearchResponse.StatisticsAggregateResult();
        result.setCount(agg.getCount());
        result.setAverage(agg.getAverage());
        result.setMin(agg.getMin());
        result.setMax(agg.getMax());
        result.setStandardDeviation(agg.getStandardDeviation());
        result.setSum(agg.getSum());
        return result;
    }

    private ClientApiSearchResponse.AggregateResult toClientApiHistogramResult(HistogramResult agg) {
        SimpleDateFormat bucketDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        ClientApiSearchResponse.HistogramAggregateResult result = new ClientApiSearchResponse.HistogramAggregateResult();
        for (HistogramBucket histogramBucket : agg.getBuckets()) {
            ClientApiSearchResponse.HistogramAggregateResult.Bucket b = new ClientApiSearchResponse.HistogramAggregateResult.Bucket(histogramBucket.getCount(), this.toClientApiNestedResults(histogramBucket.getNestedResults()));
            String key = histogramBucket.getKey().toString();
            if (DATE_TIME_PATTERN.matcher(key).matches()) {
                try {
                    Date date = bucketDateFormat.parse(key);
                    if (date != null) {
                        key = String.valueOf(date.getTime());
                    }
                }
                catch (ParseException pe) {
                    LOGGER.warn("Unable to parse histogram date", (Throwable)pe);
                }
            }
            result.getBuckets().put(key, b);
        }
        return result;
    }

    private ClientApiSearchResponse.AggregateResult toClientApiGeohashResult(GeohashResult agg) {
        ClientApiSearchResponse.GeohashAggregateResult result = new ClientApiSearchResponse.GeohashAggregateResult();
        result.setMaxCount(agg.getMaxCount());
        for (GeohashBucket geohashBucket : agg.getBuckets()) {
            ClientApiSearchResponse.GeohashAggregateResult.Bucket b = new ClientApiSearchResponse.GeohashAggregateResult.Bucket(ClientApiConverter.toClientApiGeoRect((GeoRect)geohashBucket.getGeoCell()), ClientApiConverter.toClientApiGeoPoint((GeoPoint)geohashBucket.getGeoPoint()), geohashBucket.getCount(), this.toClientApiNestedResults(geohashBucket.getNestedResults()));
            result.getBuckets().put(geohashBucket.getKey(), b);
        }
        return result;
    }

    private ClientApiSearchResponse.TermsAggregateResult toClientApiTermsAggregateResult(TermsResult agg) {
        ClientApiSearchResponse.TermsAggregateResult result = new ClientApiSearchResponse.TermsAggregateResult();
        for (TermsBucket termsBucket : agg.getBuckets()) {
            ClientApiSearchResponse.TermsAggregateResult.Bucket b = new ClientApiSearchResponse.TermsAggregateResult.Bucket(termsBucket.getCount(), this.toClientApiNestedResults(termsBucket.getNestedResults()));
            result.getBuckets().put(termsBucket.getKey().toString(), b);
        }
        return result;
    }

    protected List<ClientApiElement> convertElementsToClientApi(ElementSearchRunnerBase.QueryAndData queryAndData, Iterable<? extends Element> searchResults, Map<String, Double> scores, String workspaceId, Authorizations authorizations) {
        ArrayList<ClientApiElement> elementsList = new ArrayList<ClientApiElement>();
        for (Element element : searchResults) {
            ClientApiVertex elem;
            Integer commonCount = this.getCommonCount(queryAndData, element);
            if (element instanceof Vertex) {
                elem = ClientApiConverter.toClientApiVertex((Vertex)((Vertex)element), (String)workspaceId, (Integer)commonCount, (Authorizations)authorizations);
            } else if (element instanceof Edge) {
                elem = ClientApiConverter.toClientApiEdge((Edge)((Edge)element), (String)workspaceId);
            } else {
                throw new VisalloException("Unhandled element type: " + element.getClass().getName());
            }
            if (scores != null) {
                elem.setScore(scores.get(element.getId()));
            }
            elementsList.add((ClientApiElement)elem);
        }
        return elementsList;
    }

    protected Integer getCommonCount(ElementSearchRunnerBase.QueryAndData queryAndData, Element element) {
        return null;
    }
}

