/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.vertex;

import com.google.inject.Inject;
import com.v5analytics.webster.ParameterizedHandler;
import com.v5analytics.webster.annotations.Handle;
import com.v5analytics.webster.annotations.Required;
import org.vertexium.Authorizations;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.Graph;
import org.vertexium.Vertex;
import org.vertexium.util.IterableUtils;
import org.visallo.core.exception.VisalloResourceNotFoundException;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.model.termMention.TermMentionRepository;
import org.visallo.core.model.workspace.WorkspaceHelper;
import org.visallo.core.util.SandboxStatusUtil;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.BadRequestException;
import org.visallo.web.VisalloResponse;
import org.visallo.web.clientapi.model.ClientApiSuccess;
import org.visallo.web.clientapi.model.SandboxStatus;
import org.visallo.web.clientapi.model.VisibilityJson;
import org.visallo.web.parameterProviders.ActiveWorkspaceId;

public class UnresolveTermEntity
implements ParameterizedHandler {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(UnresolveTermEntity.class);
    private final TermMentionRepository termMentionRepository;
    private final Graph graph;
    private final WorkspaceHelper workspaceHelper;

    @Inject
    public UnresolveTermEntity(TermMentionRepository termMentionRepository, Graph graph, WorkspaceHelper workspaceHelper) {
        this.termMentionRepository = termMentionRepository;
        this.graph = graph;
        this.workspaceHelper = workspaceHelper;
    }

    @Handle
    public ClientApiSuccess handle(@Required(name="termMentionId") String termMentionId, @ActiveWorkspaceId String workspaceId, Authorizations authorizations) throws Exception {
        LOGGER.debug("UnresolveTermEntity (termMentionId: %s)", new Object[]{termMentionId});
        Vertex termMention = this.termMentionRepository.findById(termMentionId, authorizations);
        if (termMention == null) {
            throw new VisalloResourceNotFoundException("Could not find term mention with id: " + termMentionId);
        }
        Vertex resolvedVertex = (Vertex)IterableUtils.singleOrDefault((Iterable)termMention.getVertices(Direction.OUT, "http://visallo.org/termMention#resolvedTo", authorizations), null);
        if (resolvedVertex == null) {
            throw new VisalloResourceNotFoundException("Could not find resolved vertex from term mention: " + termMentionId);
        }
        String edgeId = (String)VisalloProperties.TERM_MENTION_RESOLVED_EDGE_ID.getPropertyValue((Element)termMention);
        Edge edge = this.graph.getEdge(edgeId, authorizations);
        if (edge == null) {
            throw new VisalloResourceNotFoundException("Could not find edge " + edgeId + " from term mention: " + termMentionId);
        }
        SandboxStatus vertexSandboxStatus = SandboxStatusUtil.getSandboxStatus((Element)resolvedVertex, (String)workspaceId);
        SandboxStatus edgeSandboxStatus = SandboxStatusUtil.getSandboxStatus((Element)edge, (String)workspaceId);
        if (vertexSandboxStatus == SandboxStatus.PUBLIC && edgeSandboxStatus == SandboxStatus.PUBLIC) {
            throw new BadRequestException("Can not unresolve a public entity");
        }
        if (vertexSandboxStatus == SandboxStatus.PUBLIC) {
            VisibilityJson visibilityJson = (VisibilityJson)VisalloProperties.VISIBILITY_JSON.getPropertyValue((Element)edge);
            VisibilityJson.removeFromWorkspace((VisibilityJson)visibilityJson, (String)workspaceId);
        } else {
            VisibilityJson visibilityJson = (VisibilityJson)VisalloProperties.VISIBILITY_JSON.getPropertyValue((Element)resolvedVertex);
            VisibilityJson.removeFromWorkspace((VisibilityJson)visibilityJson, (String)workspaceId);
        }
        this.workspaceHelper.unresolveTerm(termMention, authorizations);
        return VisalloResponse.SUCCESS;
    }
}

