/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.vertex;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.v5analytics.webster.ParameterizedHandler;
import com.v5analytics.webster.annotations.Handle;
import com.v5analytics.webster.annotations.Optional;
import com.v5analytics.webster.annotations.Required;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.vertexium.Authorizations;
import org.vertexium.Element;
import org.vertexium.Graph;
import org.vertexium.Vertex;
import org.vertexium.property.StreamingPropertyValue;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.exception.VisalloResourceNotFoundException;
import org.visallo.core.model.properties.MediaVisalloProperties;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.util.LimitInputStream;
import org.visallo.web.BadRequestException;
import org.visallo.web.VisalloResponse;

public class VertexRaw
implements ParameterizedHandler {
    private static final Pattern RANGE_PATTERN = Pattern.compile("bytes=([0-9]*)-([0-9]*)");
    private final Graph graph;

    @Inject
    public VertexRaw(Graph graph) {
        this.graph = graph;
    }

    @Handle
    public InputStream handle(HttpServletRequest request, @Required(name="graphVertexId") String graphVertexId, @Optional(name="download", defaultValue="false") boolean download, @Optional(name="playback", defaultValue="false") boolean playback, @Optional(name="type") String type, Authorizations authorizations, VisalloResponse response) throws Exception {
        Vertex artifactVertex = this.graph.getVertex(graphVertexId, authorizations);
        if (artifactVertex == null) {
            throw new VisalloResourceNotFoundException("Could not find vertex with id: " + graphVertexId);
        }
        String fileName = (String)VisalloProperties.FILE_NAME.getOnlyPropertyValue((Element)artifactVertex);
        if (playback) {
            return this.handlePartialPlayback(request, response, artifactVertex, fileName, type);
        }
        String mimeType = this.getMimeType(artifactVertex);
        response.setContentType(mimeType);
        response.setMaxAge(3600);
        String fileNameWithoutQuotes = fileName.replace('\"', '\'');
        if (download) {
            response.addHeader("Content-Disposition", "attachment; filename=\"" + fileNameWithoutQuotes + "\"");
        } else {
            response.addHeader("Content-Disposition", "inline; filename=\"" + fileNameWithoutQuotes + "\"");
        }
        StreamingPropertyValue rawValue = (StreamingPropertyValue)VisalloProperties.RAW.getPropertyValue((Element)artifactVertex);
        if (rawValue == null) {
            throw new VisalloResourceNotFoundException("Could not find raw on artifact: " + artifactVertex.getId());
        }
        return rawValue.getInputStream();
    }

    private InputStream handlePartialPlayback(HttpServletRequest request, VisalloResponse response, Vertex artifactVertex, String fileName, String type) throws IOException {
        if (type == null) {
            throw new BadRequestException("type is required for partial playback");
        }
        long partialStart = 0L;
        Long partialEnd = null;
        String range = request.getHeader("Range");
        if (range != null) {
            response.setStatus(206);
            Matcher m = RANGE_PATTERN.matcher(range);
            if (m.matches()) {
                partialStart = Long.parseLong(m.group(1));
                if (m.group(2).length() > 0) {
                    partialEnd = Long.parseLong(m.group(2));
                }
            }
        }
        response.setCharacterEncoding(null);
        response.setContentType(type);
        response.addHeader("Content-Disposition", "attachment; filename=" + fileName);
        StreamingPropertyValue mediaPropertyValue = this.getStreamingPropertyValue(artifactVertex, type);
        Long totalLength = mediaPropertyValue.getLength();
        InputStream in = mediaPropertyValue.getInputStream();
        if (partialEnd == null) {
            partialEnd = totalLength;
        }
        partialEnd = Math.min(partialEnd, totalLength - 1L);
        long partialLength = totalLength;
        if (range != null) {
            partialLength = partialEnd - partialStart + 1L;
            response.addHeader("Content-Range", "bytes " + partialStart + "-" + partialEnd + "/" + totalLength);
            if (partialStart > 0L) {
                in.skip(partialStart);
            }
        }
        response.addHeader("Content-Length", "" + partialLength);
        return new LimitInputStream(in, partialLength);
    }

    private StreamingPropertyValue getStreamingPropertyValue(Vertex artifactVertex, String type) {
        StreamingPropertyValue mediaPropertyValue;
        if ("audio/mp4".equals(type)) {
            mediaPropertyValue = (StreamingPropertyValue)MediaVisalloProperties.AUDIO_MP4.getPropertyValue((Element)artifactVertex);
            Preconditions.checkNotNull((Object)mediaPropertyValue, (Object)String.format("Could not find %s property on artifact %s", "audio/mp4", artifactVertex.getId()));
        } else if ("audio/ogg".equals(type)) {
            mediaPropertyValue = (StreamingPropertyValue)MediaVisalloProperties.AUDIO_OGG.getPropertyValue((Element)artifactVertex);
            Preconditions.checkNotNull((Object)mediaPropertyValue, (Object)String.format("Could not find %s property on artifact %s", "audio/ogg", artifactVertex.getId()));
        } else if ("video/mp4".equals(type)) {
            mediaPropertyValue = (StreamingPropertyValue)MediaVisalloProperties.VIDEO_MP4.getPropertyValue((Element)artifactVertex);
            Preconditions.checkNotNull((Object)mediaPropertyValue, (Object)String.format("Could not find %s property on artifact %s", "video/mp4", artifactVertex.getId()));
        } else if ("video/webm".equals(type)) {
            mediaPropertyValue = (StreamingPropertyValue)MediaVisalloProperties.VIDEO_WEBM.getPropertyValue((Element)artifactVertex);
            Preconditions.checkNotNull((Object)mediaPropertyValue, (Object)String.format("Could not find %s property on artifact %s", "video/webm", artifactVertex.getId()));
        } else {
            throw new VisalloException("Invalid video type: " + type);
        }
        return mediaPropertyValue;
    }

    private void copy(InputStream in, OutputStream out, Long length) throws IOException {
        int read;
        byte[] buffer = new byte[1024];
        while (length > 0L && (read = in.read(buffer, 0, (int)Math.min(length, (long)buffer.length))) > 0) {
            out.write(buffer, 0, read);
            length = length - (long)read;
        }
    }

    private String getMimeType(Vertex artifactVertex) {
        String mimeType = (String)VisalloProperties.MIME_TYPE.getOnlyPropertyValue((Element)artifactVertex);
        if (mimeType == null || mimeType.isEmpty()) {
            mimeType = "application/octet-stream";
        }
        return mimeType;
    }
}

