/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import javax.servlet.http.HttpSession;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.PerRequestBroadcastFilter;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.visallo.core.bootstrap.InjectHelper;
import org.visallo.core.model.user.UserRepository;
import org.visallo.core.util.JSONUtil;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.CurrentUser;

public class MessagingFilter
implements PerRequestBroadcastFilter {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(MessagingFilter.class);
    public static final String TYPE_SESSION_EXPIRATION = "sessionExpiration";
    public static final String TYPE_SET_ACTIVE_WORKSPACE = "setActiveWorkspace";
    private UserRepository userRepository;

    public BroadcastFilter.BroadcastAction filter(String broadcasterId, Object originalMessage, Object message) {
        return new BroadcastFilter.BroadcastAction(message);
    }

    public BroadcastFilter.BroadcastAction filter(String broadcasterId, AtmosphereResource r, Object originalMessage, Object message) {
        this.ensureInitialized();
        try {
            if (message == null || r.isCancelled()) {
                return new BroadcastFilter.BroadcastAction(BroadcastFilter.BroadcastAction.ACTION.ABORT, null);
            }
            JSONObject json = new JSONObject(message.toString());
            if (this.shouldSendMessage(json, r.getRequest().getSession())) {
                return new BroadcastFilter.BroadcastAction(message);
            }
            return new BroadcastFilter.BroadcastAction(BroadcastFilter.BroadcastAction.ACTION.ABORT, message);
        }
        catch (JSONException e) {
            LOGGER.error("Failed to filter message:\n" + originalMessage, (Throwable)e);
            return new BroadcastFilter.BroadcastAction(BroadcastFilter.BroadcastAction.ACTION.ABORT, message);
        }
    }

    boolean shouldSendMessage(JSONObject json, HttpSession session) {
        String type = json.optString("type", null);
        if (type != null) {
            switch (type) {
                case "setActiveWorkspace": {
                    return false;
                }
                case "sessionExpiration": {
                    if (session != null) break;
                    return true;
                }
            }
        }
        if (session == null) {
            return false;
        }
        return this.shouldSendMessageByPermissions(json, session);
    }

    private boolean shouldSendMessageByPermissions(JSONObject json, HttpSession session) {
        JSONObject permissionsJson = json.optJSONObject("permissions");
        if (permissionsJson != null) {
            if (this.shouldRejectMessageByUsers(permissionsJson, session)) {
                return false;
            }
            if (this.shouldRejectMessageToSessionIds(permissionsJson, session)) {
                return false;
            }
            if (this.shouldRejectMessageToWorkspaces(permissionsJson, session)) {
                return false;
            }
        }
        return true;
    }

    private boolean shouldRejectMessageToWorkspaces(JSONObject permissionsJson, HttpSession session) {
        JSONArray workspaces = permissionsJson.optJSONArray("workspaces");
        if (workspaces != null) {
            String currentUserId = CurrentUser.getUserId(session);
            if (currentUserId == null) {
                return true;
            }
            String currentWorkspaceId = this.userRepository.getCurrentWorkspaceId(currentUserId);
            if (currentWorkspaceId == null) {
                return true;
            }
            if (!JSONUtil.isInArray((JSONArray)workspaces, (Object)currentWorkspaceId)) {
                return true;
            }
        }
        return false;
    }

    private boolean shouldRejectMessageToSessionIds(JSONObject permissionsJson, HttpSession session) {
        JSONArray sessionIds = permissionsJson.optJSONArray("sessionIds");
        return sessionIds != null && !JSONUtil.isInArray((JSONArray)sessionIds, (Object)session.getId());
    }

    private boolean shouldRejectMessageByUsers(JSONObject permissionsJson, HttpSession session) {
        String currentUserId;
        JSONArray users = permissionsJson.optJSONArray("users");
        return users != null && (currentUserId = CurrentUser.getUserId(session)) != null && !JSONUtil.isInArray((JSONArray)users, (Object)currentUserId);
    }

    public void ensureInitialized() {
        if (this.userRepository == null) {
            InjectHelper.inject((Object)this);
            if (this.userRepository == null) {
                LOGGER.error("userRepository cannot be null", new Object[0]);
                Preconditions.checkNotNull((Object)this.userRepository, (Object)"userRepository cannot be null");
            }
        }
    }

    @Inject
    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }
}

