/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web;

import java.io.Serializable;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.visallo.core.bootstrap.InjectHelper;
import org.visallo.core.model.user.UserRepository;
import org.visallo.core.model.user.UserSessionCounterRepository;
import org.visallo.core.model.workQueue.WorkQueueRepository;
import org.visallo.core.user.User;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.clientapi.model.UserStatus;

public class SessionUser
implements HttpSessionBindingListener,
Serializable {
    private static final long serialVersionUID = -4886360466524045992L;
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(SessionUser.class);
    private String userId;

    public SessionUser(String userId) {
        this.userId = userId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void valueBound(HttpSessionBindingEvent event) {
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        try {
            UserSessionCounterRepository userSessionCounterRepository = (UserSessionCounterRepository)InjectHelper.getInstance(UserSessionCounterRepository.class);
            WorkQueueRepository workQueueRepository = (WorkQueueRepository)InjectHelper.getInstance(WorkQueueRepository.class);
            int sessionCount = userSessionCounterRepository.deleteSession(this.userId, event.getSession().getId());
            if (sessionCount < 1) {
                UserStatus status = UserStatus.OFFLINE;
                LOGGER.info("setting userId %s status to %s", new Object[]{this.userId, status});
                UserRepository userRepository = (UserRepository)InjectHelper.getInstance(UserRepository.class);
                User user = userRepository.setStatus(this.userId, status);
                workQueueRepository.pushUserStatusChange(user, status);
            }
            workQueueRepository.pushSessionExpiration(this.userId, event.getSession().getId());
        }
        catch (Exception ex) {
            LOGGER.error("exception while unbinding user session for userId:%s", new Object[]{this.userId, ex});
        }
    }
}

