/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web;

import com.asual.lesscss.LessEngine;
import com.asual.lesscss.LessOptions;
import com.v5analytics.webster.HandlerChain;
import com.v5analytics.webster.RequestResponseHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.Router;

public class StyleAppendableHandler
implements RequestResponseHandler {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(Router.class);
    private LessEngine lessCompiler;
    private final List<Resource> resources = new ArrayList<Resource>();

    public void handle(HttpServletRequest request, HttpServletResponse response, HandlerChain chain) throws Exception {
        response.setContentType("text/css");
        try (ServletOutputStream out = response.getOutputStream();){
            for (Resource resource : this.resources) {
                try {
                    resource.handle((OutputStream)out);
                    out.write("\n".getBytes());
                }
                catch (Exception e) {
                    LOGGER.error("Unable to process style resource: " + resource.getPath(), (Throwable)e);
                }
            }
        }
    }

    public void appendLessResource(String pathInfo) {
        this.resources.add(new LessResource(pathInfo));
    }

    public void appendCssResource(String pathInfo) {
        this.resources.add(new CssResource(pathInfo));
    }

    private synchronized LessEngine lessCompiler() {
        if (this.lessCompiler == null) {
            LessOptions options = new LessOptions();
            options.setCompress(true);
            options.setCharset("UTF-8");
            this.lessCompiler = new LessEngine(options);
        }
        return this.lessCompiler;
    }

    private class CssResource
    implements Resource {
        private String path;

        public CssResource(String path) {
            this.path = path;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public void handle(OutputStream out) throws IOException {
            try (InputStream in = this.getClass().getResourceAsStream(this.path);){
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
        }
    }

    private class LessResource
    implements Resource {
        private String path;

        public LessResource(String path) {
            this.path = path;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public void handle(OutputStream out) throws Exception {
            try (InputStream input = this.getClass().getResourceAsStream(this.path);
                 StringWriter writer = new StringWriter();){
                IOUtils.copy((InputStream)input, (Writer)writer, (Charset)StandardCharsets.UTF_8);
                String inputLess = writer.toString();
                String output = StyleAppendableHandler.this.lessCompiler().compile(inputLess);
                PrintWriter outWriter = new PrintWriter(out, true);
                outWriter.println(output);
            }
        }
    }

    private static interface Resource {
        public void handle(OutputStream var1) throws Exception;

        public String getPath();
    }
}

