/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.initializers;

import com.google.inject.Inject;
import javax.servlet.ServletContext;
import org.visallo.core.config.Configuration;
import org.visallo.core.externalResource.ExternalResourceRunner;
import org.visallo.core.model.user.UserRepository;
import org.visallo.core.status.StatusRepository;
import org.visallo.core.user.User;
import org.visallo.core.util.ShutdownListener;
import org.visallo.core.util.ShutdownService;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.initializers.ApplicationBootstrapInitializer;

public class ExternalResourceWorkersInitializer
extends ApplicationBootstrapInitializer
implements ShutdownListener {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(ExternalResourceWorkersInitializer.class);
    private final Configuration config;
    private final UserRepository userRepository;
    private final StatusRepository statusRepository;
    private ExternalResourceRunner resourceRunner;

    @Inject
    public ExternalResourceWorkersInitializer(Configuration config, UserRepository userRepository, StatusRepository statusRepository, ShutdownService shutdownService) {
        this.config = config;
        this.userRepository = userRepository;
        this.statusRepository = statusRepository;
        shutdownService.register((ShutdownListener)this);
    }

    @Override
    public void initialize(ServletContext context) {
        LOGGER.debug("setupExternalResourceWorkers", new Object[0]);
        User user = this.userRepository.getSystemUser();
        this.resourceRunner = new ExternalResourceRunner(this.config, this.statusRepository, user);
        this.resourceRunner.startAll();
    }

    public void shutdown() {
        if (this.resourceRunner != null) {
            this.resourceRunner.shutdown();
        }
    }
}

