/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.initializers;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import org.visallo.core.bootstrap.InjectHelper;
import org.visallo.core.config.Configuration;
import org.visallo.core.model.longRunningProcess.LongRunningProcessRunner;
import org.visallo.core.util.ShutdownListener;
import org.visallo.core.util.ShutdownService;
import org.visallo.core.util.StoppableRunnable;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.initializers.ApplicationBootstrapInitializer;

public class LongRunningProcessRunnerInitializer
extends ApplicationBootstrapInitializer
implements ShutdownListener {
    private static final String CONFIG_THREAD_COUNT = LongRunningProcessRunnerInitializer.class.getName() + ".threadCount";
    private static final int DEFAULT_THREAD_COUNT = 1;
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(LongRunningProcessRunnerInitializer.class);
    private final Configuration config;
    private final List<StoppableRunnable> stoppables = new ArrayList<StoppableRunnable>();

    @Inject
    public LongRunningProcessRunnerInitializer(Configuration config, ShutdownService shutdownService) {
        this.config = config;
        shutdownService.register((ShutdownListener)this);
    }

    @Override
    public void initialize(ServletContext context) {
        LOGGER.debug("Starting LongRunningProcessRunnerInitializer", new Object[0]);
        int threadCount = this.config.getInt(CONFIG_THREAD_COUNT, Integer.valueOf(1));
        LOGGER.debug("Starting LongRunningProcessRunners on %d threads", new Object[]{threadCount});
        for (int i = 0; i < threadCount; ++i) {
            StoppableRunnable stoppable = new StoppableRunnable(){
                private LongRunningProcessRunner longRunningProcessRunner = null;

                public void run() {
                    try {
                        this.longRunningProcessRunner = (LongRunningProcessRunner)InjectHelper.getInstance(LongRunningProcessRunner.class);
                        this.longRunningProcessRunner.prepare(LongRunningProcessRunnerInitializer.this.config.toMap());
                        this.longRunningProcessRunner.run();
                    }
                    catch (Exception ex) {
                        LOGGER.error("Failed running LongRunningProcessRunner", (Throwable)ex);
                    }
                }

                public void stop() {
                    try {
                        if (this.longRunningProcessRunner != null) {
                            LOGGER.debug("Stopping LongRunningProcessRunner", new Object[0]);
                            this.longRunningProcessRunner.stop();
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.error("Failed stopping LongRunningProcessRunner", (Throwable)ex);
                    }
                }
            };
            this.stoppables.add(stoppable);
            Thread t = new Thread((Runnable)stoppable);
            t.setName("long-running-process-runner-" + t.getId());
            t.setDaemon(true);
            LOGGER.debug("Starting LongRunningProcessRunner thread: %s", new Object[]{t.getName()});
            t.start();
        }
    }

    public void shutdown() {
        this.stoppables.forEach(StoppableRunnable::stop);
    }
}

