/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.parameterProviders;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.v5analytics.webster.App;
import com.v5analytics.webster.parameterProviders.ParameterProvider;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.vertexium.FetchHint;
import org.visallo.core.config.Configuration;
import org.visallo.core.exception.VisalloException;
import org.visallo.core.model.user.UserRepository;
import org.visallo.core.user.ProxyUser;
import org.visallo.core.user.User;
import org.visallo.web.CurrentUser;
import org.visallo.web.WebApp;

public abstract class VisalloBaseParameterProvider<T>
extends ParameterProvider<T> {
    public static final String VISALLO_WORKSPACE_ID_HEADER_NAME = "Visallo-Workspace-Id";
    public static final String VISALLO_SOURCE_GUID_HEADER_NAME = "Visallo-Source-Guid";
    private static final String LOCALE_LANGUAGE_PARAMETER = "localeLanguage";
    private static final String LOCALE_COUNTRY_PARAMETER = "localeCountry";
    private static final String LOCALE_VARIANT_PARAMETER = "localeVariant";
    private static final String VISALLO_TIME_ZONE_HEADER_NAME = "Visallo-TimeZone";
    private static final String TIME_ZONE_ATTRIBUTE_NAME = "timeZone";
    private static final String TIME_ZONE_PARAMETER_NAME = "timeZone";
    static final String USER_REQUEST_ATTRIBUTE_NAME = "user";
    static final String WORKSPACE_ID_ATTRIBUTE_NAME = "workspaceId";
    private final UserRepository userRepository;
    private final Configuration configuration;

    public VisalloBaseParameterProvider(UserRepository userRepository, Configuration configuration) {
        this.userRepository = userRepository;
        this.configuration = configuration;
    }

    protected static String getActiveWorkspaceIdOrDefault(HttpServletRequest request) {
        String workspaceId = (String)request.getAttribute(WORKSPACE_ID_ATTRIBUTE_NAME);
        if (!(workspaceId != null && workspaceId.trim().length() != 0 || (workspaceId = request.getHeader(VISALLO_WORKSPACE_ID_HEADER_NAME)) != null && workspaceId.trim().length() != 0 || (workspaceId = VisalloBaseParameterProvider.getOptionalParameter(request, WORKSPACE_ID_ATTRIBUTE_NAME)) != null && workspaceId.trim().length() != 0)) {
            return null;
        }
        return workspaceId;
    }

    protected static String getActiveWorkspaceId(HttpServletRequest request) {
        String workspaceId = VisalloBaseParameterProvider.getActiveWorkspaceIdOrDefault(request);
        if (workspaceId == null || workspaceId.trim().length() == 0) {
            throw new VisalloException("Visallo-Workspace-Id is a required header.");
        }
        return workspaceId;
    }

    protected static String getSourceGuid(HttpServletRequest request) {
        return request.getHeader(VISALLO_SOURCE_GUID_HEADER_NAME);
    }

    public static String getOptionalParameter(HttpServletRequest request, String parameterName) {
        Preconditions.checkNotNull((Object)request, (Object)"The provided request was invalid");
        return VisalloBaseParameterProvider.getParameter(request, parameterName, true);
    }

    public static String[] getOptionalParameterArray(HttpServletRequest request, String parameterName) {
        Preconditions.checkNotNull((Object)request, (Object)"The provided request was invalid");
        return VisalloBaseParameterProvider.getParameterValues(request, parameterName, true);
    }

    public static EnumSet<FetchHint> getOptionalParameterFetchHints(HttpServletRequest request, String parameterName, EnumSet<FetchHint> defaultFetchHints) {
        String val = VisalloBaseParameterProvider.getOptionalParameter(request, parameterName);
        if (val == null) {
            return defaultFetchHints;
        }
        return EnumSet.copyOf(Lists.transform(Arrays.asList(val.split(",")), (Function)new Function<String, FetchHint>(){

            public FetchHint apply(String input) {
                return FetchHint.valueOf((String)input);
            }
        }));
    }

    public static Integer getOptionalParameterInt(HttpServletRequest request, String parameterName, Integer defaultValue) {
        String val = VisalloBaseParameterProvider.getOptionalParameter(request, parameterName);
        if (val == null || val.length() == 0) {
            return defaultValue;
        }
        return Integer.parseInt(val);
    }

    public static String[] getOptionalParameterAsStringArray(HttpServletRequest request, String parameterName) {
        Preconditions.checkNotNull((Object)request, (Object)"The provided request was invalid");
        return VisalloBaseParameterProvider.getParameterValues(request, parameterName, true);
    }

    public static Float getOptionalParameterFloat(HttpServletRequest request, String parameterName, Float defaultValue) {
        String val = VisalloBaseParameterProvider.getOptionalParameter(request, parameterName);
        if (val == null || val.length() == 0) {
            return defaultValue;
        }
        return Float.valueOf(Float.parseFloat(val));
    }

    public static Double getOptionalParameterDouble(HttpServletRequest request, String parameterName, Double defaultValue) {
        String val = VisalloBaseParameterProvider.getOptionalParameter(request, parameterName);
        if (val == null || val.length() == 0) {
            return defaultValue;
        }
        return Double.parseDouble(val);
    }

    protected static String[] getParameterValues(HttpServletRequest request, String parameterName, boolean optional) {
        Object value;
        String[] paramValues = request.getParameterValues(parameterName);
        if (paramValues == null && (value = request.getAttribute(parameterName)) instanceof String[]) {
            paramValues = (String[])value;
        }
        if (paramValues == null) {
            if (!optional) {
                throw new RuntimeException(String.format("Parameter: '%s' is required in the request", parameterName));
            }
            return null;
        }
        return paramValues;
    }

    public static String[] getRequiredParameterArray(HttpServletRequest request, String parameterName) {
        Preconditions.checkNotNull((Object)request, (Object)"The provided request was invalid");
        return VisalloBaseParameterProvider.getParameterValues(request, parameterName, false);
    }

    public static String getRequiredParameter(HttpServletRequest request, String parameterName) {
        String result = VisalloBaseParameterProvider.getOptionalParameter(request, parameterName);
        if (result == null) {
            throw new VisalloException("parameter " + parameterName + " is required");
        }
        return result;
    }

    protected static String getParameter(HttpServletRequest request, String parameterName, boolean optional) {
        String paramValue = request.getParameter(parameterName);
        if (paramValue == null) {
            Object paramValueObject = request.getAttribute(parameterName);
            if (paramValueObject != null) {
                paramValue = paramValueObject.toString();
            }
            if (paramValue == null) {
                if (!optional) {
                    throw new VisalloException(String.format("Parameter: '%s' is required in the request", parameterName));
                }
                return null;
            }
        }
        return paramValue;
    }

    protected User getUser(HttpServletRequest request) {
        return VisalloBaseParameterProvider.getUser(request, this.getUserRepository());
    }

    public static User getUser(HttpServletRequest request, UserRepository userRepository) {
        ProxyUser user = (ProxyUser)request.getAttribute(USER_REQUEST_ATTRIBUTE_NAME);
        if (user != null) {
            return user;
        }
        String userId = CurrentUser.getUserId(request);
        if (userId == null) {
            return null;
        }
        user = new ProxyUser(userId, userRepository);
        request.setAttribute(USER_REQUEST_ATTRIBUTE_NAME, (Object)user);
        return user;
    }

    protected WebApp getWebApp(HttpServletRequest request) {
        return (WebApp)App.getApp((HttpServletRequest)request);
    }

    protected Locale getLocale(HttpServletRequest request) {
        String language = VisalloBaseParameterProvider.getOptionalParameter(request, LOCALE_LANGUAGE_PARAMETER);
        String country = VisalloBaseParameterProvider.getOptionalParameter(request, LOCALE_COUNTRY_PARAMETER);
        String variant = VisalloBaseParameterProvider.getOptionalParameter(request, LOCALE_VARIANT_PARAMETER);
        if (language != null) {
            return WebApp.getLocal(language, country, variant);
        }
        return request.getLocale();
    }

    protected String getTimeZone(HttpServletRequest request) {
        String timeZone = (String)request.getAttribute("timeZone");
        if (!(timeZone != null && timeZone.trim().length() != 0 || (timeZone = request.getHeader(VISALLO_TIME_ZONE_HEADER_NAME)) != null && timeZone.trim().length() != 0 || (timeZone = VisalloBaseParameterProvider.getOptionalParameter(request, "timeZone")) != null && timeZone.trim().length() != 0)) {
            timeZone = this.configuration.get("default.timeZone", TimeZone.getDefault().getDisplayName());
        }
        return timeZone;
    }

    public UserRepository getUserRepository() {
        return this.userRepository;
    }
}

