/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.admin;

import com.google.inject.Inject;
import com.v5analytics.webster.ParameterizedHandler;
import com.v5analytics.webster.annotations.Handle;
import com.v5analytics.webster.annotations.Optional;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Part;
import org.apache.commons.io.IOUtils;
import org.semanticweb.owlapi.model.IRI;
import org.vertexium.Authorizations;
import org.vertexium.util.FilterIterable;
import org.vertexium.util.IterableUtils;
import org.visallo.core.model.ontology.OntologyRepository;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.VisalloResponse;
import org.visallo.web.clientapi.model.ClientApiSuccess;

public class AdminUploadOntology
implements ParameterizedHandler {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(AdminUploadOntology.class);
    private final OntologyRepository ontologyRepository;

    @Inject
    public AdminUploadOntology(OntologyRepository ontologyRepository) {
        this.ontologyRepository = ontologyRepository;
    }

    @Handle
    public ClientApiSuccess handle(Authorizations authorizations, @Optional(name="documentIRI") String documentIRIString, HttpServletRequest request) throws Exception {
        List files = IterableUtils.toList(this.getFiles(request));
        if (files.size() != 1) {
            throw new RuntimeException("Wrong number of uploaded files. Expected 1 got " + files.size());
        }
        Part file = (Part)files.get(0);
        File tempFile = File.createTempFile("ontologyUpload", ".bin");
        this.writeToTempFile(file, tempFile);
        if (documentIRIString == null || documentIRIString.length() == 0) {
            documentIRIString = this.ontologyRepository.guessDocumentIRIFromPackage(tempFile);
        }
        IRI documentIRI = IRI.create((String)documentIRIString);
        LOGGER.info("adding ontology: %s", new Object[]{documentIRI.toString()});
        this.ontologyRepository.writePackage(tempFile, documentIRI, authorizations);
        this.ontologyRepository.clearCache();
        tempFile.delete();
        return VisalloResponse.SUCCESS;
    }

    private Iterable<Part> getFiles(HttpServletRequest request) throws IOException, ServletException {
        return new FilterIterable<Part>((Iterable)request.getParts()){

            protected boolean isIncluded(Part part) {
                return part.getName().equals("file");
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToTempFile(Part file, File tempFile) throws IOException {
        try (InputStream in = file.getInputStream();
             FileOutputStream out = new FileOutputStream(tempFile);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
    }
}

