/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.search;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.visallo.core.model.search.SearchOptions;

public class WebSearchOptionsFactory {
    public static SearchOptions create(HttpServletRequest request, String workspaceId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        WebSearchOptionsFactory.copyRequestAttributesToParameters(request, parameters);
        WebSearchOptionsFactory.copyRequestParametersToParameters(request, parameters);
        return new SearchOptions(parameters, workspaceId);
    }

    private static void copyRequestParametersToParameters(HttpServletRequest request, Map<String, Object> parameters) {
        Map requestParameters = request.getParameterMap();
        for (Map.Entry requestParameter : requestParameters.entrySet()) {
            String[] requestParameterValues = (String[])requestParameter.getValue();
            Object value = requestParameterValues.length == 0 ? null : (requestParameterValues.length == 1 ? requestParameterValues[0] : requestParameterValues);
            parameters.put((String)requestParameter.getKey(), value);
        }
    }

    private static void copyRequestAttributesToParameters(HttpServletRequest request, Map<String, Object> parameters) {
        Enumeration attributeNames = request.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            Object attributeValue = request.getAttribute(attributeName);
            parameters.put(attributeName, attributeValue);
        }
    }
}

