/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.user;

import com.google.inject.Inject;
import com.v5analytics.webster.ParameterizedHandler;
import com.v5analytics.webster.annotations.Handle;
import com.v5analytics.webster.handlers.CSRFHandler;
import javax.servlet.http.HttpServletRequest;
import org.visallo.core.model.user.UserRepository;
import org.visallo.core.model.workspace.WorkspaceRepository;
import org.visallo.core.user.User;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.clientapi.model.ClientApiUser;

public class MeGet
implements ParameterizedHandler {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(MeGet.class);
    private final UserRepository userRepository;
    private final WorkspaceRepository workspaceRepository;

    @Inject
    public MeGet(UserRepository userRepository, WorkspaceRepository workspaceRepository) {
        this.userRepository = userRepository;
        this.workspaceRepository = workspaceRepository;
    }

    @Handle
    public ClientApiUser handle(HttpServletRequest request, User user) throws Exception {
        ClientApiUser userMe = this.userRepository.toClientApiPrivate(user);
        userMe.setCsrfToken(CSRFHandler.getSavedToken((HttpServletRequest)request, (boolean)true));
        try {
            if (userMe.getCurrentWorkspaceId() != null && userMe.getCurrentWorkspaceId().length() > 0 && !this.workspaceRepository.hasReadPermissions(userMe.getCurrentWorkspaceId(), user)) {
                userMe.setCurrentWorkspaceId(null);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Failed to read user's current workspace %s", new Object[]{user.getCurrentWorkspaceId(), ex});
            userMe.setCurrentWorkspaceId(null);
        }
        return userMe;
    }
}

