/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.vertex;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.v5analytics.webster.ParameterizedHandler;
import com.v5analytics.webster.annotations.Handle;
import com.v5analytics.webster.annotations.Optional;
import com.v5analytics.webster.annotations.Required;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.vertexium.Authorizations;
import org.vertexium.Element;
import org.vertexium.Graph;
import org.vertexium.Vertex;
import org.vertexium.property.StreamingPropertyValue;
import org.visallo.core.EntityHighlighter;
import org.visallo.core.exception.VisalloResourceNotFoundException;
import org.visallo.core.ingest.video.VideoTranscript;
import org.visallo.core.model.properties.MediaVisalloProperties;
import org.visallo.core.model.properties.VisalloProperties;
import org.visallo.core.model.termMention.TermMentionRepository;
import org.visallo.core.user.User;
import org.visallo.core.util.JsonSerializer;
import org.visallo.core.util.VisalloLogger;
import org.visallo.core.util.VisalloLoggerFactory;
import org.visallo.web.VisalloResponse;
import org.visallo.web.parameterProviders.ActiveWorkspaceId;

public class VertexHighlightedText
implements ParameterizedHandler {
    private static final VisalloLogger LOGGER = VisalloLoggerFactory.getLogger(VertexHighlightedText.class);
    private final Graph graph;
    private final EntityHighlighter entityHighlighter;
    private final TermMentionRepository termMentionRepository;

    @Inject
    public VertexHighlightedText(Graph graph, EntityHighlighter entityHighlighter, TermMentionRepository termMentionRepository) {
        this.graph = graph;
        this.entityHighlighter = entityHighlighter;
        this.termMentionRepository = termMentionRepository;
    }

    @Handle
    public String handle(@Required(name="graphVertexId") String graphVertexId, @Required(name="propertyKey") String propertyKey, @Optional(name="propertyName") String propertyName, @ActiveWorkspaceId String workspaceId, User user, Authorizations authorizations, VisalloResponse response) throws Exception {
        StreamingPropertyValue textPropertyValue;
        Authorizations authorizationsWithTermMention = this.termMentionRepository.getAuthorizations(authorizations);
        Vertex artifactVertex = this.graph.getVertex(graphVertexId, authorizations);
        if (artifactVertex == null) {
            throw new VisalloResourceNotFoundException("Could not find vertex with id: " + graphVertexId);
        }
        if (Strings.isNullOrEmpty((String)propertyName)) {
            propertyName = VisalloProperties.TEXT.getPropertyName();
        }
        if ((textPropertyValue = (StreamingPropertyValue)artifactVertex.getPropertyValue(propertyKey, propertyName)) != null) {
            String highlightedText;
            LOGGER.debug("returning text for vertexId:%s property:%s", new Object[]{artifactVertex.getId(), propertyKey});
            String text = IOUtils.toString((InputStream)textPropertyValue.getInputStream(), (String)"UTF-8");
            if (text == null) {
                highlightedText = "";
            } else {
                Iterable termMentions = this.termMentionRepository.findByOutVertexAndProperty(artifactVertex.getId(), propertyKey, propertyName, authorizationsWithTermMention);
                highlightedText = this.entityHighlighter.getHighlightedText(text, termMentions, workspaceId, authorizationsWithTermMention);
            }
            response.setContentType("text/html");
            return highlightedText;
        }
        VideoTranscript videoTranscript = (VideoTranscript)MediaVisalloProperties.VIDEO_TRANSCRIPT.getPropertyValue((Element)artifactVertex, propertyKey);
        if (videoTranscript != null) {
            LOGGER.debug("returning video transcript for vertexId:%s property:%s", new Object[]{artifactVertex.getId(), propertyKey});
            Iterable termMentions = this.termMentionRepository.findByOutVertexAndProperty(artifactVertex.getId(), propertyKey, propertyName, authorizations);
            VideoTranscript highlightedVideoTranscript = this.entityHighlighter.getHighlightedVideoTranscript(videoTranscript, termMentions, workspaceId, authorizations);
            response.setContentType("application/json");
            return highlightedVideoTranscript.toJson().toString();
        }
        videoTranscript = JsonSerializer.getSynthesisedVideoTranscription((Vertex)artifactVertex, (String)propertyKey);
        if (videoTranscript != null) {
            LOGGER.debug("returning synthesised video transcript for vertexId:%s property:%s", new Object[]{artifactVertex.getId(), propertyKey});
            Iterable termMentions = this.termMentionRepository.findByOutVertexAndProperty(artifactVertex.getId(), propertyKey, propertyName, authorizations);
            VideoTranscript highlightedVideoTranscript = this.entityHighlighter.getHighlightedVideoTranscript(videoTranscript, termMentions, workspaceId, authorizationsWithTermMention);
            response.setContentType("application/json");
            return highlightedVideoTranscript.toJson().toString();
        }
        return null;
    }
}

