/*
 * Decompiled with CFR 0.152.
 */
package org.visallo.web.routes.workspace;

import com.google.inject.Inject;
import com.v5analytics.webster.ParameterizedHandler;
import com.v5analytics.webster.annotations.Handle;
import java.util.Iterator;
import java.util.List;
import org.vertexium.Authorizations;
import org.vertexium.Graph;
import org.vertexium.util.LookAheadIterable;
import org.visallo.core.model.workspace.Workspace;
import org.visallo.core.model.workspace.WorkspaceEntity;
import org.visallo.core.model.workspace.WorkspaceRepository;
import org.visallo.core.user.User;
import org.visallo.core.util.ClientApiConverter;
import org.visallo.web.clientapi.model.ClientApiWorkspaceVertices;
import org.visallo.web.parameterProviders.ActiveWorkspaceId;

public class WorkspaceVertices
implements ParameterizedHandler {
    private final Graph graph;
    private final WorkspaceRepository workspaceRepository;

    @Inject
    public WorkspaceVertices(Graph graph, WorkspaceRepository workspaceRepository) {
        this.graph = graph;
        this.workspaceRepository = workspaceRepository;
    }

    @Handle
    public ClientApiWorkspaceVertices handle(User user, Authorizations authorizations, @ActiveWorkspaceId String workspaceId) throws Exception {
        Workspace workspace = this.workspaceRepository.findById(workspaceId, user);
        List workspaceEntities = this.workspaceRepository.findEntities(workspace, user);
        LookAheadIterable<WorkspaceEntity, String> vertexIds = this.getVisibleWorkspaceEntityIds(workspaceEntities);
        Iterable graphVertices = this.graph.getVertices(vertexIds, ClientApiConverter.SEARCH_FETCH_HINTS, authorizations);
        ClientApiWorkspaceVertices results = new ClientApiWorkspaceVertices();
        results.getVertices().addAll(ClientApiConverter.toClientApiVertices((Iterable)graphVertices, (String)workspaceId, (Authorizations)authorizations));
        return results;
    }

    private LookAheadIterable<WorkspaceEntity, String> getVisibleWorkspaceEntityIds(final List<WorkspaceEntity> workspaceEntities) {
        return new LookAheadIterable<WorkspaceEntity, String>(){

            protected boolean isIncluded(WorkspaceEntity workspaceEntity, String entityVertexId) {
                return workspaceEntity.isVisible();
            }

            protected String convert(WorkspaceEntity workspaceEntity) {
                return workspaceEntity.getEntityVertexId();
            }

            protected Iterator<WorkspaceEntity> createIterator() {
                return workspaceEntities.iterator();
            }
        };
    }
}

